/* Copyright (C) 2002, 2003, 2004, 2005, 2006 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#include <mysql/mysqld_error.h>
#include "mysqlDatabase.hpp"
#include "mysqlStatement.hpp"

using namespace std;

MySQLDatabase::MySQLDatabase( MySQLServerPtr _server,
                              const std::string &_databaseName ) throw (Error):
  Database( _server ), databaseName(_databaseName)
{
  _server->connect( databaseName, &connection );
}

MySQLDatabase::~MySQLDatabase(void)
{
  mysql_close( &connection );
}

StatementPtr MySQLDatabase::execQuery( const std::string &query ) throw (Error)
{
  StatementPtr retVal( new MySQLStatement( this, query ) );
  return retVal;
}
