/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you want to add, delete, or rename functions or slots, use
** Qt Designer to update this file, preserving your code.
**
** You should not define a constructor or destructor in this file.
** Instead, write your code in functions called init() and destroy().
** These will automatically be called by the form's constructor and
** destructor.
*****************************************************************************/


void ImportRecipeMLDialog::openRecipeMLFile()
{
  std::string startAt;
  /* if ( databaseWizard ) {
    std::string fileName( (const char *)i18n( "scripts/english.utf8.mmf" ) );
    startAt = findAnyMealFile( "appdata", fileName.c_str() );
    if ( startAt == fileName )
      startAt = ":import";
      } else */
    startAt = ":import";

  QStringList fileNames =
    KFileDialog::getOpenFileNames( startAt,
                                   i18n( "*.recipeml *.xml|RecipeML (*.recipeml *.xml)\n"
                                         "*|All Files (*)" ),
                                   this,
                                   i18n( "Import RecipeML Files" ) );
  
  if ( !fileNames.empty() ) {
    for ( int i=0; i<(signed)fileNames.size(); i++ )
      recipeMLListBox->insertItem( fileNames[i] );
      updateEnableState();
  };
  
}


void ImportRecipeMLDialog::openRecipeMLDir()
{
  QString folder =
    KFileDialog::getExistingDirectory( ":import",
                                       this,
                                       i18n( "Import RecipeML folder" ) );
  if ( folder != QString::null ) {
    recipeMLListBox->insertItem( folder );
    updateEnableState();
  };
}

void ImportRecipeMLDialog::openErrorDir()
{
  // Select file for saving erroneous Mealmaster recipes to.
  QString dirName =
    KFileDialog::getExistingDirectory( ":export",
                                       this,
                                       i18n( "Store Erroneous RecipeML Recipes" ) );

  if ( dirName != QString::null ) {
    errorDirNameEdit->setText( dirName );
    updateEnableState();
  };
}


void ImportRecipeMLDialog::updateEnableState()
{
  bool okButtonEnable =
    recipeMLListBox->firstItem() != NULL &&
    ( !storeErroneousRadio->isChecked() ||
      !errorDirNameEdit->text().isEmpty() );
  okButton->setEnabled( okButtonEnable );
}

void ImportRecipeMLDialog::accept()
{
  DIR *dir = 0;
  try {
    
    assert( cookBook );

    DisplayWaitCursor w;

    // Create list of file names of the files to read.
    std::list< std::string > fileNames;
    for ( int i=0; i<(signed)recipeMLListBox->count(); i++ ) {
      std::string name( recipeMLListBox->text( i ).latin1() );
      if ( testFile( name ) == EISDIR ) {
        dir = opendir( name.c_str() );
        ERRORMACRO( dir != 0, Error, ,
                    "Error accessing directory \"" << name << "\": "
                    << strerror( errno ) );
        struct dirent *entry = 0;
        errno = 0;
        while ( ( entry = readdir( dir ) ) != 0 ) {
          if ( testFile( name + "/" + entry->d_name ) != EISDIR )
            fileNames.push_back( name );
          errno = 0;
        };
        ERRORMACRO( errno == 0, Error, ,
                    "Error reading entry from directory \"" << name << "\": "
                    << strerror( errno ) );
      } else
        fileNames.push_back( name );
    };

    // Set empty result.
    recipeMLToRecipe->setEmptyResult
      ( "<?xml version='1.0' encoding='UTF-8'?>\n"
        "<insert/>" );

    // Set up error-handler.
    XSLParseErrorHandlerPtr parseErrorHandler;
    if ( storeErroneousRadio->isChecked() )
      parseErrorHandler = XSLParseErrorHandlerPtr( new XSLParseErrorHandler );

    else if ( abortOnErrorRadio->isChecked() )
      parseErrorHandler = XSLParseErrorHandlerPtr( new XSLParseErrorHandler );
    else
      parseErrorHandler = XSLParseErrorHandlerPtr( new XSLIgnoreErrorHandler );
    recipeMLToRecipe->setParseErrorHandler( parseErrorHandler );

    // Open progress dialog.
    QProgressDialog progress( i18n( "Importing RecipeML files ... " ),
                              i18n( "&Cancel" ), fileNames.size(), this,
                              "progress", true );

    // Start reading files.
    int c = 0;
    for ( std::list< std::string >::const_iterator i=fileNames.begin();
          i != fileNames.end(); i++ ) {

      // Display info.
      progress.setProgress( c++ );
      ERRORMACRO( !progress.wasCanceled(), Error, ,
                  i18n( "Import aborted." ) );

      progress.setLabelText( i18n( "Importing file \"%1\" ..." ).
                             arg( i->c_str() ) );

      // Parse a file.
      std::ifstream inputFile( i->c_str(), std::ios::binary );
      std::ofstream nullDevice( "/dev/null" );
      ChainedCompiler
        ( recipeMLToRecipe,
          cookBook->getXMLLayer() ).translate( inputFile, nullDevice );

    };

    QDialog::accept();

  } catch ( Error &e ) {

    if ( dir != 0 ) closedir( dir );
    KMessageBox::error( this, e.what() );
    QDialog::reject();

  };

  // Restore error-handler.
  recipeMLToRecipe->setParseErrorHandler
    ( XSLParseErrorHandlerPtr( new XSLParseErrorHandler ) );
  // Reset empty result,
  recipeMLToRecipe->setEmptyResult( "" );
}
