/****************************************************************************
** ui.h extension file, included from the uic-generated form implementation.
**
** If you wish to add, delete or rename functions or slots use
** Qt Designer which will update this file, preserving your code. Create an
** init() function in place of a constructor, and a destroy() function in
** place of a destructor.
*****************************************************************************/


void DestroyDialog::init()
{
  assert( serverTypeCombo->text( 0 ) == i18n( "Network" ) );
  assert( serverTypeCombo->text( 1 ) == i18n( "Embedded" ) );
  const char *home = getenv( "HOME" );
  if ( home != NULL )
    socketEdit->setText( QString( home ) +
                         "/.kde/share/apps/anymeal/db/mysql.sock" );
  serverWidgetStack->raiseWidget( serverTypeCombo->currentItem() );
}

void DestroyDialog::updateOkEnabled()
{
  okButton->setEnabled
    ( !databaseEdit->text().isEmpty() &&
      !sourceKey().isEmpty() &&
      !rootUserEdit->text().isEmpty() && 
      ( !rootPassWordCheckBox->isChecked() ||
        !rootPassWordEdit->text().isEmpty() ) );
}


void DestroyDialog::selectSocket()
{
  QString fileName =
    KFileDialog::getOpenFileName( ":dbfolder",
                                  i18n( "*.sock|Socket (*.sock)\n"
                                        "*|All Files(*)" ),
                                  this,
                                  i18n( "Select database socket" ) );
  if ( fileName != QString::null ) {
    socketEdit->setText( fileName );
  };
}

QString DestroyDialog::sourceKey()
{
  return serverTypeCombo->currentItem() == 0 ?
    serverEdit->text() :
    socketEdit->text();
}


void DestroyDialog::setSocket( const QString &socket )
{
  std::string socketstr( (const char *)socket );
  unsigned int pos = socketstr.find_last_of( "/" );
  if ( pos != std::string::npos )
    folderEdit->setText( std::string( socketstr, 0, pos ).c_str() );
}
