// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#include "poa.h"
#include "clp.h"

// Create 3 lists with all Objects.
std::list<Filter *> poa::filter_list;
std::list<AddrFilter *> poa::addrfilter_list;
std::list<Analyse *> poa::analyse_list;
std::list<Report *> poa::report_list;
std::list<Plugin *> poa::plugin_list;
// Full list.
std::map<std::string, Parameter *> poa::object_map;

void poa::addObject( Filter * no )
{
	if ( object_map.find( no->Prefix() ) == object_map.end() )
	{
		object_map[ no->Prefix() ] = no;
		filter_list.push_back( no );
		clp::scanAllParameter( ( *no ) );
	}
	else
	{
		std::cerr << "Error: Can't add Object " << no->Prefix() << "." << std::endl;
		std::cerr << "  Another object with the same prefix exist already!" << std::endl;
	};
};

void poa::addObject( AddrFilter * no )
{
	if ( object_map.find( no->Prefix() ) == object_map.end() )
	{
		object_map[ no->Prefix() ] = no;
		addrfilter_list.push_back( no );
		clp::scanAllParameter( ( *no ) );
	}
	else
	{
		std::cerr << "Error: Can't add Object " << no->Prefix() << "." << std::endl;
		std::cerr << "  Another object with the same prefix exist already!" << std::endl;
	};
};

void poa::addObject( Analyse * no )
{
	if ( object_map.find( no->Prefix() ) == object_map.end() )
	{
		analyse_list.push_back( no );
		object_map[ no->Prefix() ] = no;
		clp::scanAllParameter( ( *no ) );
	}
	else
	{
		std::cerr << "Error: Can't add Object " << no->Prefix() << "." << std::endl;
		std::cerr << "  Another object with the same prefix exist already!" << std::endl;
	};
};

void poa::addObject( Report * no )
{
	if ( object_map.find( no->Prefix() ) == object_map.end() )
	{
		report_list.push_back( no );
		object_map[ no->Prefix() ] = no;
		clp::scanAllParameter( ( *no ) );
	}
	else
	{
		std::cerr << "Error: Can't add Object " << no->Prefix() << "." << std::endl;
		std::cerr << "  Another object with the same prefix exist already!" << std::endl;
	};
};

void poa::addObject( Plugin * no )
{
	if ( object_map.find( no->Prefix() ) == object_map.end() )
	{
		// Plugin zeiger bergeben.
		no->setPointer( &filter_list, &addrfilter_list, &analyse_list, &report_list, &plugin_list );
		if ( no->pa() & Plugin::PA_BEFORE_PARAM )
		{
			no->beforeParam(); // Evt. jetzt noch parameter hinzufgen oder lschen...
		}
		plugin_list.push_back( no );
		object_map[ no->Prefix() ] = no;
		clp::scanAllParameter( ( *no ) );
	}
	else
	{
		std::cerr << "Error: Can't add Object " << no->Prefix() << "." << std::endl;
		std::cerr << "  Another object with the same prefix exist already!" << std::endl;
	};
};

bool poa::existObject( const std::string &prefix )
{
	return ( object_map.find( prefix ) != object_map.end() );
};

void poa::dumpOP_List( Parameter * p, const bool html )
{
	if ( html )
	{
		std::cout << "    <li>" << p->Prefix() << "</li>" << std::endl;
		std::cout << "    <ul compact>" << std::endl;
		std::map< std::string, Parameter::param_t >::iterator i;
		for ( i = p->Param().begin(); i != p->Param().end(); i++ )
		{
			std::cout << "      <li><dl compact><dt>" << i->first.c_str() << "</dt>";
			std::cout << "<dd><dl compact><dt>Info:</dt><dd>\"" << i->second.Info.c_str() << "\"</dd>";
			std::cout << "<dt>Help:</dt><dd>\"" << i->second.Help.c_str() << "\"</dd>";
			std::cout << "<dt>Type:</dt><dd>";
			switch ( i->second.Typ )
			{
				case Parameter::G_FLAG:
					std::cout << "Global Flag" << std::endl; break;
				case Parameter::G_STRING:
					std::cout << "Global String" << std::endl; break;
				case Parameter::G_INTEGER:
					std::cout << "Global Integer" << std::endl; break;
				case Parameter::G_DATE:
					std::cout << "Global Date" << std::endl; break;
				case Parameter::FLAG:
					std::cout << "Flag" << std::endl; break;
				case Parameter::STRING:
					std::cout << "String" << std::endl; break;
				case Parameter::INTEGER:
					std::cout << "Integer" << std::endl; break;
				case Parameter::DATE:
					std::cout << "Date" << std::endl; break;
			}
			std::cout << "</dd><dt>Value:</dt><dd>\"" << i->second.Value.c_str() << "\"</dd></dl>";
			std::cout << "</dd></dl></li>" << std::endl;
		}
		std::cout << "    </ul>" << std::endl;
	}
	else
	{
		std::map< std::string, Parameter::param_t >::iterator i;
		for ( i = p->Param().begin(); i != p->Param().end(); i++ )
		{
			std::cout << "  --" << p->Prefix() << "-" << i->first.c_str() << std::endl;
			std::cout << "    Info....: " << i->second.Info.c_str() << std::endl;
			std::cout << "    Help....: " << i->second.Help.c_str() << std::endl;
			std::cout << "    Type....: ";
			switch ( i->second.Typ )
			{
				case Parameter::G_FLAG:
					std::cout << "Global Flag" << std::endl; break;
				case Parameter::G_STRING:
					std::cout << "Global String" << std::endl; break;
				case Parameter::G_INTEGER:
					std::cout << "Global Integer" << std::endl; break;
				case Parameter::G_DATE:
					std::cout << "Global Date" << std::endl; break;
				case Parameter::FLAG:
					std::cout << "Flag" << std::endl; break;
				case Parameter::STRING:
					std::cout << "String" << std::endl; break;
				case Parameter::INTEGER:
					std::cout << "Integer" << std::endl; break;
				case Parameter::DATE:
					std::cout << "Date" << std::endl; break;
			}
			std::cout << "    Value...: " << i->second.Value.c_str() << std::endl;
			std::cout << std::endl;
		}
	}
}

/** List all Objects, with all Parameters and the Actual Value of the Parameter.
 */
void poa::dumpObjectParameter( const bool html )
{
	if ( !html )
	{
		std::cout << "Anteater V " VERSION " - module overview" << std::endl;
		std::cout << "==============================================================================" << std::endl;
		std::cout << std::endl;
		std::cout << "FILTER" << std::endl;
		std::cout << "------------------------------------------------------------------------------" << std::endl;
		std::cout << std::endl;
		std::list< Filter * >::iterator fi;
		for ( fi = filter_list.begin(); fi != filter_list.end(); fi++ )
		{
			dumpOP_List( ( *fi ), html );
		}
		std::cout << std::endl;
		std::cout << "ADDRESS FILTER" << std::endl;
		std::cout << "------------------------------------------------------------------------------" << std::endl;
		std::cout << std::endl;
		std::list< AddrFilter * >::iterator di;
		for ( di = addrfilter_list.begin(); di != addrfilter_list.end(); di++ )
		{
			dumpOP_List( ( *di ), html );
		}
		std::cout << std::endl;
		std::cout << "ANALYSE" << std::endl;
		std::cout << "------------------------------------------------------------------------------" << std::endl;
		std::cout << std::endl;
		std::list< Analyse * >::iterator ai;
		for ( ai = analyse_list.begin(); ai != analyse_list.end(); ai++ )
		{
			dumpOP_List( ( *ai ), html );
		}
		std::cout << std::endl;
		std::cout << "REPORT" << std::endl;
		std::cout << "------------------------------------------------------------------------------" << std::endl;
		std::cout << std::endl;
		std::list< Report * >::iterator ri;
		for ( ri = report_list.begin(); ri != report_list.end(); ri++ )
		{
			dumpOP_List( ( *ri ), html );
		}
		std::cout << std::endl;
		std::cout << "PLUGIN" << std::endl;
		std::cout << "------------------------------------------------------------------------------" << std::endl;
		std::cout << std::endl;
		std::list< Plugin * >::iterator pi;
		for ( pi = plugin_list.begin(); pi != plugin_list.end(); pi++ )
		{
			dumpOP_List( ( *pi ), html );
		}
		std::cout << std::endl;
		std::cout << "==============================================================================" << std::endl;
	}
	else
	{
		std::cout << "<html>" << std::endl << "<head>" << std::endl;
		std::cout << "  <title>Anteater V" VERSION " - module overview</title>" << std::endl;
		std::cout << "</head>" << std::endl;
		std::cout << "<body>" << std::endl;
		std::cout << "<h1>Anteater V" VERSION " - module overview</h1>" << std::endl;

		// Generate List;
		std::cout << "<ul>" << std::endl;
		std::cout << "  <li>Filter</li>" << std::endl;
		std::cout << "  <ul compact>" << std::endl;
		std::list< Filter * >::iterator fi;
		for ( fi = filter_list.begin(); fi != filter_list.end(); fi++ )
		{
			dumpOP_List( ( *fi ), html );
		}
		std::cout << "  </ul>" << std::endl;
		std::cout << "  <li>Address Filter</li>" << std::endl;
		std::cout << "  <ul compact>" << std::endl;
		std::list< AddrFilter * >::iterator di;
		for ( di = addrfilter_list.begin(); di != addrfilter_list.end(); di++ )
		{
			dumpOP_List( ( *di ), html );
		}
		std::cout << "  </ul>" << std::endl;
		std::cout << "  <li>Analyse</li>" << std::endl;
		std::cout << "  <ul compact>" << std::endl;
		std::list< Analyse * >::iterator ai;
		for ( ai = analyse_list.begin(); ai != analyse_list.end(); ai++ )
		{
			dumpOP_List( ( *ai ), html );
		}
		std::cout << "  </ul>" << std::endl;
		std::cout << "  <li>Report</li>" << std::endl;
		std::cout << "  <ul compact>" << std::endl;
		std::list< Report * >::iterator ri;
		for ( ri = report_list.begin(); ri != report_list.end(); ri++ )
		{
			dumpOP_List( ( *ri ), html );
		}
		std::cout << "  </ul>" << std::endl;
		std::cout << "  <li>Plugin</li>" << std::endl;
		std::cout << "  <ul compact>" << std::endl;
		std::list< Plugin * >::iterator pi;
		for ( pi = plugin_list.begin(); pi != plugin_list.end(); pi++ )
		{
			dumpOP_List( ( *pi ), html );
		}
		std::cout << "  </ul>" << std::endl;
		std::cout << "</ul>" << std::endl;

		std::cout << "</body>" << std::endl << "</html>" << std::endl;
	}
}

bool poa::initPlugins( void )
{
	return execPlugin( &Plugin::init, Plugin::PA_INIT, "init" );
}

bool poa::filterPlugins( void )
{
	return execPlugin( &Plugin::filter, Plugin::PA_FILTER, "filter" );
}

bool poa::analysePlugins( void )
{
	return execPlugin( &Plugin::analyse, Plugin::PA_ANALYSE, "analyse" );
}

bool poa::freePlugins( void )
{
	return execPlugin( &Plugin::free, Plugin::PA_FREE, "free" );
}

bool poa::execPlugin( Plugin::ps_e( Plugin::*fp )( void ), Plugin::pa_e pa, const std::string &name )
{
	std::list<Plugin *>::iterator i;
	Plugin::ps_e status;

	for ( i = plugin_list.begin(); i != plugin_list.end(); i++ )
	{
		if ( ( *i )->pa() & pa )
		{
			status = ( ( *i )->*fp )(); // WARNING! leave this untouched until you understand it.

			if ( status == Plugin::PS_STOP )
			{
				std::cerr << "Plugin " << ( *i ) ->Prefix() << " status stop on " << name << "." << std::endl;
				return false;
			};
			if ( ( status == Plugin::PS_ENABLE || status == Plugin::PS_DISABLE ) && ( pa != Plugin::PA_INIT ) )    // hack!
			{
				std::cerr << "Plugin " << ( *i ) ->Prefix() << " status enable|disable [wrong!] on " << name << "." << std::endl;
				std::cerr << " Allowed status returncodes on " << name << " are only stop and continue." << std::endl;
				return false;
			};
		}
	}
	return true;
}

