// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#ifndef FILTERPLUGIN_H
#define FILTERPLUGIN_H
#ifdef _MSC_VER
#include "win32/config_win32.h"
#endif
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "plugin.h"

/** This plugin controls the selection of the Filter. And execute all
  * adressfilters.
  *@short Filter selection and adressfilter plugin.
  *@author Tobias Erbsland
  */
class filterPlugin : public Plugin
{
private:
	const char * const strPrefix;
	const char * const strName;
	const char * const strVersion;
	const char * const strAuthor;
	const char * const strHelp;

	bool disable_addrfilter;

public:
	filterPlugin();

	virtual const char * Prefix( void ) const { return strPrefix; };
	virtual const char * Name( void ) const { return strName; };
	virtual const char * Version( void ) const { return strVersion; };
	virtual const char * Author( void ) const { return strAuthor; };
	virtual const char * Help( void ) const { return strHelp; };

	virtual int pa( void ) { return PA_BEFORE_PARAM | PA_INIT | PA_FILTER; };
	virtual void beforeParam( void );

	virtual ps_e init( void );
	virtual ps_e filter( void );
	virtual bool addrFilter( std::string &addr );

	virtual ~filterPlugin();
};

#endif
