// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#ifndef ALIASESADDRFILTER_H
#define ALIASESADDRFILTER_H
#ifdef _MSC_VER
#include "win32/config_win32.h"
#endif
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <map>
#include <list>
#include <string>
#include "addrfilter.h"

/** Adressfilter reading the aliases file and convert adresses with rules
  * from this file.
  *@short Adressfilter for the aliases file.
  *@author Tobias Erbsland
  */
class aliasesAddrFilter : public AddrFilter
{
private:
	const char * const strPrefix;
	const char * const strName;
	const char * const strVersion;
	const char * const strAuthor;
	const char * const strHelp;

	std::map<std::string, std::string> alias_map;
	std::list<std::string> domain_list;
	int scramble;

public:
	aliasesAddrFilter();

	virtual const char * Prefix( void ) const { return strPrefix; };
	virtual const char * Name( void ) const { return strName; };
	virtual const char * Version( void ) const { return strVersion; };
	virtual const char * Author( void ) const { return strAuthor; };
	virtual const char * Help( void ) const { return strHelp; };

	virtual bool init( void );
	virtual bool checkAddr( std::string &addr );

	virtual ~aliasesAddrFilter();
};

#endif
