//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

//Systemwide includes
#include <qdialog.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qtextedit.h>
#include <qfont.h>
#include <qpushbutton.h>
#include <qpixmap.h>

//Projectwide includes
#include "questionDialog.h"
#include "../../config.h"

//==============================================
QuestionDialog::QuestionDialog( QString question,
                                              QString message,
                                              QString questionIconName,
                                              QWidget* parent,
                                              const char* name ) :
                                              QDialog(parent, name, true )
{
  //-------------------------------
  //create widgets
  topFrame = new QFrame( this );

  questionText = new QLabel( topFrame );
  questionText->setText( question );

  QFont questionFont = questionText->font();
  questionFont.setWeight(QFont::Bold);
  questionText->setFont( questionFont );

  questionIcon = new QPixmap(QString(IMAGE_PATH)+questionIconName);
  questionIconLabel = new QLabel( topFrame );
  questionIconLabel->setPixmap( *questionIcon );

  messageText = new QTextEdit( this );
  messageText->setReadOnly(true);
  messageText->setText( message );
  
  
  bottomFrame = new QFrame( this );

  okButton = new QPushButton( tr("Yes"), bottomFrame );
  okButton->setSizePolicy( QSizePolicy::Fixed, QSizePolicy::Fixed );
  okButton->setDefault(true);
  okButton->setFocus();

  connect( okButton, SIGNAL(clicked()), SLOT(accept()) );

  cancelButton = new QPushButton( tr("No"), bottomFrame );
  cancelButton->setSizePolicy( QSizePolicy::Fixed, QSizePolicy::Fixed );
  connect( cancelButton, SIGNAL(clicked()), SLOT(reject()) );
  //-------------------------------
  //create grid and place widgets
  gridTop     = new QGridLayout( topFrame, 1, 2, 0);
  gridTop->addWidget( questionText, 0, 0 );
  gridTop->addWidget( questionIconLabel, 0, 1, Qt::AlignRight );

  gridBottom  = new QGridLayout( bottomFrame, 1, 2, 0);
  gridBottom->addWidget( okButton, 0, 0 );
  gridBottom->addWidget( cancelButton, 0, 1);

  gridFull    = new QGridLayout( this, 3, 1, 0);
  gridFull->addWidget( topFrame, 0, 0);
  gridFull->addWidget( messageText, 1, 0);
  gridFull->addWidget( bottomFrame, 2, 0);

  gridFull->setRowStretch( 1, 1 );
  gridFull->setResizeMode( QLayout::FreeResize );
  gridFull->setMargin(WIDGET_SPACING);
  gridFull->setSpacing(WIDGET_SPACING);

  //-------------------------------
  //setup window title bar
  setCaption( question );
  //-------------------------------
  //set window to not be resizeable
  setMinimumWidth(300);
  this->show();
  setFixedSize(size());
  //-------------------------------
}
//==============================================
QuestionDialog::~QuestionDialog()
{
  delete questionIcon;
}
//==============================================
