from threading import Thread

import os
import time
import re
import datetime
import gtk
from gettext import gettext as _
class CheckAlarmThread(Thread):
	def __init__(self, status, main,StatusIcon,alarm_model, row, treesel, GUI, PREFIX):
		Thread.__init__(self)
		self.setDaemon(True)
		self.today = []
		self.CheckTodayAlarms()
		self.status = status
		self.cnt = 0
		self.Prefix = PREFIX
		self.MainWindowGlade = main
		self.GUI = GUI
		self.st = StatusIcon
		self.alarm_model = alarm_model
		self.row = row
		self.TreeSelection = treesel
		self.a = 0
		self.b = 0
		self.RefreshList = False
		self.Removed = False
		self.x = 0
	def run(self):
		self.CheckOldAlarms()

		while True:
			self.File = file(os.getenv("HOME") + "/.config/alarm-clock/lock", "w")
			self.File.write("%s/%s/%s %s:%s:%s" % (datetime.datetime.now().year, datetime.datetime.now().month, datetime.datetime.now().day, datetime.datetime.now().hour, datetime.datetime.now().minute, datetime.datetime.now().second))
			self.File.close()

			gtk.gdk.threads_enter()
			self.status.push(0, time.strftime(_("Current time: %c")))
			gtk.gdk.threads_leave()	

			for tup in self.today:
				if tup[0] == time.localtime().tm_hour and\
				tup[1] == time.localtime().tm_min and\
				time.localtime().tm_sec == 0:
					FileHandler = file(os.getenv("HOME")\
					+ "/.config/alarm-clock/alarms")
					AlarmContents = FileHandler.readlines()
					FileHandler.close()
					gtk.gdk.threads_enter()
					self.GUI().RunAlarm(eval(AlarmContents[tup[2]]))
					gtk.gdk.threads_leave()
					time.sleep(1)

			if time.localtime().tm_hour == 0 and time.localtime().tm_min == 0 and time.localtime().tm_sec < 1 and self.RefreshList == False:
				self.RefreshList = True

			if time.localtime().tm_hour == 0 and time.localtime().tm_min == 0 and time.localtime().tm_sec > 1 and self.RefreshList == True:
				self.RefreshList = False
			

			if self.RefreshList == True:
				gtk.gdk.threads_enter()
				self.LoadConfigFiles()
				gtk.gdk.threads_leave()
				self.RefreshList = False

			time.sleep(1)


			self.CheckOldAlarms()
			self.CheckTodayBirthdays(self.st)
			self.CheckTodayAlarms()


	def CheckOldAlarms(self):
		self.AlFile = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "r")

		self.x = self.x + 1
		if self.x == 4:
			if self.Removed == True:
				self.RefreshList = True
				self.Removed = False
			self.x = 0

		self.Data = self.AlFile.readlines()
		self.AlFile.close()
		self.Cnt = 0

		for line in self.Data:
			self.OldLine = eval(line)

			if self.OldLine[2] == 1:
				self.Cnt = self.Cnt + 1
				continue



			self.Date = self.OldLine[3]
			self.Time = self.OldLine[1]

			self.date_data = re.search('(\d+)/(\d+)/(\d+)', self.Date)
			self.oy = int(self.date_data.group(1))
			self.om = int(self.date_data.group(2)) + 1
			self.od = int(self.date_data.group(3))
			self.time_data = re.search('(\d+):(\d+)', self.Time)
			self.oh = int(self.time_data.group(1))
			self.omin = int(self.time_data.group(2))
			self.DateOld = datetime.datetime(self.oy,self.om,self.od,self.oh,self.omin,0)

			self.CurrentDate = datetime.datetime.today()

			self.Diff = self.CurrentDate - self.DateOld

			if self.Diff.days > 0:
				self.RemoveOldAlarm(self.Cnt)
				self.Cnt = self.Cnt + 1
				self.Removed = True
				continue

			if self.Diff.days == 0:
				if self.Diff.seconds > 0:
					self.RemoveOldAlarm(self.Cnt)
					self.Cnt = self.Cnt + 1
					self.Removed = True
					continue
		

			self.Cnt = self.Cnt + 1			


	def RemoveOldAlarm(self,no):
		self.row = no
		self.fbuf = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "r")
		self.lines = self.fbuf.readlines()
		self.new_lines = []
		self.counter = 0
		for line in self.lines:
			if self.counter == self.row:
				self.counter = self.counter + 1
				OldFile = file(os.getenv("HOME") + '/.config/alarm-clock/old-alarms', 'a')
				print >> OldFile, line
				OldFile.close()
				continue
			self.new_lines.append(line)
			self.counter = self.counter + 1

		self.fbuf.close()
		self.fbuf = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "w")
		self.fbuf.write("")
		self.fbuf.close()
		self.fbuf = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "a")
		for line in self.new_lines:
			self.fbuf.write(line)
		self.fbuf.close()



	def ParseTupletToList(self,line):
		self.string = eval(line)


		self.weekdays = self.string[4][0]
		self.months = self.string[4][1]

		self.t_weekday = time.localtime().tm_wday
		self.t_month = time.localtime().tm_mon
		self.t_day = time.localtime().tm_mday






		self.t = re.search('(\d+):(\d+)', self.string[1])

		self.h = "%s" % self.t.group(1)

		if int (self.t.group(2)) < 10:
			self.m = "0%s" % self.t.group(2)
		else:
			self.m = "%s" % self.t.group(2)

		self.time = "BAD"




		self.Good = False
		self.Ex = False
		self.weekdays = self.string[4][0]
		self.months = self.string[4][1]

		if self.weekdays[self.t_weekday] == True and self.months[self.t_month - 1] == True:
			self.Good = True

		for t in self.string[5]:
			if t[0] == self.t_month and t[1] == self.t_day:		
				self.Good = False
				self.Ex = True




		if self.Good == True and self.string[2] == 1:
			self.time = _("%s:%s - Today") % (self.h, self.m)
		else:
			if self.Ex == True:
				self.time = _("%s:%s - Cancelled") % (self.h, self.m)
			else:
				self.time = "%s:%s" % (self.h, self.m)










		icon = None
			

		if self.string[2] == 1:
			self.AlarmType = _("Scheduled")
			self.datetime = "%s" % self.time
			icon = self.MainWindowGlade.get_widget('main_window').render_icon('gtk-refresh', gtk.ICON_SIZE_SMALL_TOOLBAR)
		else:
			self.AlarmType = _("Single")
			self.date_data = re.search('(\d+)/(\d+)/(\d+)', self.string[3])
			icon = self.MainWindowGlade.get_widget('main_window').render_icon('gtk-jump-to', gtk.ICON_SIZE_SMALL_TOOLBAR)


			if int(self.date_data.group(3)) < 10:
				self.day = "0%s" % self.date_data.group(3)
			else:
				self.day = self.date_data.group(3)

			if int (self.date_data.group(2)) < 9:

				self.month = "0%i" % (int(self.date_data.group(2)) + 1)
			else:
				self.month = "%i" % (int(self.date_data.group(2)) + 1)
			self.datetime = "%s %s/%s/%s" % (self.time, self.day, self.month, self.date_data.group(1))			

		self.alarm_model.append([self.AlarmType, icon, self.datetime, self.string[0]])







	def LoadConfigFiles(self):

		if os.path.isdir(os.getenv("HOME") + "/.config/alarm-clock/") == False:
			os.mkdir (os.getenv("HOME") + "/.config/alarm-clock")

		if os.path.isfile(os.getenv("HOME") + "/.config/alarm-clock/configuration") == False:
			self.fc = file(os.getenv("HOME") + "/.config/alarm-clock/configuration", "w")
			print >> self.fc, [MainWindow.get_position(), MainWindow.get_size()]
			self.fc.close()
		if os.path.isfile(os.getenv("HOME") + "/.config/alarm-clock/alarms") == False:
			self.af = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "w")
			self.ClearAlarmValues()
			self.af.close()
		if os.path.isfile(os.getenv("HOME") + "/.config/alarm-clock/templates") == False:
			self.af = file(os.getenv("HOME") + "/.config/alarm-clock/templates", "w")
			self.af.close()


		self.ConfigFile = file(os.getenv("HOME") + "/.config/alarm-clock/configuration", "rw")
		self.AlarmFile = file(os.getenv("HOME") + "/.config/alarm-clock/alarms", "rw")

		for line in self.ConfigFile:
			self.configlist = eval(line)

		self.alarm_model.clear()
		self.i = 0
		for line in self.AlarmFile:
			self.i = self.i + 1
			self.ParseTupletToList(line)
		




		if self.i == 0:
			self.MainWindowGlade.get_widget('notebook').set_current_page(1)
			self.MainWindowGlade.get_widget('remove_alarm_toolbutton').set_sensitive(False)
			self.MainWindowGlade.get_widget('test_alarm_toolbutton').set_sensitive(False)
			self.MainWindowGlade.get_widget('alarm_properties_toolbutton').set_sensitive(False)
			self.MainWindowGlade.get_widget('edit_remove').set_sensitive(False)

		else:
			self.MainWindowGlade.get_widget('notebook').set_current_page(0)
			self.MainWindowGlade.get_widget('remove_alarm_toolbutton').set_sensitive(True)
			self.MainWindowGlade.get_widget('alarm_properties_toolbutton').set_sensitive(True)
			self.MainWindowGlade.get_widget('edit_remove').set_sensitive(True)
			self.MainWindowGlade.get_widget('test_alarm_toolbutton').set_sensitive(True)


		if self.row > 0:
			if self.row >= self.i:
				self.TreeSelection.select_path(self.i - 1,)
			else:
				self.TreeSelection.select_path(self.row,)
		if self.row == 0:
			self.TreeSelection.select_path(0,)

	def CheckTodayBirthdays(self, StatusIcon):
		self.BirthdaysNames = []
		self.BDay = False
		self.TodayDate = "%s/%s/%s" % (datetime.datetime.now().year, datetime.datetime.now().month - 1, datetime.datetime.now().day)

		try:
			self.bfile = file(os.getenv("HOME") + "/.config/alarm-clock/birthdays", "r")
		except:
			return

		self.lnn = self.bfile.readlines()

		for line in self.lnn:
			if self.TodayDate == eval(line)[0]:
				self.BirthdaysNames.append(eval(line)[1])
				self.BDay = True

		if self.BDay == True:
			self.Text = _("Birthday today! Remember to buy presents:\n")
			for name in self.BirthdaysNames:
				self.Text = self.Text + "\n" + name

			StatusIcon.set_tooltip(self.Text)
			StatusIcon.set_from_file(self.Prefix + '/scalable/alarm-caution.svg')
		else:
			StatusIcon.set_tooltip(_("Alarm Clock"))
			StatusIcon.set_from_file(self.Prefix + '/scalable/alarm-clock.svg')

	def CheckTodayAlarms(self):
		self.today = []
		self.f = file(os.getenv("HOME") + "/.config/alarm-clock/alarms")

		self.ln = self.f.readlines()

		self.f.close()

		self.t_min = time.localtime().tm_min
		self.t_hour = time.localtime().tm_hour
		self.t_day = time.localtime().tm_mday
		self.t_weekday = time.localtime().tm_wday
		self.t_month = time.localtime().tm_mon
		self.t_year = time.localtime().tm_year
		
		self.linenumber = 0
		for line in self.ln:
			self.buf = eval(line)
			self.date_data = re.search('(\d+)/(\d+)/(\d+)', self.buf[3])
			self.y = int(self.date_data.group(1))
			self.m = int(self.date_data.group(2)) + 1
			self.d = int(self.date_data.group(3))
			self.time_data = re.search('(\d+):(\d+)', self.buf[1])


			if self.buf[2] == 0:
				if self.y == self.t_year and self.m == self.t_month and self.d == self.t_day:
					self.tup = [int (self.time_data.group(1)), int (self.time_data.group(2)), self.linenumber]

					self.today.append(self.tup)
					


			else:
				self.Good = False
				self.weekdays = self.buf[4][0]
				self.months = self.buf[4][1]

				if self.weekdays[self.t_weekday] == True and self.months[self.t_month - 1] == True:
					self.Good = True

				for t in self.buf[5]:
					if t[0] == self.t_month and t[1] == self.t_day:		
						self.Good = False

				if self.Good == True:
					self.tup = [int (self.time_data.group(1)), int (self.time_data.group(2)), self.linenumber]
					self.today = self.today + [self.tup]

			self.linenumber = self.linenumber + 1





