#include <ctapi.h>
#include <stdio.h>
#ifndef TARGET_OSX
#include "config.h"
#endif

int main() {

  long rv;
  unsigned char dad, sad;
  unsigned char cmd[2000];
  unsigned char rsp[2000];
  unsigned char myData[8] = {0x31, 0x32, 0x33, 0x34, 0x31, 0x32, 0x33, 0x34};
  unsigned short len;
  int i;

  rv = CT_init(1, 8);
  printf("CT_init returns %d\n", rv);


  /* Request ICC */
printf("Press any key to continue...\n");
getchar();
  dad = 1; sad = 2; len = 0;
  cmd[0] = 0x20; cmd[1] = 0x12; cmd[2] = 0x00;
  cmd[3] = 0x01; cmd[4] = 0x00;

  CT_data(8, &dad, &sad, 5, cmd, &len, rsp);

  printf("Returned atr [%d]: ", len);

  for (i=0; i < len; i++) {
    printf("%02X ", rsp[i]);
  } printf("\n");

  /* Select Root */
printf("Press any key to continue...\n");
getchar();
  dad = 0; sad = 2; len = 0;
  cmd[0] = 0x00; cmd[1] = 0xA4; cmd[2] = 0x00;
  cmd[3] = 0x00; cmd[4] = 0x02; cmd[5] = 0x3F;
  cmd[6] = 0x00;

  CT_data(8, &dad, &sad, 7, cmd, &len, rsp);

  printf("Select root status [%d]: ", len);

  for (i=0; i < len; i++) {
    printf("%02X ", rsp[i]);
  } printf("\n");


  /* Get Status */
printf("Press any key to continue...\n");
getchar();
  dad = 1; sad = 2; len = 0;
  cmd[0] = 0x20; cmd[1] = 0x13; cmd[2] = 0x00;
  cmd[3] = 0x80; cmd[4] = 0x00; 
  CT_data(8, &dad, &sad, 5, cmd, &len, rsp);

  printf("Returned get status [%d]: ", len);

  for (i=0; i < len; i++) {
    printf("%02X ", rsp[i]);
  } printf("\n");


  /* Verify */
printf("Press any key to continue...\n");
getchar();
  dad = 0; sad = 2; len = 0;
  cmd[0] = 0x20; cmd[1] = 0x20; cmd[2] = 0x00;
  cmd[3] = 0x00; cmd[4] = 0x03; cmd[5] = 0xFF;
  cmd[6] = 0xFF; cmd[7] = 0xFF;
  CT_data(8, &dad, &sad, 8, cmd, &len, rsp);

  printf("Returned verify status [%d]: ", len);

  for (i=0; i < len; i++) {
    printf("%02X ", rsp[i]);
  } printf("\n");


  /* Write data */
printf("Press any key to continue...\n");
getchar();
  dad = 0; sad = 2; len = 0;
  cmd[0] = 0x20; cmd[1] = 0xD6; cmd[2] = 0x00;
  cmd[3] = 0x40; cmd[4] = 0x08; 
  memcpy(&cmd[5], myData, sizeof(myData));

  CT_data(8, &dad, &sad, 5 + sizeof(myData), cmd, &len, rsp);

  printf("Returned write status [%d]: ", len);

  for (i=0; i < len; i++) {
    printf("%02X ", rsp[i]);
  } printf("\n");


  /* Read data - full amount */
printf("Press any key to continue...\n");
getchar();
  dad = 0; sad = 2; len = 0;
  cmd[0] = 0x20; cmd[1] = 0xB0; cmd[2] = 0x00;
  cmd[3] = 0x00; cmd[4] = 0x00; 

  CT_data(8, &dad, &sad, 5, cmd, &len, rsp);

  printf("Returned read data [%d]: ", len);

  for (i=0; i < len; i++) {
    printf("%02X ", rsp[i]);
  } printf("\n");


  /* Eject ICC */
printf("Press any key to continue...\n");
getchar();

  dad = 1; sad = 2; len = 0;
  cmd[0] = 0x20; cmd[1] = 0x15; cmd[2] = 0x00;
  cmd[3] = 0x00; cmd[4] = 0x00; 

  CT_data(8, &dad, &sad, 5, cmd, &len, rsp);

  printf("Returned eject status [%d]: ", len);

  for (i=0; i < len; i++) {
    printf("%02X ", rsp[i]);
  } printf("\n");



printf("Press any key to continue...\n");
getchar();
  CT_close(8);

}

