!{\src2tex{textfont=tt}}
!!****f* ABINIT/pawuenergy
!! NAME
!! pawuenergy
!!
!! FUNCTION
!! Compute contributions to energy
!! for PAW+U calculations
!!
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (BA, FJ)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~ABINIT/Infos/copyright
!! or http://www.gnu.org/copyleft/gpl.txt .
!! For the initials of contributors, see ~ABINIT/Infos/contributors.
!!
!! INPUTS
!!  nspden: Number of spin component
!!  pawprtvol=control print volume and debugging output for PAW
!!  pawtab <type(pawtab_type)>=paw tabulated starting data:
!!     %lpawu=l used for lda+u
!!     %vee(2*lpawu+1*4)=screened coulomb matrix
!!  paw_ij <type(paw_ij_type)>=paw arrays given on (i,j) channels
!!  %noccmmp(2*pawtab(itypat)%lpawu+1,2*pawtab(itypat)%lpawu+1,nspden)
!!     density matrix in the sphere
!!  %nocctot(nspden) number of electrons in the correlated subspace
!!
!! OUTPUT
!!  eldaumdc
!!  eldaumdcdc
!!
!! PARENTS
!!      pawdenpot
!!
!! CHILDREN
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

 subroutine pawuenergy(eldaumdc,eldaumdcdc,pawprtvol,pawtab,paw_ij,nspden)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
#endif
!End of the abilint section

 implicit none

!Arguments ---------------------------------------------
!scalars
 integer,intent(in) :: nspden,pawprtvol
 real(dp),intent(inout) :: eldaumdc,eldaumdcdc
 type(paw_ij_type),intent(in) :: paw_ij
 type(pawtab_type),intent(in) :: pawtab

!Local variables ---------------------------------------
!scalars
 integer :: ispden,lpawu,m1,m11,m2,m21,m3,m31,m4,m41
 real(dp) :: edcdctemp,edctemp,eldautemp,ndn,ntot,nup
 character(len=500) :: message

! *****************************************************
 lpawu=pawtab%lpawu

!======================================================
! Compute LDA+U Energy 
! -----------------------------------------------------

 eldautemp=zero
 do ispden=1,nspden
  do m1=-lpawu,lpawu
   m11=m1+lpawu+1
   do m2=-lpawu,lpawu
    m21=m2+lpawu+1
    do m3=-lpawu,lpawu
     m31=m3+lpawu+1
     do m4=-lpawu,lpawu
      m41=m4+lpawu+1
      eldautemp=eldautemp+&
&     pawtab%vee(m11,m31,m21,m41)*paw_ij%noccmmp(m31,m41,nspden-ispden+1)*&
&     paw_ij%noccmmp(m11,m21,ispden)+&
&     (pawtab%vee(m11,m31,m21,m41)-pawtab%vee(m11,m31,m41,m21))&
&     *paw_ij%noccmmp(m31,m41,ispden)*paw_ij%noccmmp(m11,m21,ispden)
     end do
    end do
   end do ! m2
  end do ! m1
 end do ! ispden


 edcdctemp=zero
 edctemp=zero
 ntot=paw_ij%nocctot(1)+paw_ij%nocctot(2)
 nup=paw_ij%nocctot(1)
 ndn=paw_ij%nocctot(2)
 if(pawtab%usepawu==1) then
  edcdctemp=edcdctemp+&
& pawtab%upawu*(-ntot**2)+&
& pawtab%jpawu*(nup**2+ndn**2)
  edctemp=edctemp+&
& pawtab%upawu*(ntot*(ntot-One))-&
& pawtab%jpawu*(nup*(nup-One)+ndn*(ndn-One))
 else if(pawtab%usepawu==2) then
  edctemp=edctemp+Two*pawtab%upawu*(nup*ndn)+&
& (pawtab%upawu-pawtab%jpawu)*(nup**2+ndn**2)*dfloat(2*lpawu)/(dfloat(2*lpawu+1))
  edcdctemp=-edctemp
 end if
 eldaumdc=eldaumdc+(eldautemp-edctemp)/Two
 eldaumdcdc=eldaumdcdc-(eldautemp+edcdctemp)/Two

  write(message, '(a)' )"   Contributions to the direct expression of energy:"
  call wrtout(06,  message,'COLL')
  write(message,fmt=11) "     Double counting  correction   =",edctemp/Two
  call wrtout(06,  message,'COLL')
  write(message,fmt=11) "     Interaction energy            =",eldautemp/Two
  call wrtout(06,  message,'COLL')
  write(message,fmt=11) "     Total LDA+U Contribution      =",(eldautemp-edctemp)/Two
  call wrtout(06,  message,'COLL')
  write(message, '(a)' )' '
  call wrtout(06,  message,'COLL')
  write(message, '(a)' )"   For the ""Double-counting"" decomposition:"
  call wrtout(06,  message,'COLL')
  write(message,fmt=11) "     LDA+U Contribution            =",-(eldautemp+edcdctemp)/Two
  call wrtout(06,  message,'COLL')
11 format(a,e20.10)
 if(pawprtvol>=2) then
  write(message,fmt=11) "     edcdctemp/2                   =",edcdctemp/Two
  call wrtout(06,  message,'COLL')
  write(message,fmt=11) "     eldaumdcdc for current atom   =",-(eldautemp+edcdctemp)/Two
  call wrtout(06,  message,'COLL')
  write(message, '(a)' )' '
  call wrtout(06,  message,'COLL')
  write(message,fmt=11) "   pawuenergy: -VUKS pred        =",eldaumdcdc-eldaumdc
  call wrtout(06,  message,'COLL')
 end if
  write(message, '(a)' )' '
  call wrtout(06,  message,'COLL')
 
 end subroutine pawuenergy
!!***
