#include "rpggame.h"

using namespace game;

namespace rpgscript
{
	/**
		HOW IT WORKS

		the currently selected items should ALWAYS be null, to select something you need to use r_execute_* or interact with the entity in some way.
		the scripts will push the new values onto the variables and pop them when done
	*/

	rpgent *hover = NULL;

	script *curscript = NULL;
	script *chatscript = NULL;
	rpgent *entsel = NULL;
	rpgent *actor = NULL;
	invstack *item = NULL;
	mapinfo *mapsel = NULL;

	vector<rpgent *> obits; //r_destroy

	void clean()
	{
		curscript = NULL;
		chatscript = NULL;
		hover = NULL;
		entsel = NULL;
		actor = NULL;
		item = NULL;
		mapsel = NULL;

		obits.setsize(0);
	}

	void deselect(void *ptr)
	{
		if(hover == ptr) hover = NULL;

		if(chatscript == ptr) chatscript = NULL;
		if(curscript == ptr) curscript = NULL;
		if(entsel == ptr) entsel = NULL;
		if(actor == ptr) actor = NULL;
		if(item == ptr) item = NULL;
		if(mapsel == ptr) mapsel = NULL;
	}

	void update()
	{
		vec dir = vec(worldpos).sub(player1->o);
		if(dir.magnitude() > player1->radius + 8)
		{
			dir.normalize().mul(player1->radius + 8);
		}
		dir.add(player1->o);

		float dist;
		hover = intersectclosest(player1->o, dir, player1, dist, 1);

		obits.removeobj(game::player1);

		loopvj(obits)
		{
			rpgent *ent = obits[j];
			enumerate(*mapdata, mapinfo, map,
				map.objs.removeobj(ent);
				loopvk(map.loadactions)
				{
					if(map.loadactions[k]->type() != ACTION_TELEPORT || ((action_teleport *) map.loadactions[k])->ent != ent)
						continue;
					delete map.loadactions[k];
					map.loadactions.remove(k);
					k--;
				}
			);
			deselect(ent);
			delete ent;
			obits.removeobj(ent); //gets rid of duplicates
			j--;
		}
	}

	void doitemscript(invstack *invokee, rpgent *invoker, int slot)
	{
		const char *slots[] = {"approach", "death", "drop", "equip", "interact", "spawn", "use", "collide", "hit"};

		if(!invokee)
			return;

		if(slot < 0 || slot >= SCR_MAX || !items.inrange(invokee->base) || !scripts.inrange(items[invokee->base]->script))
		{
			conoutf(CON_ERROR, "ERROR: unable to execute script for item %p, either the slot is out of range (%i 0...%i),"
			        " the item is out of range (%i 0...%i), or the script is out of range (%i 0...%i)",
				invokee, slot, SCR_MAX - 1,
				invokee->base, items.length() - 1, items.inrange(invokee->base) ? items[invokee->base]->script : -1, scripts.length() - 1
			);
			return;
		}

		if(!scripts[items[invokee->base]->script]->scripts[slot])
		{
			if(DEBUG_SCRIPT)
				conoutf(CON_DEBUG, "DEBUG: slot %i (%s) of script %i called, slot is empty", slot, slots[slot], items[invokee->base]->script);
			return;
		}

		if(DEBUG_SCRIPT)
			conoutf(CON_DEBUG, "DEBUG: slot %i (%s) of script %i called", slot, slots[slot], items[invokee->base]->script);

		rpgent *lastent = entsel;
		rpgent *lastact = actor;
		invstack *lastitem = item;
		mapinfo *lastmap = mapsel;
		script *lastscr = curscript;

		entsel = NULL;
		actor = invoker;
		item = invokee;
		if(!mapsel) mapsel = curmap;
		curscript = scripts[items[invokee->base]->script];
		if(DEBUG_SCRIPT)
			conoutf(CON_DEBUG, "DEBUG: pushing new values; entsel: %p; actor: %p; item: %p; mapsel: %p; curscript: %p", entsel, actor, item, mapsel, curscript);
		execute(curscript->scripts[slot]);

		curscript = lastscr;
		mapsel = lastmap;
		item = lastitem;
		actor = lastact;
		entsel = lastent;
		if(DEBUG_SCRIPT)
			conoutf(CON_DEBUG, "DEBUG: restoring old values; entsel: %p; actor: %p; item: %p; mapsel: %p; curscript: %p", entsel, actor, item, mapsel, curscript);
	}

	void doentscript(rpgent *invokee, rpgent *invoker, int slot)
	{
		const char *slots[] = {"approach", "death", "drop", "equip", "interact", "spawn", "use", "collide", "hit"};

		if(slot < 0 || slot >= SCR_MAX || !scripts.inrange(invokee->getscript()))
		{
			conoutf(CON_ERROR, "ERROR: unable to execute script for ent %p, either the slot (%i 0...%i) or the script (%i 0...%i) is out of range",
				invokee, slot, SCR_MAX - 1, invokee->getscript(), scripts.length() - 1
			);
			return;
		}

		if(!scripts[invokee->getscript()]->scripts[slot])
		{
			if(DEBUG_SCRIPT)
				conoutf(CON_DEBUG, "DEBUG: slot %i (%s) of script %i called, slot is empty", slot, slots[slot], invokee->getscript());
			return;
		}

		if(DEBUG_SCRIPT)
			conoutf(CON_DEBUG, "DEBUG: slot %i (%s) of script %i called", slot, slots[slot], invokee->getscript());

		rpgent *lastent = entsel;
		rpgent *lastact = actor;
		invstack *lastitem = item;
		mapinfo *lastmap = mapsel;
		script *lastscr = curscript;

		entsel = invokee;
		actor = invoker;
		item = invokee->type() == ENT_ITEM ? (rpgitem *) invokee : NULL;
		if(!mapsel) mapsel = curmap;
		curscript = scripts[invokee->getscript()];
		if(DEBUG_SCRIPT)
			conoutf(CON_DEBUG, "DEBUG: pushing new values; entsel: %p; actor: %p; item: %p; mapsel: %p; curscript: %p", entsel, actor, item, mapsel, curscript);
		execute(curscript->scripts[slot]);

		curscript = lastscr;
		mapsel = lastmap;
		item = lastitem;
		actor = lastact;
		entsel = lastent;
		if(DEBUG_SCRIPT)
			conoutf(CON_DEBUG, "DEBUG: restoring old values; entsel: %p; actor: %p; item: %p; mapsel: %p; curscript: %p", entsel, actor, item, mapsel, curscript);
	}

	void domapscript(mapinfo *map, rpgent *victim, int slot)
	{
		const char *slots[] = {"load", "enter"};
		if(slot < 0 || slot >= MSCR_MAX || !mapscripts.inrange(map->script))
		{
			conoutf(CON_ERROR, "ERROR: unable to execute script for map %p, either the slot (%i 0...%i) or the script (%i 0...%i) is out of range", map, slot, MSCR_MAX - 1, map->script, mapscripts.length() -1);
			return;
		}

		if(!mapscripts[curmap->script]->scripts[slot])
		{
			if(DEBUG_SCRIPT) conoutf(CON_DEBUG, "DEBUG: slot %i (%s) of mapscript %i called, slot is empty", slot, slots[slot], curmap->script);
			return;
		}

		if(DEBUG_SCRIPT)
			conoutf(CON_DEBUG, "DEBUG: slot %i (%s) of mapscript %i called", slot, slots[slot], curmap->script);

		rpgent *lastent = entsel;
		rpgent *lastact = actor;
		invstack *lastitem = item;
		mapinfo *lastmap = mapsel;
		script *lastscr = curscript;

		entsel = victim;
		actor = NULL;
		item = (victim && victim->type() == ENT_ITEM) ? (rpgitem *) victim : NULL;
		mapsel = map;
		curscript = NULL;

		if(DEBUG_SCRIPT)
			conoutf(CON_DEBUG, "DEBUG: pushing new values; entsel: %p; actor: %p; item: %p; mapsel: %p; curscript: %p", entsel, actor, item, mapsel, curscript);

		execute(mapscripts[map->script]->scripts[slot]);

		curscript = lastscr;
		mapsel = lastmap;
		item = lastitem;
		actor = lastact;
		entsel = lastent;
		if(DEBUG_SCRIPT)
			conoutf(CON_DEBUG, "DEBUG: restoring old values; entsel: %p; actor: %p; item: %p; mapsel: %p; curscript: %p", entsel, actor, item, mapsel, curscript);
	}

	/**
		WORLD STUFF
	*/

	ICOMMAND(r_get_selmap, "", (), result(mapsel ? mapsel->name : "");)
	ICOMMAND(r_get_curmap, "", (), result(curmap ? curmap->name : "");)
	ICOMMAND(r_get_numobjs, "", (), intret(mapsel ? mapsel->objs.length() : 0);)

	ICOMMAND(worlduse, "", (),
		if(hover && hover != player1)
		{
			if(DEBUG_SCRIPT)
				conoutf(CON_DEBUG, "DEBUG: Player interacted with %p", hover);

			doentscript(hover, player1, SCR_INTERACT);
		}
	)

	ICOMMAND(r_registermap, "si", (const char *m, int *scr),
		if(*m)
		{
			if(DEBUG_SCRIPT)
				conoutf(CON_DEBUG, "DEBUG: Prepared mapinfo for %s with script %i", m, *scr);

			mapinfo *tmp = accessmap(m);
			tmp->script = *scr;
		}
	)

	ICOMMAND(r_queue_script, "ss", (const char *m, const char *body),
		if(!mapdata)
		{
			conoutf(CON_ERROR, "ERROR: no game in progress");
			return;
		}
		mapinfo *info = game::accessmap(m);
		if(DEBUG_SCRIPT)
		{
			conoutf(CON_DEBUG, "DEBUG: queued script on map %p", info);
			if(curmap == info) conoutf(CON_DEBUG, "DEBUG: note that the script was queud for the current map");
		}
		info->loadactions.add(new action_script(body));
	)

	//population control
	ICOMMAND(r_spawn_item, "iiii", (int *t, int *i, int *n, int *q),
		if(!mapsel)
			return;
		if(*q <= 0) *q = 1;

		if(curmap != mapsel)
		{
			if(DEBUG_SCRIPT)
				conoutf(CON_DEBUG, "DEBUG: r_spawn_item called on another map, queuing loadaction");
			mapsel->loadactions.add(new action_spawn(*t, ENT_ITEM, *i, *n, *q));
			return;
		}

		int spawned = 0;

		do
		{
			loopvj(entities::ents)
			{
				extentity &e = *entities::ents[j];
				if(e.type == SPAWN && e.attr[2] == *t)
				{
					if(*n && spawned >= *n)
					{
						if(DEBUG_SCRIPT) conoutf(CON_DEBUG, "DEBUG: item spawn limit (%i) reached", *n );
						return;
					}

					spawned ++;
					entities::spawn(e, *i, ENT_ITEM, *q);
				}
			}
		} while(*n && spawned);

		if(!spawned) conoutf("WARNING: r_spawn_item called with %i %i %i but didn't spawn anything", *t, *i, *n);
	)

	ICOMMAND(r_spawn_creature, "iii", (int *t, int *c, int *n),
		if(!mapsel)
			return;

		if(curmap != mapsel)
		{
			if(DEBUG_SCRIPT)
				conoutf(CON_DEBUG, "DEBUG: r_spawn_creature called on another map, queuing loadaction");
			mapsel->loadactions.add(new action_spawn(*t, ENT_CHAR, *c, *n, 1));
			return;
		}

		int spawned = 0;

		do
		{
			loopv(entities::ents)
			{
				extentity &e = *entities::ents[i];
				if(e.type == SPAWN && e.attr[2] == *t)
				{
					if(*n && spawned >= *n)
					{
						if(DEBUG_SCRIPT) conoutf(CON_DEBUG, "DEBUG: char spawn limit (%i) reached", *n );
						return;
					}

					spawned++;
					entities::spawn(e, *c, ENT_CHAR, 1);
				}
			}
		} while(*n && spawned);

		if(!spawned) conoutf("WARNING: r_spawn_creature called with %i %i %i but didn't spawn anything", *t, *c, *n);
	)

	ICOMMAND(r_spawn_object, "iii", (int *t, int *o, int *n),
		if(!mapsel)
			return;

		if(curmap != mapsel)
		{
			if(DEBUG_SCRIPT)
				conoutf(CON_DEBUG, "DEBUG: r_spawn_object called on another map, queuing loadaction");
			mapsel->loadactions.add(new action_spawn(*t, ENT_OBJECT, *o, *n, 1));
			return;
		}

		int spawned = 0;

		do
		{
			loopv(entities::ents)
			{
				extentity &e = *entities::ents[i];
				if(e.type == SPAWN && e.attr[2] == *t)
				{
					if(*n && spawned >= *n)
					{
						if(DEBUG_SCRIPT) conoutf(CON_DEBUG, "DEBUG: object spawn limit (%i) reached", *n);
						return;
					}

					spawned++;
					entities::spawn(e, *o, ENT_OBJECT, 1);
				}
			}
		} while(*n && spawned);

		if(!spawned) conoutf("WARNING: r_spawn_object called with %i %i %i but didn't spawn anything", *t, *o, *n);
	)

	//dialogue
	//see r_script_say in rpgconfig.cpp
	ICOMMAND(r_chat, "i", (int *pos),
		if(!entsel) return;
		if(chatscript)
		{
			conoutf(CON_ERROR, "ERROR: dialogue already in progress");
			return;
		}

		if(scripts.inrange(entsel->getscript()))
		{
			chatscript = scripts[entsel->getscript()];
			chatscript->pos = clamp(chatscript->dialogue.length(), -2, *pos);
			if(chatscript->pos >= 0) execute(chatscript->dialogue[chatscript->pos]->script);
		}
		else
			conoutf(CON_ERROR, "ERROR: invalid script %i, can't initialise dialogue", entsel->getscript());
			return
	)


	ICOMMAND(r_response, "sis", (char *t, int *d, char *s),
		if(!chatscript)
		{
			conoutf(CON_ERROR, "ERROR: no conversation in progress");
			return;
		}

		if(chatscript->dialogue.inrange(chatscript->pos))
		{
			if(DEBUG_SCRIPT)
				conoutf(CON_DEBUG, "DEBUG: added response for chatscript->dialogue[%i]: \"%s\" %i \"%s\"", curscript->pos, t, *d, s);

			chatscript->dialogue[chatscript->pos]->dests.add(new response(t, *d, s));
		}
		else
		{
			conoutf(CON_ERROR, "ERROR: currently in a non-existant dialogue - note pos must be >= 0");
			return;
		}
	)

	//GLOBAL VARIABLES
	// Thet should only be used to alert (and spawn) bounty hunters when someone steals my cake ;)

	ICOMMAND(r_global_get, "i", (int *i),
		if(!variables.inrange(*i))
		{
			conoutf(CON_ERROR, "ERROR: no global variable of index %i, returning 0", *i);
			intret(0);
			return;
		}

		if(DEBUG_SCRIPT)
			conoutf(CON_DEBUG, "DEBUG: global variable %i requested, returning %i", *i, variables[*i]);

		intret(variables[*i])
	)

	ICOMMAND(r_global_set, "ii", (int *i, int *v),
		if(!variables.inrange(*i))
		{
			conoutf(CON_ERROR, "ERROR: no global variable of index %i, unable to replace", *i);
			return;
		}
		if(DEBUG_SCRIPT)
			conoutf(CON_DEBUG, "DEBUG: global variable %i set to %i from %i", *i, *v, variables[*i]);
		variables[*i] = *v;
	)


	/**
		SCRIPT EMBODIMENTS
	*/

	ICOMMAND(r_execute_all, "e", (uint *body),
		if(!mapdata)
			return;

		mapinfo *lastmap = mapsel;
		rpgent *lastent = entsel;
		invstack *lastitem = item;

		enumerate(*mapdata, mapinfo, map,
			if(DEBUG_SCRIPT)
				conoutf(CON_DEBUG, "DEBUG: setting selected map to %s (%p)", map.name, &map);
			mapsel = &map;
			loopvrev(map.objs)
			{
				entsel = map.objs[i];
				item = map.objs[i]->type() == ENT_ITEM ? (rpgitem *) map.objs[i] : NULL;
				if(DEBUG_SCRIPT)
					conoutf(CON_DEBUG, "DEBUG: setting selent to %p, item to %p and executing body", entsel, item);
				execute(body);
			}
		)

		mapsel = lastmap;
		entsel = lastent;
		item = lastitem;
		if(DEBUG_SCRIPT)
			conoutf(CON_DEBUG, "DEBUG: restoring old values; entsel: %p; item: %p; mapsel: %p", entsel, item, mapsel);
	)

	ICOMMAND(r_execute_local, "e", (uint *body),
		if(!mapdata || !mapsel)
			return;

		rpgent *lastent = entsel;
		invstack *lastitem = item;

		loopvrev(mapsel->objs)
		{
			entsel = mapsel->objs[i];
			item = mapsel->objs[i]->type() == ENT_ITEM ? (rpgitem *) mapsel->objs[i] : NULL;
			if(DEBUG_SCRIPT)
				conoutf(CON_DEBUG, "DEBUG: setting selent to %p, item to %p and executing body", entsel, item);
			execute(body);
		}

		entsel = lastent;
		item = lastitem;
		if(DEBUG_SCRIPT)
			conoutf(CON_DEBUG, "DEBUG: restoring old values; entsel: %p; item: %p", entsel, item);
	)

	ICOMMAND(r_execute_mapdata, "e", (uint *body),
		if(!mapdata)
			return;

		mapinfo *lastmap = mapsel;

		enumerate(*mapdata, mapinfo, map,
			if(DEBUG_SCRIPT)
				conoutf(CON_DEBUG, "DEBUG: set mapsel to %s (%p)", map.name, &map);
			mapsel = &map;
			execute(body);
		)

		mapsel = lastmap;
	)

	ICOMMAND(r_execute_map, "e", (uint *body),
		if(!mapsel)
			return;

		execute(body);
	)

	ICOMMAND(r_execute_selected, "e", (uint *body),
		if(!entsel)
			return;

		execute(body);
	)

	ICOMMAND(r_execute_player, "e", (uint *body),
		if(!curmap)
			return;

		mapinfo *lastmap = mapsel;
		rpgent *lastent = entsel;
		rpgent *lastact = actor;
		invstack *lastitem = item;

		mapsel = curmap;
		actor = entsel;
		entsel = player1;
		item = NULL;
		execute(body);

		mapsel = lastmap;
		entsel = lastent;
		actor = lastact;
		item = lastitem;
		if(DEBUG_SCRIPT)
			conoutf(CON_DEBUG, "DEBUG: restoring old values; entsel: %p; actor: %p; item: %p; mapsel: %p", entsel, actor, item, mapsel);
	)

	ICOMMAND(r_execute_curmap, "e", (uint *body),
		if(!curmap)
			return;

		mapinfo *lastmap = mapsel;
		mapsel = curmap;

		execute(body);

		mapsel = lastmap;
	)

	ICOMMAND(r_execute_actor, "e", (uint *body),
		if(!actor)
		{
			conoutf(CON_ERROR, "ERROR: r_execute_actor can only be invoked in certain script related calls");
			return;
		}

		swap(entsel, actor); //swap pointers for the execution cycle
		item = entsel->type() == ENT_ITEM ? (rpgitem *) entsel : NULL;
		execute(body);
		swap(entsel, actor);
		item = entsel->type() == ENT_ITEM ? (rpgitem *) entsel : NULL;
	)

	ICOMMAND(r_execute_inv, "e", (uint *body),
		if(!entsel)
			return;

		invstack *lastitem = item;

		switch(entsel->type())
		{
			case ENT_CHAR:
			{
				if(DEBUG_SCRIPT)
					conoutf(CON_DEBUG, "DEBUG: r_execute_inv called on creature, looping inventory...");
				rpgchar *chr = (rpgchar *) entsel;
				loopvrev(chr->inventory)
				{
					if(DEBUG_SCRIPT)
						conoutf(CON_DEBUG, "DEBUG: set item to %p... executing body", chr->inventory[i]);
					item = chr->inventory[i];
					execute(body);
				}
				break;
			}
			case ENT_OBJECT:
			{
				if(DEBUG_SCRIPT)
					conoutf(CON_DEBUG, "DEBUG: called r_execute_inv on object...");
				rpgobject *obj = (rpgobject *) entsel;
				if(! (obj->flags & rpgobject::CONTAINER))
				{
					conoutf(CON_ERROR, "ERROR: r_execute_inv called on non-container object %p", entsel);
					break;
				}
				else if (DEBUG_SCRIPT)
					conoutf(CON_DEBUG, "DEBUG: object is a container, looping inventory");

				loopvrev(obj->inventory)
				{
					if(DEBUG_SCRIPT)
						conoutf("DEBUG: setting item to %p", obj->inventory[i]);
					item = obj->inventory[i];
					execute(body);
				}
				break;
			}
			case ENT_ITEM:
				if(DEBUG_SCRIPT)
					conoutf(CON_DEBUG, "DEBUG: r_execute_inv called on item, settings to self; %p", entsel);
				item = (rpgitem *) entsel;
				execute(body);
				break;
		}

		item = lastitem;
	)

	/**
		ENTITY STUFF
	*/

	ICOMMAND(r_is_player, "", (), intret(entsel == player1);)
	ICOMMAND(r_is_alive, "", (), intret(entsel ? entsel->state == CS_ALIVE : 0);)
	ICOMMAND(r_is_dead, "", (), intret(entsel ? entsel->state == CS_DEAD : 0);)
	ICOMMAND(r_get_type, "", (), intret(entsel ? entsel->type() : ENT_INVALID);)

	ICOMMAND(r_get_index, "", (),
		if(!entsel)
			return;

		int ret = mapsel->objs.find(entsel);
		if(DEBUG_SCRIPT)
			conoutf(CON_DEBUG, "DEBUG: requested index of %p on map %s (%p)", entsel, mapsel, mapsel->name);
		intret(ret);
	)

	ICOMMAND(r_on_curmap, "", (),
		if(!entsel)
			return;
		int ret = (curmap->objs.find(entsel) != -1);
		if(DEBUG_SCRIPT)
			conoutf(CON_DEBUG, "DEBUG: r_on_curmap called for entity %p, returning %i", entsel, ret);
		intret(ret);
	)

	ICOMMAND(r_get_flags, "", (),
		if(!entsel)
			return;
		switch(entsel->type())
		{
			case ENT_OBJECT:
				if(DEBUG_SCRIPT)
					conoutf(CON_DEBUG, "DEBUG: requested flags of object, returning %i", ((rpgobject *) entsel)->flags);
				intret(((rpgobject *) entsel)->flags);
				return;
			case ENT_ITEM:
			{
				int ret = 0;
				rpgitem *i = ((rpgitem *) entsel);
				if(game::items.inrange(i->base))
					ret = game::items[i->base]->flags;
				else
					conoutf("WARNING: flags requested for our of range item %i", i->base);

				if(DEBUG_SCRIPT)
					conoutf(CON_DEBUG, "DEBUG: requested flags of object, returning %i", ret);
				intret(ret);
				return;
			}
			default:
				if(DEBUG_SCRIPT)
					conoutf(CON_DEBUG, "DEBUG: requested flags of invalid or flagless entity, returning 0");
				intret(0);
				return;
		}
	)

	ICOMMAND(r_get_faction, "", (),
		if(!entsel)
			return;
		if(entsel->type() == ENT_CHAR)
		{
			if(DEBUG_SCRIPT)
				conoutf(CON_DEBUG, "DEBUG: faction requested of entity %p, returning %i", entsel, ((rpgchar *) entsel)->faction);
			intret(((rpgchar *) entsel)->faction);
		}
		else
		{
			if(DEBUG_SCRIPT)
				conoutf(CON_DEBUG, "DEBUG: faction requested of non-character entity %p, returning -1", entsel);
			intret(-1);
		}
	)

	ICOMMAND(r_teleport, "is", (int *d, const char *m),
		if(!entsel)
			return;

		mapinfo *destmap = *m ? accessmap(m) : curmap;

		if(entsel == player1 && curmap != destmap)
		{
			if(DEBUG_SCRIPT)
				conoutf(CON_DEBUG, "DEBUG: player intermap teleport, changing map to %s and adding loadaction", m);
			destmap->loadactions.add(new action_teleport(entsel, *d));
			load_world(m);
			return;
		}

		if(entsel != player1 && mapsel != curmap)
		{
			if(mapsel != destmap)
			{
				if(DEBUG_SCRIPT)
					conoutf(CON_DEBUG, "DEBUG: creature (%p) intermap teleport from %s to %s - transferring", entsel, mapsel->name, destmap->name);

				//make sure there are no pendings actions for this ent on said map
				loopvrev(mapsel->loadactions)
				{
					if(mapsel->loadactions[i]->type() != ACTION_TELEPORT)
						continue;

					if(((action_teleport *) mapsel->loadactions[i])->ent == entsel)
					{
						if(DEBUG_SCRIPT)
							conoutf(CON_DEBUG, "DEBUG: removing pending teleport for creature (%p) in map %s", entsel, mapsel->name);
						delete mapsel->loadactions[i];
						mapsel->loadactions.remove(i);
					}
				}

				mapsel->objs.removeobj(entsel);
				destmap->objs.add(entsel);
			}

			if(curmap != destmap)
			{
				if(DEBUG_SCRIPT)
					conoutf(CON_DEBUG, "DEBUG: destmap is not curmap, preparing loadaction");
				destmap->loadactions.add(new action_teleport(entsel, *d));
				return;
			}
		}

		if(DEBUG_SCRIPT)
			conoutf(CON_DEBUG, "DEBUG: curmap teleport, transferring creature (%p) to teledest %i", entsel, *d);

		entities::teleport(entsel, *d);
	)

	ICOMMAND(r_kill, "", (),
		if(!entsel)
		{
			conoutf(CON_ERROR, "ERROR: can't kill - no entity selected");
			return;
		}

		if(DEBUG_SCRIPT)
			conoutf(CON_DEBUG, "DEBUG: killed entity %p", entsel);
		entsel->die();
	)

	ICOMMAND(r_pickup, "", (),
		if(!actor || !entsel || entsel->type() != ENT_ITEM)
			return;

		if(actor->pickup(entsel))
		{
			if(DEBUG_SCRIPT)
				conoutf(CON_DEBUG, "DEBUG: pickup successful, deleting object");
			mapsel->objs.removeobj(entsel);
			delete entsel; entsel = NULL;
			item = NULL;
		}
	)

	ICOMMAND(r_add_item, "ii", (int *i, int *q),
		//exploits drop, -ve's add items
		if(!entsel)
			return;
		entsel->drop(*i, min(0, -*q));
	)

	ICOMMAND(r_drop, "ii", (int *i, int *q),
		if(!entsel)
			return;
		intret(entsel->drop(*i, max(0, *q)));
	)

	ICOMMAND(r_equip, "ii", (int *i, int *u),
		if(!entsel)
			return;
		entsel->equip(*i, *u);
	)

	ICOMMAND(r_dequip, "ii", (int *i, int *s),
		if(!entsel)
			return;
		entsel->dequip(*i, *s);
	)

	ICOMMAND(r_remove, "ii", (int *i, int *q),
		if(!entsel)
			return;
		intret(entsel->drop(*i, *q, false));
	)

	ICOMMAND(r_trigger, "", (),
		if(!entsel || entsel->type() != ENT_OBJECT)
		{
			if(DEBUG_SCRIPT && !entsel)
				conoutf(CON_DEBUG, "DEBUG: No entity selected, ignoring r_trigger");
			else if(DEBUG_SCRIPT && entsel->type() != ENT_OBJECT)
				conoutf(CON_DEBUG, "DEBUG: Selected entity %p is not an object, ignoring trigger call", entsel);
			return;
		}
		rpgobject *obj = (rpgobject *) entsel;
		obj->lasttrigger = lastmillis;
		obj->flags ^= rpgobject::TRIGGERED;
		if(DEBUG_SCRIPT)
			conoutf(CON_DEBUG, "DEBUG: Triggered entity %p, triggered status is now %i", entsel, obj->flags & rpgobject::TRIGGERED);
	)

	ICOMMAND(r_destroy, "", (),
		if(!entsel)
			return;
		if(entsel == game::player1)
		{
			conoutf(CON_ERROR, "ERROR: cannot destroy player entity via r_destroy");
			return;
		}

		if(DEBUG_SCRIPT)
			conoutf(CON_DEBUG, "DEBUG: queuing entity %p for destruction", entsel);

		obits.add(entsel);
	)

	//add effect
	//resurrect

	/**
		ITEM STUFF
	*/

	ICOMMAND(r_get_itembase, "", (), intret(item ? item->base : -1);)
	ICOMMAND(r_get_itemamount, "i", (int *i),
		if(item && !entsel)
			intret(item->quantity);
		else
			intret(entsel ? entsel->getitemcount(item ? item->base : *i) : 0);
	)

	ICOMMAND(r_item_mod_quantity, "i", (int *n),
		if(item)
			item->quantity = max(0, item->quantity + *n);
	)

	ICOMMAND(r_item_drop, "i", (int *n),
		if(!item || !entsel) //assume this is only true when already in world
		{
			conoutf(CON_ERROR, "ERROR: NULL item or no entity selected");
			return;
		}
		else //only true if the above isn't, to be otherwise is a bug
			intret(entsel->drop(item->base, max(0, *n)));
	)

	ICOMMAND(r_item_remove, "i", (int *n),
		if(!item || !entsel) //assume this is only true when already in world
		{
			conoutf(CON_ERROR, "ERROR: NULL item or no entity selected");
			return;
		}
		else //only true if the above isn't, to be otherwise is a bug
			intret(entsel->drop(item->base, *n, false));
	)

	ICOMMAND(r_item_equip, "i", (int *u),
		if(!item || !entsel)
			return;
		entsel->equip(item->base, *u);
	)

	ICOMMAND(r_item_dequip, "i", (int *s),
		if(!item || !entsel)
			return;
		entsel->dequip(item->base, *s);
	)
}
