#include "rpggame.h"

void rpgobject::resetmdl()
{
	temp.mdl = mdl;
}

void rpgobject::update()
{
	resetmdl();
	temp.light = vec4(0, 0, 0, 0);
	temp.alpha = 1;

	state = (flags & TRIGGERED) ? CS_DEAD : CS_ALIVE; //hack to get past collisions

	if(flags & MOVABLE)
	{
		vec old = o;
		moveplayer(this, 2, false);
		entities::touchents(this);
		old.sub(o);
		loopv(stack)
			stack[i]->o.add(old);
	}
	else if(flags & PLATFORM)
	{
		//WRITE ME
	}

	stack.setsize(0);
}

const char *rpgobject::getname() const
{
	return name ? name : "Objectivus Maximus";
}

void rpgobject::applyeffects(statusgroup *g, float mag, bool instant, rpgent *owner)
{
	loopv(g->effects)
	{
		switch(g->effects[i]->type)
		{
			case STATUS_INVIS:
			{
				if(instant)
					continue;

				status_generic *gen = (status_generic *) g->effects[i];
				temp.alpha -= gen->strength / 100.0f * mag;

				continue;
			}
			case STATUS_LIGHT:
			{
				if(instant)
					continue;

				status_light *light = (status_light *) g->effects[i];
				vec4 l = vec4(light->colour, light->radius).mul(mag);

				temp.light.add(l);

				continue;
			}
			case STATUS_POLYMORPH:
			{
				if(instant)
					continue;

				status_polymorph *poly = (status_polymorph *) g->effects[i];
				temp.mdl = poly->mdl;
				continue;
			}
			case STATUS_LOCK:
			{
				///WRITE ME
				continue;
			}
			case STATUS_UNLOCK:
			{
				///WRITE ME
				continue;
			}
		}
	}
}

void rpgobject::render(bool mainpass)
{
	rendermodel(&light, temp.mdl, (flags & TRIGGERED) ? ANIM_TRIGGER : (lasttrigger - lastmillis > 1500 ? ANIM_MAPMODEL|ANIM_LOOP : ANIM_TRIGGER|ANIM_REVERSE), vec(o).sub(vec(0, 0, eyeheight)), yaw, pitch, 0, MDL_SHADOW|MDL_CULL_VFC|MDL_CULL_DIST|MDL_CULL_OCCLUDED|MDL_LIGHT, NULL, NULL, lasttrigger, 0, temp.alpha);
}

int rpgobject::drop(int b, int q, bool spawn)
{
	if(!(flags & CONTAINER))
		return 0;

	if(!game::items.inrange(b))
	{
		conoutf(CON_ERROR, "ERROR: cannot drop/add item %i, does not exist", b);
		return 0;
	}

	invstack *item = NULL;
	loopv(inventory)
	{
		if(inventory[i]->base == b)
		{
			item = inventory[i];
			break;
		}
	}
	if(!item && q > 0)
		return 0;
	else if (q < 0)
	{
		if(!item) inventory.add(new invstack(b, -q));
		else item->quantity -= q;

		return 0;
	}

	if(q > item->quantity)
		q = item->quantity;

	item->quantity -= q;
	if(spawn)
	{
		rpgitem *dropping = new rpgitem();
		dropping->base = item->base;
		dropping->quantity = item->quantity;
		dropping->newpos = dropping->o = vec(o).add(vec(yaw * RAD, 0).mul(radius));
		game::curmap->objs.add(dropping);
	}
	return q;
}

int rpgobject::getitemcount(int i)
{
	loopvj(inventory)
	{
		if(inventory[j]->base == i)
			return inventory[j]->quantity;
	}
	return 0;
}

void rpgobject::hit(rpgent *attacker, use_weapon *weapon, use_weapon *ammo, float mul, vec dir)
{
	if(DEBUG_ENT)
		conoutf(CON_DEBUG, "DEBUG: ent %p hit by %p, applying effects from %p %p with mul %f", this, attacker, weapon, ammo, mul);

	if(!game::statuses.inrange(weapon->status) || (ammo && !game::statuses.inrange(ammo->status)))
	{
		conoutf(CON_ERROR, "ERROR: out of range effect, not applying: wep %p %i ammo %p %i", weapon, weapon->status, ammo, ammo ? ammo->status : 0);
		return;
	}

	seffects.add(new victimeffect(attacker, weapon->duration, weapon->status, mul));
	if(flags & MOVABLE) vel.add(vec(dir).mul(weapon->kickback));

	if(ammo)
	{
		seffects.add(new victimeffect(attacker, ammo->duration, ammo->status, mul));
		if(flags & MOVABLE) vel.add(vec(dir).mul(ammo->kickback));
	}

	rpgscript::doentscript(this, attacker, SCR_HIT);
}
