#include "rpggame.h"

///USE apply functionality - limited to characters and derived

void use::apply(rpgchar *user)
{
	user->seffects.add(new victimeffect(user, duration, status, mul));
}

void use_armour::apply(rpgchar *user)
{
	user->applyeffects(game::statuses[status], user->base.skillpotency(skill)*mul, false, user);
}

void use_weapon::apply(rpgchar *user) {} // does nothing, do it in the character update loop

///base functions
bool rpgchar::checkammo(equipment &eq, equipment *quiver, bool remove)
{
	//it is assumed it's valid
	use_weapon *wep = (use_weapon *) game::items[eq.base]->uses[eq.use];
	switch(wep->ammo)
	{
		case -3:
			if(base.experience < wep->cost)
			{
				conoutf("You lack sufficient exp to perform this action");
				return false;
			}
			if(remove) base.experience -= wep->cost;
			return true;
		case -2: case -1:
		{
			if((wep->ammo == -1 ? mana : health) < wep->cost)
			{
				conoutf(wep->ammo == -1 ? "You lack the mana to cast the full spell" : "Doing this would be suicide");
				return false;
			}
			if(remove) (wep->ammo == -1 ? mana : health) -= wep->cost;
			return true;
		}
		default:
		{
			if(!game::ammotypes.inrange(wep->ammo))
			{
				conoutf(CON_ERROR, "ERROR: invalid ammotype %i; out of range", wep->ammo);
				return false;
			}
			ammotype *at = game::ammotypes[wep->ammo];
			int base = -1;

			if(quiver)     base = at->items.find(quiver->base);
			if(base == -1) base = at->items.find(eq.base);
			if(base == -1) return false;

			if(getitemcount(base) < wep->cost)
				return false;

			if(remove)
			{
				drop(base, wep->cost, false);
				if(getitemcount(base) == 0) return false; //this is the remove ammo pass - let it be known the quiver is no longer valid
			}
			return true;
		}
	}
}

void rpgchar::doattack(equipment *eleft, equipment *eright, equipment *quiver)
{
	use_weapon *left = eleft ? (use_weapon *) game::items[eleft->base]->uses[eleft->use] : NULL,
	           *right = eright ? (use_weapon *) game::items[eright->base]->uses[eright->use] : NULL,
	           *ammo = NULL;

	if(charge && !primary && !secondary)
	{
		if((left && lastprimary) || (left == right && lastsecondary))
			attack = left;
		else
			attack = right;
	}
	else if((primary || secondary) && left && left == right)
		attack = right;
	else if((primary && left) ^ (secondary && right))
		attack = (primary && left) ? left : right;

	lastprimary = primary; lastsecondary = secondary;

	//we're attacking and can attack, oh noes!
	if(attack)
	{
		if(attack->cost)
		{
			if(!checkammo(attack == left ? *eleft : *eright, quiver))
			{
				lastaction = lastmillis + 100;
				return; //we lack the catalysts, don't attack
			}
			if(quiver && -1 == game::ammotypes[attack->ammo]->items.find(quiver->base)) quiver = NULL;
		}
		ammo = (use_weapon *) ((quiver && attack->ammo >= 0) ? game::items[quiver->base]->uses[quiver->use] : NULL);

		float mul = attack->maxcharge;
		if(attack->charge)
		{
			if(primary || secondary)
			{
				charge += curtime;
				return; //we're charging, don't attack... yet
			}

			mul = min<float>((float)charge / attack->charge, attack->maxcharge);
			charge = 0;

			if(mul < attack->mincharge)
				return;
		}
		mul += attack->basecharge;
		mul *= base.skillpotency(attack->skill); //apply skill and attribute modifiers

		switch(attack->target)
		{
			case T_SINGLE:
			case T_MULTI:
			case T_AREA:
			{
				projectile *p = game::curmap->projs.add(new projectile());
				p->init(this, attack == left ? eleft : eright, attack->ammo >= 0 ? quiver : NULL, 0);
				p->charge = mul;
				break;
			}

			case T_SELF:
				hit(this, attack, ammo, mul, vec(0, 0, 1));
				rpgeffect::drawaura(game::effects[attack->effect], this, mul, rpgeffect::DEATH, 0);
				break;

			case T_HORIZ:
			case T_VERT:
			{
				vec dir = vec(
					(yaw   - (attack->target == T_HORIZ ? attack->angle / 2 : 0)) * RAD,
					(pitch - (attack->target == T_VERT  ? attack->angle / 2 : 0)) * RAD
				);
				vec perp = vec(yaw * RAD, 0).rotate_around_z(90 * RAD);
				vec orig = vec(o).sub(vec(0, 0, eyeheight / 2));
				vector<rpgent *> hit;
				vector<vec> hits;

				loopi(attack->angle + 1)
				{
					vec ray = vec(dir).mul(attack->range + radius).add(orig);
					loopvj(game::curmap->objs)
					{
						rpgent *obj = game::curmap->objs[j];
						float dist;
						if(obj != this && game::intersect(obj, orig, ray, dist) && dist <= 1)
						{
							if(hit.find(obj) == -1) hit.add(obj);
							hits.add(vec(ray).sub(orig).mul(dist));
						}
					}

					if(attack->target == T_HORIZ)
						dir.rotate_around_z(1 * RAD);
					else
						dir.rotate(-1 * RAD, perp);
				}

				loopv(hit)
					hit[i]->hit(this, attack, ammo, mul, vec(yaw * RAD, pitch * RAD));

				loopv(hits)
				{
					vec pos = vec(hits[i]).add(orig);
					rpgeffect::drawsplash(game::effects[attack->effect], pos, 5, 1, rpgeffect::DEATH, 1);
				}

				rpgeffect::drawcircle(this, attack, mul, rpgeffect::TRAIL_SINGLE, 0);

				break;
			}
		}

		if(attack->cost)
			checkammo(attack == left ? *eleft : *eright, quiver, true); //remove ammo

		lastaction = lastmillis + attack->cooldown;
	}
}

void rpgchar::resetmdl()
{
	temp.mdl = mdl;
}

void rpgchar::update()
{
	resetmdl();
	temp.alpha = 1;
	temp.light = vec4(0, 0, 0, 0);
	attack = NULL;

	/// TODO when the GUI is implemented, disable this for the player

	while(base.points)
	{
		if(rnd(2))
		{
			int attr = rnd(STAT_MAX);
			static const char *stats[] = {"strength", "endurance", "agility", "charisma", "wisdom", "intelligence", "luck"};
			base.baseattrs[attr]++;

			if(this == game::player1)
				conoutf("%s improved to %i", stats[attr], base.baseattrs[attr]);
		}
		else
		{
			int skill = rnd(SKILL_MAX);
			static const char *skills[] = {"armour", "diplomacy", "magic", "marksman", "melee", "stealth"};
			base.baseskills[skill]++;

			if(this == game::player1)
				conoutf("%s improved to %i", skills[skill], base.baseskills[skill]);
		}

		base.points--;
	}

	if(state == CS_DEAD)
	{
		move = strafe = 0;
	}
	else
	{
		base.setspeeds(maxspeed, jumpvel);
		mana =   min<float>(base.getmaxmp(),   mana + (base.getmpregen() * curtime / 1000.0f));
		health = min<float>(base.getmaxhp(), health + (base.gethpregen() * curtime / 1000.0f));

		if(health < 0)
			die(NULL);
	}

	///AI STUFF - player can use it during cutscenes
	if(state != CS_DEAD && (this != game::player1 || camera::cutscene))
	{
		move = strafe = jumping = 0;
		directives.sort(directive::compare);
		loopv(directives)
		{
			if(!directives[i]->update(this))
			{
				delete directives[i]; directives.remove(i); i--;
			}
		}
	}

	if(state == CS_DEAD)
	{
		if(ragdoll)
			moveragdoll(this);
		else
			moveplayer(this, this == game::player1 ? 8 : 2, false);

		base.resetdeltas();
		return;
	}

	moveplayer(this, this == game::player1 ? 8 : 2, true);
	entities::touchents(this);

	//handle equipment
	equipment *eleft = NULL, //primary
	          *eright = NULL, //secondary
	          *quiver = NULL;
	loopv(equipped)
	{
		use *usable = game::items[equipped[i].base]->uses[equipped[i].use];
		usable->apply(this);
		if(usable->type == USE_WEAPON)
		{
			use_weapon *wep = (use_weapon *) usable;
			if(wep->slots & SLOT_LHAND)
			{
				eleft = &equipped[i];
			}
			if(wep->slots & SLOT_RHAND)
			{
				eright = &equipped[i];
			}
			if(wep->slots & SLOT_QUIVER)
				quiver = &equipped[i];
		}
	}

	if(lastmillis >= lastaction)
		doattack(eleft, eright, quiver);

	base.resetdeltas();
}

void rpgchar::render(bool mainpass)
{
	int lastaction = 0,
	anim = ANIM_ATTACK1,
	delay = 300,
	hold = ANIM_HOLD1;

	renderclient(this, temp.mdl ? temp.mdl : mdl, NULL /* attachments */, hold, anim, delay, lastaction, state!=CS_DEAD ? 0 : 0 /* lastpain */, temp.alpha, true);
}

const char *rpgchar::getname() const {return name ? name : "Shirley";}

///Character/AI
void rpgchar::equip(int i, int u)
{
	if(primary || secondary || lastprimary || lastsecondary)
	{
		conoutf("You can't equip items while attacking!");
		return;
	}

	invstack *item = NULL;
	loopvj(inventory)
	{
		if(inventory[j]->base == i)
		{
			item = inventory[j];
			break;
		}
	}
	if(!item || !item->quantity)
	{
		conoutf(CON_ERROR, "ERROR: user contains no instances of item %i", i);
		return;
	}
	else if(!game::items[i]->uses.inrange(u))
	{
		conoutf(CON_ERROR, "ERROR: unable to equip item, desired use method out of range");
		return;
	}
	else if(game::items[i]->uses[u]->type < USE_ARMOUR)
	{
		conoutf(CON_ERROR, "ERROR: invalid use type, needs to be of type weapon or armour to equip");
		return;
	}

	use_armour *usecase = (use_armour *) game::items[i]->uses[u];

	if(!usecase->reqs.meet(base))
	{
		conoutf("You cannot wield this item! You do not meet the requirements!");
		return;
	}

	if(usecase->slots)
		dequip(-1, usecase->slots);

	equipped.add(equipment(i, u));
	rpgscript::doitemscript(item, this, SCR_EQUIP);
	item->quantity--;
}

void rpgchar::dequip(int i, int slots)
{
	if(primary || secondary || lastprimary || lastsecondary)
	{
		conoutf("You can't dequip items while attacking!");
		return;
	}
	loopvj(equipped)
	{
		invstack *item = NULL;
		loopvk(inventory)
		{
			if(inventory[k]->base == equipped[j].base)
			{
				item = inventory[k];
				break;
			}
		}
		//this should not happen
		if(!item)
		{
			item = new invstack(equipped[j].base, 0);
			inventory.add(item);
		}

		use_armour *arm = (use_armour *) game::items[equipped[j].base]->uses[equipped[j].use];
		if((i == -1 ? true : equipped[j].base == i) && (slots ? arm->slots & slots : true))
		{
			item->quantity++;
			equipped.remove(j);
			j--;
		}
	}
}

void rpgchar::die(rpgent *killer)
{
	if(DEBUG_ENT)
		conoutf(CON_DEBUG, "DEBUG: ent %p killed by %p%s", this, killer, state != CS_ALIVE ? "; already dead?" : "");
	if(state != CS_ALIVE)
		return;

	if(killer)
		killer->givexp((killer == this ? -100 : 25) * base.level);

	state = CS_DEAD;
	health = 0;
	route.setsize(0);
	rpgscript::doentscript(this, killer, SCR_DEATH);
}

void rpgchar::respawn()
{
	if(state != CS_DEAD)
		return;

	cleanragdoll(this);
	seffects.deletecontents();
	state = CS_ALIVE;
	findplayerspawn(this, -1);
	health = base.getmaxhp();
}

void rpgchar::hit(rpgent *attacker, use_weapon *weapon, use_weapon *ammo, float mul, vec dir)
{
	if(DEBUG_ENT)
		conoutf(CON_DEBUG, "DEBUG: ent %p hit by %p, applying effects from %p %p with mul %f", this, attacker, weapon, ammo, mul);

	if(!game::statuses.inrange(weapon->status) || (ammo && !game::statuses.inrange(ammo->status)))
	{
		conoutf(CON_ERROR, "ERROR: out of range effect, not applying: wep %p %i ammo %p %i", weapon, weapon->status, ammo, ammo ? ammo->status : 0);
		return;
	}

	float wepmul = mul;
	if(!game::statuses[weapon->status]->friendly)
	{
		if(DEBUG_ENT)
			conoutf(CON_DEBUG, "DEBUG: ent has threshold of %i, removing %f from wepmul %f", base.getthreshold(weapon->element), base.getthreshold(weapon->element) * 0.01, wepmul);
		wepmul -= base.getthreshold(weapon->element) / 100.0f;

		if(DEBUG_ENT)
			conoutf(CON_DEBUG, "DEBUG: ent has resistance of %i, multiplying %f by %f", base.getresistance(weapon->element), wepmul, (100 - base.getresistance(weapon->element)) / 100.0f);

		wepmul *= (100 - base.getresistance(weapon->element)) / 100.0f;
	}
	if(DEBUG_ENT)
		conoutf(CON_DEBUG, "DEBUG: Applying weapon status group %i of duration %i and final mul %f", weapon->status, weapon->duration, wepmul);
	seffects.add(new victimeffect(attacker, weapon->duration, weapon->status, wepmul));
	vel.add(vec(dir).mul(weapon->kickback));

	if(ammo)
	{
		if(!game::statuses[weapon->status]->friendly)
		{
			if(DEBUG_ENT)
				conoutf(CON_DEBUG, "DEBUG: ent has threshold of %i, removing %f from mul %f", base.getthreshold(ammo->element), base.getthreshold(ammo->element) * 0.01, mul);
			mul -= base.getthreshold(ammo->element) / 100.0f;

			if(DEBUG_ENT)
				conoutf(CON_DEBUG, "DEBUG: ent has resistance of %i, multiplying %f by %f", base.getresistance(ammo->element), mul, (100 - base.getresistance(ammo->element)) / 100.0f);

			mul *= (100 - base.getresistance(ammo->element)) / 100.0f;
		}
		if(DEBUG_ENT)
			conoutf(CON_DEBUG, "DEBUG: Applying ammo status group %i of duration %i and final mul %i", ammo->status, ammo->duration, mul);
		seffects.add(new victimeffect(attacker, ammo->duration, ammo->status, mul));
		vel.add(vec(dir).mul(ammo->kickback));
	}

	rpgscript::doentscript(this, attacker, SCR_HIT);
}

void rpgchar::applyeffects(statusgroup *g, float mag, bool instant, rpgent *owner)
{
	loopv(g->effects)
	{
		switch(g->effects[i]->type)
		{
			case STATUS_HEALTH:
			{
				status_generic *gen = (status_generic *) g->effects[i];
				if(instant)
					health += gen->strength * mag;
				else
					health += gen->strength * curtime / 1000.0f * mag;

				if(gen->strength < 0 && health < 0) die(owner);

				continue;
			}
			case STATUS_MANA:
			{
				status_generic *gen = (status_generic *) g->effects[i];
				if(instant)
					mana += gen->strength * mag;
				else
					mana += gen->strength * curtime / 1000.0f * mag;
				mana = max<float>(0, mana);

				continue;
			}
			case STATUS_MOVE:
			{
				if(instant)
					continue;

				status_generic *gen = (status_generic *) g->effects[i];
				base.deltamovespeed += gen->strength * mag;
				base.deltajumpvel += gen->strength * mag;

				continue;
			}
			case STATUS_CRIT:
			{
				if(instant) continue;

				status_generic *gen = (status_generic *) g->effects[i];
				base.deltacrit += gen->strength * mag;
				continue;
			}
			case STATUS_HREGEN:
			{
				if(instant)
					continue;

				status_generic *gen = (status_generic *) g->effects[i];
				base.deltahregen += gen->strength * mag;

				if(gen->strength < 0 && health < 0) die(owner);
				continue;
			}
			case STATUS_MREGEN:
			{
				if(instant)
					continue;

				status_generic *gen = (status_generic *) g->effects[i];
				base.deltamregen += gen->strength * mag;

				continue;
			}
			case STATUS_STRENGTH:
			case STATUS_ENDURANCE:
			case STATUS_AGILITY:
			case STATUS_CHARISMA:
			case STATUS_WISDOM:
			case STATUS_INTELLIGENCE:
			case STATUS_LUCK:
			{
				if(instant)
					continue;

				status_generic *gen = (status_generic *) g->effects[i];
				base.deltaattrs[gen->type - STATUS_STRENGTH] += gen->strength * mag;
				continue;
			}
			case STATUS_ARMOUR:
			case STATUS_DIPLOMANCY:
			case STATUS_MAGIC:
			case STATUS_MARKSMAN:
			case STATUS_MELEE:
			case STATUS_STEALTH:

			{
				if(instant) continue;

				status_generic *gen = (status_generic *) g->effects[i];
				base.deltaskills[gen->type - STATUS_MELEE] += gen->strength * mag;

				continue;
			}
			case STATUS_FIRE_T:
			case STATUS_WATER_T:
			case STATUS_AIR_T:
			case STATUS_EARTH_T:
			case STATUS_MAGIC_T:
			case STATUS_SLASH_T:
			case STATUS_BLUNT_T:
			case STATUS_PIERCE_T:
			{
				if(instant)
					continue;

				status_generic *gen = (status_generic *) g->effects[i];
				base.deltathresh[gen->type - STATUS_FIRE_T] += gen->strength * mag; //boost threshold

				continue;
			}
			case STATUS_FIRE_R:
			case STATUS_WATER_R:
			case STATUS_AIR_R:
			case STATUS_EARTH_R:
			case STATUS_MAGIC_R:
			case STATUS_SLASH_R:
			case STATUS_BLUNT_R:
			case STATUS_PIERCE_R:
			{
				if(instant)
					continue;

				status_generic *gen = (status_generic *) g->effects[i];
				base.deltaresist[gen->type - STATUS_FIRE_R] += gen->strength * mag; //boost resistance

				continue;
			}
			case STATUS_DISPELL:
				///WRITE ME
				continue;
			case STATUS_DOOM:
				if(instant)
					die(owner);
				///WRITE ME
				continue;
			case STATUS_REFLECT:
				///WRITE ME
				continue;
			case STATUS_INVIS:
			{
				if(instant)
					continue;

				status_generic *gen = (status_generic *) g->effects[i];
				temp.alpha -= gen->strength / 100.0f * mag;

				continue;
			}
			case STATUS_LIGHT:
			{
				if(instant)
					continue;

				status_light *light = (status_light *) g->effects[i];
				vec4 l = vec4(light->colour, light->radius).mul(mag);

				temp.light.add(l);

				continue;
			}
			case STATUS_STUN:
				///WRITE ME
				continue;
			case STATUS_POLYMORPH:
			{
				if(instant)
					continue;

				status_polymorph *poly = (status_polymorph *) g->effects[i];
				temp.mdl = poly->mdl;
				continue;
			}
			case STATUS_SILENCE:
				///WRITE ME
				continue;
		}
	}
}

///Inventory
int rpgchar::drop(int b, int q, bool spawn)
{
	if(!game::items.inrange(b))
	{
		conoutf(CON_ERROR, "ERROR: cannot drop/add item %i, does not exist", b);
		return 0;
	}

	invstack *item = NULL;
	int removed = 0;

	loopv(inventory)
	{
		if(inventory[i]->base == b)
		{
			item = inventory[i];
			break;
		}
	}

	//if an entry does not exist in the inventory, the item is not equipped
	if(!item && q > 0) return 0;
	else if (q < 0)
	{
		if(!item) inventory.add(new invstack(b, -q));
		else item->quantity -= q;

		return 0;
	}

	if(item->quantity >= q)
	{
		item->quantity -= q;
		removed = q;
	}
	else
	{
		removed = item->quantity;
		item->quantity = 0;
		loopvrev(equipped)
		{
			if(removed == q)
				break;
			if(equipped[i].base == b)
			{
				equipped.remove(i);
				removed++;
			}
		}
	}

	//spawn the item in world
	if(spawn)
	{
		rpgitem *dropping =  new rpgitem();
		dropping->base = b;
		dropping->quantity = removed;
		dropping->o = dropping->newpos = vec(o).add(vec(yaw * RAD, pitch * RAD).mul(radius));
		game::curmap->objs.add(dropping);
	}

	return removed;
}

bool rpgchar::pickup(rpgent *item)
{
	if(item->type() != ENT_ITEM)
		return false;

	rpgitem *pickup = (rpgitem *) item;
	if(!game::items.inrange(pickup->base))
	{
		conoutf(CON_ERROR, "ERROR: refusing to pickup item, base is out of range");
		return false;
	}

	invstack *inv = NULL;
	int weight = 0;
	loopv(inventory)
	{
		if(inventory[i]->base == pickup->base)
		{
			inv = inventory[i];
		}
		weight += game::items[inventory[i]->base]->weight * inventory[i]->quantity;
	}
	loopv(equipped)
	{
		weight += game::items[equipped[i].base]->weight;
	}

	//automatically pick up as much of it as you can

	int amount = pickup->quantity;
	weight += game::items[pickup->base]->weight;

	while(weight > base.getmaxcarry() && amount > 0)
	{
		amount--;
		weight -= game::items[pickup->base]->weight;
	}

	pickup->quantity -= amount;

	if(inv)
	{
		inv->quantity += amount;
	}
	else
	{
		inv = new invstack(pickup->base, amount);
		inventory.add(inv);
	}

	return pickup->quantity == 0;
}

void rpgchar::uncurse()
{

}

void rpgchar::curse()
{

}

int rpgchar::getitemcount(int i)
{
	int count = 0;
	loopvj(inventory)
	{
		if(inventory[j]->base == i)
			count += inventory[j]->quantity;
	}
	loopvj(equipped)
	{
		if(equipped[j].base == i)
			count++;
	}

	return count;
}

//AI specific stuff

void rpgchar::followroute()
{
	if(!route.length())
	{
		strafe = move = 0;
		return;
	}

	int ind;
	waypoint *closest = ai::closestwaypoint(feetpos());
	if(!closest) // this should not happen
	{
		route.setsize(0);
		return;
	}

	ind = closest - ai::waypoints.getbuf();

	if(ind == route[0] && closest->o.dist(feetpos()) < 8)
		route.remove(0);

	if(!target || !cansee(target))
	{
		strafe = 0;
		move = 1;
		vec dir = vec(ai::waypoints[route[0]].o).sub(feetpos());
		vectoyawpitch(dir, yaw, pitch);
	}
	else
	{
		strafe = move = 0;

		vec dir = vec(ai::waypoints[route[0]].o).sub(feetpos());
		dir.z = 0; dir.normalize();
		dir.rotate_around_z(-yaw * RAD);

		if(fabs(dir.y) >= .7)
			move = dir.y < 0 ? -1 : 1;
		if(fabs(dir.x) >= .7)
			strafe = dir.x < 0 ? -1 : 1;
	}
}

bool rpgchar::cansee(rpgent *d)
{
	//TODO     add in modifiers for sound, movement, light, invisibility and perception
	//TODO 2   do extra checks and stuff for fog (both in water and out)!

	//at present this will only see if the entity is within this creature's LoS
	vec dir = vec(d->o).sub(o).normalize();
	vec view = vec(yaw * RAD, pitch * RAD);

	if(dir.dot(view) >= .5)
	{
		vec pos;
		float dist = raycubepos(o, dir, pos, 0, RAY_ALPHAPOLY|RAY_CLIPMAT);
		if(o.dist_to_bb(d->feetpos(), d->abovehead()) <= dist)
			return true;
	}

	return false;
}
