#ifndef __KRSGAME_H__
#define __KRSGAME_H__

/*
 * Puzzle Games By: Dale Weiler (graphitemaster)
 * for use with sandbox and sandbox related projects or mods
*/

#include "cube.h"

#define ENTSPAWNTIME 30000

enum
{
	NOTUSED     = ET_EMPTY,      // entity slot not in use in map
	LIGHT       = ET_LIGHT,      // lightsource, attr1 = radius, attr2 = intensity
	MAPMODEL    = ET_MAPMODEL,   // attr1 = angle, attr2 = idx
	PLAYERSTART,                 // attr1 = angle
	ENVMAP      = ET_ENVMAP,     // attr1 = radius
	PARTICLES   = ET_PARTICLES,
	MAPSOUND    = ET_SOUND,
	SPOTLIGHT   = ET_SPOTLIGHT,


	PLAYERFINISH,
	MAXENTTYPES
};

struct pzlentity : extentity{};

struct pzlchar : dynent
{
	const char *name;
	int playerindex;

	bool attacking;
	editinfo *edit;

	pzlchar() : playerindex(0),  attacking(false)
	{
		respawn();
	}

	void respawn()
	{
		dynent::reset();
		collidetype = COLLIDE_AABB;

		attacking = false;
	}
};

namespace entities
{
	extern vector<extentity *> ents;

	extern void renderentities();
	extern void checkitems(pzlchar *d);
	extern void trypickup(int n, pzlchar *d);

	extern int lastpickupmillis;
}

namespace game
{
	extern pzlchar *player1;

	extern void spawnplayer(pzlchar *d);

	extern bool intermission;

	extern int debug;
}

#endif
