#include "rpggame.h"

namespace game
{
	void quad(int x, int y, int xs, int ys)
	{
		glBegin(GL_QUADS);
		glTexCoord2f(0, 0); glVertex2i(x,    y);
		glTexCoord2f(1, 0); glVertex2i(x+xs, y);
		glTexCoord2f(1, 1); glVertex2i(x+xs, y+ys);
		glTexCoord2f(0, 1); glVertex2i(x,    y+ys);
		glEnd();
	}

	VARP(testminimap, 0, 0, 1);
	VARP(minimapscale, 512, 1024, 8192);
	SVARP(minimapmap, "data/hud/2.3/testmap.png");

	void drawminimapblip(rpgent *obj)
	{
		static const int coords[4][2] = { {0,1}, {0,0}, {1, 0}, {1, 1}};
		vec pos = obj->o;
		pos.sub(player1->o).div(minimapscale);
		if(pos.magnitude() >= 1.0f) //just for the compass border :P
			return;

		int col = entcolour(obj);
		glColor4f(((col >> 16) & 0xFF) / 256.0f, ((col >> 8) & 0xFF) / 256.0f, (col & 0xFF) / 256.0f, min ((float)1, 3 - 3 * pos.magnitude()));

		if(obj->etype == ENT_CHAR)
		{
			settexture("data/hud/2.3/player.png", 3);
			glPushMatrix();
			glTranslatef(128, 128, 0);

			glBegin(GL_QUADS);
			loopi(4)
			{
				vec rot;
				vecfromyawpitch(obj->yaw + 90*(i) - 45, 0, false, true, rot);
				glTexCoord2f(coords[i][0], coords[i][1]);
				glVertex2i(128 * pos.x + 15 * rot.x, 128 * pos.y + 15 * rot.y);
			}
			glEnd();
			glPopMatrix();
		}
		else
		{
			settexture("data/hud/blip.png", 3);
			quad(128 + 128 * pos.x - 10, 128 + 128 * pos.y - 10, 20, 20);
		}
	}

	void drawminimap()
	{
		glColor4f(1, 1, 1, 1);
		float offset = minimapscale / (float) getworldsize();
		vec plyr = vec(player1->o.x, player1->o.y, 0).div(getworldsize());

		settexture(minimapmap, 3);
		static vec coords[16];
		if(coords[0].iszero())
		{
			loopi(16)
			{
				vecfromyawpitch(i * 360.0f / 16.0f, 0, false, true, coords[i]);
			}
		}

		//FIXME deal with the regions outside the texture (fill to black? how? cheat and use a frame?)
		glBegin(GL_POLYGON);
		loopi(16)
		{
			glTexCoord2f(plyr.x + coords[i].x * offset, plyr.y + coords[i].y * offset);
			glVertex2i(coords[i].x * 128 + 128, coords[i].y * 128 + 128);
		}
		glEnd();

		settexture("data/hud/2.3/compass.png", 3);
		quad(-2, -2, 258, 258);

		//TODO only render detected/found entities
		loopvrev(rpgobjs)
			drawminimapblip(rpgobjs[i]);
	}

	void drawbar(int w, int h, int x, int y, float progress, vec4 colour = vec4(1, 1, 1, 1))
	{
		glColor4f(1, 1, 1, 1);
		settexture("data/hud/rpg/hback.png", 3);
		quad(w, h, x, y);

		settexture("data/hud/rpg/hbar.png", 3);

		glColor4f(colour[0], colour[1], colour[2], colour[3]);
		glBegin(GL_QUADS);
		glTexCoord2f(0, 0);		glVertex2i(w,    h);
		glTexCoord2f(progress, 0);	glVertex2i(w + x * progress, h);
		glTexCoord2f(progress, 1);	glVertex2i(w + x * progress, h + y);
		glTexCoord2f(0, 1);		glVertex2i(w ,    h + y);
		glEnd();

	}

	void gameplayhud(int w, int h)
	{
		if(gui::guisopen()) return;
		//optimised for a resolution of 1600x1200 and/or 4:3 resolutions, the witchcraft below is for non 4:3 screens, such as 1440x900 or even 1280x1024
		//it basically moves stuff down/sideways to cater for the extra screen space, effectively placing the hud in the lower centre,
		//and setting two variables, eh and ew, for shifting things into the empty side screen space (widescreen) or the top (demented tall scren);

		glPushMatrix();

		float ratio = (float)h/(float)w, ew = 0, eh = 0; //Extra Width, Extra Height
		//-ew for the very left, and 1600+ew for the very right
		//1200 for the bottom, -eh for the very top
		if(ratio < .7495) //widescreen
		{
			ew = (1200/ratio - 1600)/2.0f; //note, the below translate is meant to move the to the centre of the screen
			glScalef(h/1200.0f, h/1200.0f, 1);
			glTranslatef(ew, 0, 0);
		}
		else if(ratio > .7505) //some strange tall screen
		{
			eh = (1600 * ratio) - 1200;
			glScalef(w/1600.0f, w/1600.0f, 1);
			glTranslatef(0, eh, 0);

		}
		else //4:3! yay!
			glScalef(h/1200.0f, h/1200.0f, 1);

		glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
		rpgchar *d = player1->getchar();

		if(d) //the idiot playing has his character set to something other than ENT_CHAR...
		{
			stats &s = d->attributes;

			drawbar(40 - ew, 1040, 250, 30, d->health/s.maxhealth, vec4(1, 0, 0, 1));
			drawbar(40 - ew, 1085, 250, 30, d->mana/s.maxmana, vec4(0, 0, 1, 1));

			drawbar(40 - ew, 1130, 250, 30,
				(d->base.levels[LEVEL_OVERALL].exp - rpgobj::calcexp(d->base.levels[LEVEL_OVERALL].level - 1)) / (d->base.levels[LEVEL_OVERALL].level * 1000.0f), vec4(.75, .75, 0, 1)
			);

			//so they're right handed.... least they're dextrous you sinistrous... you!
			//hint dextrous = right, sinistrous = left :P
			glColor4f(1, 1, 1, 1);
			if(d->selected[EQUIP_RHAND])
			{
				defformatstring(icon)("data/hud/rpg/%s", d->selected[EQUIP_RHAND]->icon);
				settexture(icon, 3);
			}
			else
				settexture("data/hud/rpg/empty", 3);
			quad(320, 1030, 150, 150);

			//do a drawicon for currently selected spell
			if(d->selectedspell)
			{
				defformatstring(icon)("data/hud/rpg/%s", d->selectedspell->icon);
				settexture(icon, 3);
			}
			else
				settexture("data/hud/rpg/empty", 3);
			quad(500, 1030, 150, 150);

			//only draw 8 effects
			int skipped = 0;
			loopi(player1->effects.length())
			{
				status &s = *player1->effects[i];
				if(s.duration < 1000 || s.duration + s.startmillis < lastmillis) {skipped++; continue;}

				float fade = min(1.0f, (s.duration + s.startmillis - lastmillis) / (s.duration * .2f));
				glColor4f(1, 1, 1, fade);
				settexture(geteffecticon(s), 3);
				quad(1440 + ew - 140 * (i - skipped), -eh + 25, 125, 125);

				glPushMatrix();
				glTranslatef(1440 + ew - 140 * (i - skipped), -eh + 175, 0);
				defformatstring(ds)("%i", (s.duration - (lastmillis - s.startmillis)) / 1000);

				int tw = text_width(ds);
				if(tw > 125)
					glScalef(125.0f/tw, 125.0f/tw, 1);
				draw_text(ds, max(0, (125-tw)/2), 0, 255, 255, 255, fade * 255.0f);

				glPopMatrix();

				if(i - skipped >= 7) break;
			}


		}

		//it's allowed the 600 pixels on the bottom right

		if(hover && hover->name)
		{
			d = hover->getchar();
			string ds;
			if(d && hover->state == CS_ALIVE)
			{
				drawbar(1050 + ew, 1123, 500, 60, d->health / d->attributes.maxhealth, vec4(1, 0, 0, 1));
			}
			else
			{
				glPushMatrix();

				formatstring(ds)("e to interact... write me");
				//TODO you heard the message, write what would happen if you interacted :P
				int width = text_width(ds);

				if(width > 550)
				{
					float scale = 550.0f/width;
					glTranslatef(1000+ew, 1060 + 64.0f * (1.0f-scale), 0);
					glScalef(scale, scale, 1);
				}
				else
					glTranslatef(1000+ew, 1060, 0);

				int colour = entcolour(hover);
				draw_text(ds, max(0, (550-width)/2), 64, (colour&0xFF0000) >> 16, (colour&0xFF00) >> 8, colour&0xFF);

				glPopMatrix();
			}

			glPushMatrix();

			formatstring(ds)("%s", hover->name);
			int tw = text_width(ds);

			if(tw > 550)
			{
				float scale = 550.0f/tw;
				glTranslatef(1000+ew, 980 + 64.0f * (1.0f-scale), 0);
				glScalef(scale, scale, 1);
			}
			else
				glTranslatef(1000+ew, 980, 0);

			int colour = entcolour(hover);
			draw_text(ds, max(0, (550-tw)/2), 64, (colour&0xFF0000) >> 16, (colour&0xFF00) >> 8, colour&0xFF);
			glPopMatrix();
		}

		if(testminimap && getworldsize() > 0)
		{
			glPushMatrix();
			glTranslatef(1550-256+ew, 1150-256, 0);
			drawminimap();
			glPopMatrix();
		}

		glPopMatrix();
	}
};