/***************************************************************************
 *   Copyright (C) 2003-2005 by Kevin Hessels                              *
 *   khessels@shaw.ca                                                      *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef KFOLDINGSETTINGSDIALOGUE_H
#define KFOLDINGSETTINGSDIALOGUE_H

#include <kdialogbase.h>

/**
@author Kevin Hessels
*/
class kfoldingConfigData;
class kfoldingSettingsWidget;

class kfoldingSettingsDialogue : public KDialogBase
{

Q_OBJECT

public:
	kfoldingSettingsDialogue( QWidget* parent = 0L, const char* name = 0L, kfoldingConfigData* cfg = 0L );
	~kfoldingSettingsDialogue();
	
signals:
	void settingsChanged();

protected slots:
	void slotOk();
	void slotApply();
	void slotCancel();
	
private slots:
	void slotWorkingDirChanged( const QString& );
	bool slotCheckAppletImage( const QString& );
	
private:
	void setupSettingsWidget();
	bool checkData();
	bool showImagePreview();
	QString findFoldingExe();

	kfoldingConfigData*		_configData;
	kfoldingSettingsWidget*		_settingsWidget;
	bool				_inputError;
};

#endif
