/*
 * Decompiled with CFR 0.152.
 */
package org.pdfbox.examples.util;

import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.pdfbox.cos.COSName;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.exceptions.WrappedIOException;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.graphics.xobject.PDXObject;
import org.pdfbox.pdmodel.graphics.xobject.PDXObjectImage;
import org.pdfbox.util.Matrix;
import org.pdfbox.util.PDFOperator;
import org.pdfbox.util.PDFStreamEngine;
import org.pdfbox.util.ResourceLoader;

public class PrintImageLocations
extends PDFStreamEngine {
    public PrintImageLocations() throws IOException {
        super(ResourceLoader.loadProperties("Resources/PDFTextStripper.properties"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            PrintImageLocations.usage();
        } else {
            PDDocument document = null;
            try {
                document = PDDocument.load(args[0]);
                if (document.isEncrypted()) {
                    try {
                        document.decrypt("");
                    }
                    catch (InvalidPasswordException e) {
                        System.err.println("Error: Document is encrypted with a password.");
                        System.exit(1);
                    }
                }
                PrintImageLocations printer = new PrintImageLocations();
                List allPages = document.getDocumentCatalog().getAllPages();
                for (int i = 0; i < allPages.size(); ++i) {
                    PDPage page = (PDPage)allPages.get(i);
                    System.out.println("Processing page: " + i);
                    printer.processStream(page, page.findResources(), page.getContents().getStream());
                }
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    protected void processOperator(PDFOperator operator, List arguments) throws IOException {
        String operation = operator.getOperation();
        if (operation.equals("Do")) {
            COSName objectName = (COSName)arguments.get(0);
            Map xobjects = this.getResources().getXObjects();
            PDXObject xobject = (PDXObject)xobjects.get(objectName.getName());
            if (xobject instanceof PDXObjectImage) {
                try {
                    PDPage page = this.getCurrentPage();
                    Matrix ctm = this.getGraphicsState().getCurrentTransformationMatrix();
                    double rotationInRadians = (double)page.findRotation() * Math.PI / 180.0;
                    AffineTransform rotation = new AffineTransform();
                    rotation.setToRotation(rotationInRadians);
                    AffineTransform rotationInverse = rotation.createInverse();
                    Matrix rotationInverseMatrix = new Matrix();
                    rotationInverseMatrix.setFromAffineTransform(rotationInverse);
                    Matrix rotationMatrix = new Matrix();
                    rotationMatrix.setFromAffineTransform(rotation);
                    Matrix unrotatedCTM = ctm.multiply(rotationInverseMatrix);
                    System.out.println("Found image[" + objectName.getName() + "] at " + unrotatedCTM.getXPosition() + "," + unrotatedCTM.getYPosition());
                }
                catch (NoninvertibleTransformException e) {
                    throw new WrappedIOException(e);
                }
            }
        } else {
            super.processOperator(operator, arguments);
        }
    }

    private static void usage() {
        System.err.println("Usage: java org.pdfbox.examples.pdmodel.PrintImageLocations <input-pdf>");
    }
}

