/*
 * Decompiled with CFR 0.152.
 */
package org.antlr.runtime.tree;

import java.util.ArrayList;
import java.util.List;
import org.antlr.runtime.tree.Tree;

public abstract class BaseTree
implements Tree {
    protected List children;

    public Tree getChild(int i) {
        if (this.children == null || i >= this.children.size()) {
            return null;
        }
        return (BaseTree)this.children.get(i);
    }

    public Tree getFirstChildWithType(int type) {
        int i = 0;
        while (this.children != null && i < this.children.size()) {
            Tree t = (Tree)this.children.get(i);
            if (t.getType() == type) {
                return t;
            }
            ++i;
        }
        return null;
    }

    public int getChildCount() {
        if (this.children == null) {
            return 0;
        }
        return this.children.size();
    }

    public void addChild(Tree t) {
        if (t == null) {
            return;
        }
        BaseTree childTree = (BaseTree)t;
        if (childTree.isNil()) {
            if (this.children != null && this.children == childTree.children) {
                throw new RuntimeException("attempt to add child list to itself");
            }
            if (childTree.children != null) {
                if (this.children != null) {
                    int n = childTree.children.size();
                    int i = 0;
                    while (i < n) {
                        this.children.add(childTree.children.get(i));
                        ++i;
                    }
                } else {
                    this.children = childTree.children;
                }
            }
        } else {
            if (this.children == null) {
                this.createChildrenList();
            }
            this.children.add(t);
        }
    }

    public void addChildren(List kids) {
        int i = 0;
        while (i < kids.size()) {
            Tree t = (Tree)kids.get(i);
            this.addChild(t);
            ++i;
        }
    }

    public void setChild(int i, BaseTree t) {
        if (this.children == null) {
            this.createChildrenList();
        }
        this.children.set(i, t);
    }

    public BaseTree deleteChild(int i) {
        if (this.children == null) {
            return null;
        }
        return (BaseTree)this.children.remove(i);
    }

    protected void createChildrenList() {
        this.children = new ArrayList();
    }

    public boolean isNil() {
        return false;
    }

    public Tree dupTree() {
        Tree newTree = this.dupNode();
        int i = 0;
        while (this.children != null && i < this.children.size()) {
            Tree t = (Tree)this.children.get(i);
            Tree newNode = t.dupNode();
            newTree.addChild(newNode);
            ++i;
        }
        return newTree;
    }

    public String toStringTree() {
        if (this.children == null || this.children.size() == 0) {
            return this.toString();
        }
        StringBuffer buf = new StringBuffer();
        if (!this.isNil()) {
            buf.append("(");
            buf.append(this.toString());
            buf.append(' ');
        }
        int i = 0;
        while (this.children != null && i < this.children.size()) {
            BaseTree t = (BaseTree)this.children.get(i);
            if (i > 0) {
                buf.append(' ');
            }
            buf.append(t.toStringTree());
            ++i;
        }
        if (!this.isNil()) {
            buf.append(")");
        }
        return buf.toString();
    }

    public int getLine() {
        return 0;
    }

    public int getCharPositionInLine() {
        return 0;
    }

    public abstract String toString();

    public BaseTree() {
    }

    public BaseTree(Tree node) {
    }
}

