/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGI_BV.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgi_brkVal(void)

	Parse value in buf and break it into its components:
	+ value (name of this value)
	+ data (data of this value)
	+ type
	+ trust level

	Return:
		NONE if a value was successfully parsed

ob: cfgi_brkVal
ty: L
su: inifile/2
sh: Parse the current value within cfgi_inis
lo: Parses the line currently located within cfgi_inis.buf and break it into
	its components:
		\item value (name of the value, left from equal sign)
		\item data  (data of the value, right from equal sign, includes comment)
		\item type
		\item trustlevel
		\nolist
	All members of the cfgi_inis structure are updated accordingly.
re: 
fi: cfgi_bv.c
in:

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include <ctype.h>
#include "inifile.loc"
#include "str.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGI_BV.C 1.4 2001/02/27 01:27:47 ska Exp ska $";
#endif

int cfgi_brkVal(void)
{	char *p, *q;

	DBG_ENTER("cfgi_brkVal", Suppl_inifile2)

	assert(I(buf));
	chkHeap

	I(value) = 0;			/* indicate error condition */

	p = skipws(I(buf));
	if(!*p || strchr(CFG_ANYCMT, *p))	/* complete comment line */
		DBG_RETURN_I(	CFG_ERR_COMMENT)

	if((q = strchr(p, '=')) == 0)	/* ill-formed line */
		DBG_RETURN_I( CFG_ERR_LINE)

	*q = '\0';			/* delimit name of value from data of value */
	I(data) = q + 1;	/* data starts immediately behind the '=' */
	I(comment) = q;		/* initialize with "", just to make it a valid
							pointer */

		/* fetch the: [\%\$\?]?\!?(\<\d+\>)?$	*/
	q = cfgi_getType(p, &I(trustlevel), &I(type));
	chkHeap

	while(--q >= p && isspace(*q));		/* remove trailing spaces */
	q[1] = '\0';				/* end of name of value */
	if(!*p)						/* empty value name */
		DBG_RETURN_I( CFG_ERR_LINE)

	I(value) = p;				/* indicate successful parsed line */
	I(decomposed) = 0;			/* still in raw format (as read) */
	strchr(I(data), '\0')[-1] = '\0';	/* strip the trailing '\n', Fgetline()
									ensures that there is always such char */

	chkHeap
	DBG_RETURN_I( CFG_ERR_NONE)
}
