/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.core;

import org.aspectj.org.eclipse.jdt.core.IClasspathContainer;
import org.aspectj.org.eclipse.jdt.core.IClasspathEntry;
import org.aspectj.org.eclipse.jdt.internal.core.UserLibrary;
import org.aspectj.org.eclipse.jdt.internal.core.UserLibraryManager;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class UserLibraryClasspathContainer
implements IClasspathContainer {
    private String name;

    public UserLibraryClasspathContainer(String libName) {
        this.name = libName;
    }

    private UserLibrary getUserLibrary() {
        return UserLibraryManager.getUserLibrary(this.name);
    }

    public IClasspathEntry[] getClasspathEntries() {
        UserLibrary library = this.getUserLibrary();
        if (library != null) {
            return library.getEntries();
        }
        return new IClasspathEntry[0];
    }

    public String getDescription() {
        return this.name;
    }

    public int getKind() {
        UserLibrary library = this.getUserLibrary();
        if (library != null && library.isSystemLibrary()) {
            return 2;
        }
        return 1;
    }

    public IPath getPath() {
        return new Path("org.aspectj.org.eclipse.jdt.USER_LIBRARY").append(this.name);
    }
}

