/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.ast;

import org.aspectj.org.eclipse.jdt.core.compiler.CharOperation;
import org.aspectj.org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Expression;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.Reference;
import org.aspectj.org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.aspectj.org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public abstract class Annotation
extends Expression {
    public TypeReference type;
    public int declarationSourceEnd;
    public Binding recipient;
    static final MemberValuePair[] NoValuePairs = new MemberValuePair[0];

    public static long getRetentionPolicy(char[] policyName) {
        if (policyName == null || policyName.length == 0) {
            return 0L;
        }
        switch (policyName[0]) {
            case 'C': {
                if (!CharOperation.equals(policyName, TypeConstants.UPPER_CLASS)) break;
                return 0x100000000000L;
            }
            case 'S': {
                if (!CharOperation.equals(policyName, TypeConstants.UPPER_SOURCE)) break;
                return 0x80000000000L;
            }
            case 'R': {
                if (!CharOperation.equals(policyName, TypeConstants.UPPER_RUNTIME)) break;
                return 0x180000000000L;
            }
        }
        return 0L;
    }

    public static long getTargetElementType(char[] elementName) {
        if (elementName == null || elementName.length == 0) {
            return 0L;
        }
        switch (elementName[0]) {
            case 'A': {
                if (!CharOperation.equals(elementName, TypeConstants.UPPER_ANNOTATION_TYPE)) break;
                return 0x20000000000L;
            }
            case 'C': {
                if (!CharOperation.equals(elementName, TypeConstants.UPPER_CONSTRUCTOR)) break;
                return 0x8000000000L;
            }
            case 'F': {
                if (!CharOperation.equals(elementName, TypeConstants.UPPER_FIELD)) break;
                return 0x1000000000L;
            }
            case 'L': {
                if (!CharOperation.equals(elementName, TypeConstants.UPPER_LOCAL_VARIABLE)) break;
                return 0x10000000000L;
            }
            case 'M': {
                if (!CharOperation.equals(elementName, TypeConstants.UPPER_METHOD)) break;
                return 0x2000000000L;
            }
            case 'P': {
                if (CharOperation.equals(elementName, TypeConstants.UPPER_PARAMETER)) {
                    return 0x4000000000L;
                }
                if (!CharOperation.equals(elementName, TypeConstants.UPPER_PACKAGE)) break;
                return 0x40000000000L;
            }
            case 'T': {
                if (!CharOperation.equals(elementName, TypeConstants.TYPE)) break;
                return 0x800000000L;
            }
        }
        return 0L;
    }

    private long detectStandardAnnotation(Scope scope, ReferenceBinding annotationType, MemberValuePair valueAttribute) {
        long tagBits = 0L;
        switch (annotationType.id) {
            case 48: {
                FieldBinding field;
                if (valueAttribute == null) break;
                Expression expr = valueAttribute.value;
                if ((expr.bits & 3) != 1 || (field = ((Reference)expr).fieldBinding()) == null || field.declaringClass.id != 51) break;
                tagBits |= Annotation.getRetentionPolicy(field.name);
                break;
            }
            case 50: {
                FieldBinding field;
                tagBits |= 0x400000000L;
                if (valueAttribute == null) break;
                Expression expr = valueAttribute.value;
                if (expr instanceof ArrayInitializer) {
                    ArrayInitializer initializer = (ArrayInitializer)expr;
                    Expression[] expressions = initializer.expressions;
                    if (expressions == null) break;
                    int i = 0;
                    int length = expressions.length;
                    while (i < length) {
                        FieldBinding field2;
                        Expression initExpr = expressions[i];
                        if ((initExpr.bits & 3) == 1 && (field2 = ((Reference)initExpr).fieldBinding()) != null && field2.declaringClass.id == 52) {
                            long element = Annotation.getTargetElementType(field2.name);
                            if ((tagBits & element) != 0L) {
                                scope.problemReporter().duplicateTargetInTargetAnnotation(annotationType, (NameReference)initExpr);
                            } else {
                                tagBits |= element;
                            }
                        }
                        ++i;
                    }
                    break;
                }
                if ((expr.bits & 3) != 1 || (field = ((Reference)expr).fieldBinding()) == null || field.declaringClass.id != 52) break;
                tagBits |= Annotation.getTargetElementType(field.name);
                break;
            }
            case 44: {
                tagBits |= 0x200000000000L;
                break;
            }
            case 45: {
                tagBits |= 0x400000000000L;
                break;
            }
            case 46: {
                tagBits |= 0x800000000000L;
                break;
            }
            case 47: {
                tagBits |= 0x1000000000000L;
                break;
            }
            case 49: {
                tagBits |= 0x2000000000000L;
            }
        }
        return tagBits;
    }

    public StringBuffer printExpression(int indent, StringBuffer output) {
        output.append('@');
        this.type.printExpression(0, output);
        return output;
    }

    public abstract MemberValuePair[] memberValuePairs();

    /*
     * Enabled aggressive block sorting
     */
    public TypeBinding resolveType(BlockScope scope) {
        long metaTagBits;
        this.constant = ASTNode.NotAConstant;
        TypeBinding typeBinding = this.type.resolveType(scope);
        if (typeBinding == null) {
            return null;
        }
        this.resolvedType = typeBinding;
        if (!typeBinding.isAnnotationType()) {
            scope.problemReporter().typeMismatchError(typeBinding, scope.getJavaLangAnnotationAnnotation(), this.type);
            return null;
        }
        ReferenceBinding annotationType = (ReferenceBinding)this.resolvedType;
        MethodBinding[] methods = annotationType.methods();
        MemberValuePair[] originalValuePairs = this.memberValuePairs();
        MemberValuePair valueAttribute = null;
        int pairsLength = originalValuePairs.length;
        MemberValuePair[] pairs = new MemberValuePair[pairsLength];
        System.arraycopy(originalValuePairs, 0, pairs, 0, pairsLength);
        int i = 0;
        int requiredLength = methods.length;
        while (i < requiredLength) {
            block28: {
                MethodBinding method = methods[i];
                char[] selector = method.selector;
                boolean foundValue = false;
                int j = 0;
                while (j < pairsLength) {
                    char[] name;
                    MemberValuePair pair = pairs[j];
                    if (pair != null && CharOperation.equals(name = pair.name, selector)) {
                        if (valueAttribute == null && CharOperation.equals(name, TypeConstants.VALUE)) {
                            valueAttribute = pair;
                        }
                        pair.binding = method;
                        pair.resolveTypeExpecting(scope, method.returnType);
                        pairs[j] = null;
                        foundValue = true;
                        boolean foundDuplicate = false;
                        int k = j + 1;
                        while (k < pairsLength) {
                            MemberValuePair otherPair = pairs[k];
                            if (otherPair != null && CharOperation.equals(otherPair.name, selector)) {
                                foundDuplicate = true;
                                scope.problemReporter().duplicateAnnotationValue(annotationType, otherPair);
                                otherPair.binding = method;
                                otherPair.resolveTypeExpecting(scope, method.returnType);
                                pairs[k] = null;
                            }
                            ++k;
                        }
                        if (foundDuplicate) {
                            scope.problemReporter().duplicateAnnotationValue(annotationType, pair);
                            break block28;
                        }
                    }
                    ++j;
                }
                if (!foundValue && (method.modifiers & 0x20000) == 0) {
                    scope.problemReporter().missingValueForAnnotationMember(this, selector);
                }
            }
            ++i;
        }
        i = 0;
        while (i < pairsLength) {
            if (pairs[i] != null) {
                scope.problemReporter().undefinedAnnotationValue(annotationType, pairs[i]);
            }
            ++i;
        }
        long tagBits = this.detectStandardAnnotation(scope, annotationType, valueAttribute);
        if (this.recipient == null) return this.resolvedType;
        if (tagBits != 0L) {
            switch (this.recipient.kind()) {
                case 16: {
                    break;
                }
                case 4: 
                case 1028: 
                case 2052: {
                    ((ReferenceBinding)this.recipient).tagBits |= tagBits;
                    break;
                }
                case 8: {
                    ((MethodBinding)this.recipient).tagBits |= tagBits;
                    break;
                }
                case 1: {
                    ((FieldBinding)this.recipient).tagBits |= tagBits;
                    break;
                }
                case 2: {
                    ((LocalVariableBinding)this.recipient).tagBits |= tagBits;
                    break;
                }
            }
        }
        if (((metaTagBits = annotationType.getAnnotationTagBits()) & 0x7FC00000000L) == 0L) {
            return this.resolvedType;
        }
        switch (this.recipient.kind()) {
            case 16: {
                if ((metaTagBits & 0x40000000000L) == 0L) break;
                return this.resolvedType;
            }
            case 4: 
            case 1028: {
                if (!(((ReferenceBinding)this.recipient).isAnnotationType() ? (metaTagBits & 0x20800000000L) != 0L : (metaTagBits & 0x800000000L) != 0L)) break;
                return this.resolvedType;
            }
            case 8: {
                if (!(((MethodBinding)this.recipient).isConstructor() ? (metaTagBits & 0x8000000000L) != 0L : (metaTagBits & 0x2000000000L) != 0L)) break;
                return this.resolvedType;
            }
            case 1: {
                if ((metaTagBits & 0x1000000000L) == 0L) break;
                return this.resolvedType;
            }
            case 2: {
                if (!(((LocalVariableBinding)this.recipient).isArgument ? (metaTagBits & 0x4000000000L) != 0L : (annotationType.tagBits & 0x10000000000L) != 0L)) break;
                return this.resolvedType;
            }
        }
        scope.problemReporter().disallowedTargetForAnnotation(this);
        return this.resolvedType;
    }

    public abstract void traverse(ASTVisitor var1, BlockScope var2);

    public abstract void traverse(ASTVisitor var1, CompilationUnitScope var2);
}

