/**
 * This class can take a variable number of parameters on the command
 * line. Program execution begins with the main() method. The class
 * constructor is not invoked unless an object of type 'Class1'
 * created in the main() method.
 */

import java.io.*;
import com.arbortext.catalog.*;

import java.net.URL;
import java.net.MalformedURLException;
import java.util.Hashtable;
import java.util.Stack;
import java.util.Vector;
import java.util.Enumeration;
import java.util.Properties;

import java.text.NumberFormat;

import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.ParserFactory;
import org.w3c.dom.*;
import org.apache.xerces.parsers.*;

public class eresolve
{
    /*
     * The main entry point for the application.
     *
     * @param args Array of parameters passed to the application
     * via the command line.
     */

    public static void main (String[] args)
	throws FileNotFoundException, IOException {

	String xmlfile = null;
	int debug = 0;

	Catalog c = new Catalog();
	CatalogEntityResolver cer = new CatalogEntityResolver();

	c.setParserClass("org.apache.xerces.parsers.SAXParser");
	c.loadSystemCatalogs();

	cer.setCatalog(c);

	for (int i=0; i<args.length; i++) {
	    if (args[i].equals("-c")) {
		++i;
		String catalog = args[i];
		System.out.println("Adding catalog: " + catalog);
		c.parseCatalog(catalog);
		continue;
	    }

	    if (args[i].equals("-d")) {
		++i;
		String debugstr = args[i];
		try {
		    debug = Integer.parseInt(debugstr);
		    c.debug = debug;
		    cer.debug = debug;
		    System.out.println("Set debug to " + debug);
		} catch (Exception e) {
		    // nop
		}
		continue;
	    }

	    if (args[i].equals("-r")) {
		System.out.println("Setting retry");
		cer.setRetry(true);
		continue;
	    }

	    xmlfile = args[i];
	}

	if (xmlfile == null) {
	    System.out.println("Usage: eresolve [-d level] [-c catalog ...] [-r] xmlfile");
	    System.exit(1);
	}

	System.out.println("Parsing " + xmlfile);
	if (debug < 2) {
	    System.out.println("With the current debug setting, no output is expected.");
	}

	SAXParser parser = new SAXParser();
	parser.setEntityResolver(cer);

        try {
            parser.parse(xmlfile);
        } catch (SAXException sx) {
            Exception ex = sx.getException();
            if (ex != null)
                ex.printStackTrace();
            else
                sx.printStackTrace();
        }

	System.out.println("Done parsing " + xmlfile);
    }
}
