// GENERATED FILE - DO NOT EDIT.
// Generated by generate_entry_points.py using data from gl.xml.
//
// Copyright 2019 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// entry_points_gles_1_0_autogen.cpp:
//   Defines the GLES 1.0 entry points.

#include "libGLESv2/entry_points_gles_1_0_autogen.h"

#include "libANGLE/Context.h"
#include "libANGLE/Context.inl.h"
#include "libANGLE/validationES1.h"
#include "libGLESv2/entry_points_utils.h"
#include "libGLESv2/global_state.h"

namespace gl
{
void GL_APIENTRY AlphaFunc(GLenum func, GLfloat ref)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum func = 0x%X, GLfloat ref = %f)", func, ref);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        AlphaTestFunc funcPacked = FromGLenum<AlphaTestFunc>(func);
        if (context->skipValidation() || ValidateAlphaFunc(context, funcPacked, ref))
        {
            context->alphaFunc(funcPacked, ref);
        }
    }
}

void GL_APIENTRY AlphaFuncx(GLenum func, GLfixed ref)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum func = 0x%X, GLfixed ref = 0x%X)", func, ref);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        AlphaTestFunc funcPacked = FromGLenum<AlphaTestFunc>(func);
        if (context->skipValidation() || ValidateAlphaFuncx(context, funcPacked, ref))
        {
            context->alphaFuncx(funcPacked, ref);
        }
    }
}

void GL_APIENTRY ClearColorx(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfixed red = 0x%X, GLfixed green = 0x%X, GLfixed blue = 0x%X, GLfixed alpha = 0x%X)",
          red, green, blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateClearColorx(context, red, green, blue, alpha))
        {
            context->clearColorx(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY ClearDepthx(GLfixed depth)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfixed depth = 0x%X)", depth);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateClearDepthx(context, depth))
        {
            context->clearDepthx(depth);
        }
    }
}

void GL_APIENTRY ClientActiveTexture(GLenum texture)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum texture = 0x%X)", texture);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateClientActiveTexture(context, texture))
        {
            context->clientActiveTexture(texture);
        }
    }
}

void GL_APIENTRY ClipPlanef(GLenum p, const GLfloat *eqn)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum p = 0x%X, const GLfloat *eqn = 0x%016" PRIxPTR ")", p, (uintptr_t)eqn);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateClipPlanef(context, p, eqn))
        {
            context->clipPlanef(p, eqn);
        }
    }
}

void GL_APIENTRY ClipPlanex(GLenum plane, const GLfixed *equation)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum plane = 0x%X, const GLfixed *equation = 0x%016" PRIxPTR ")", plane,
          (uintptr_t)equation);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateClipPlanex(context, plane, equation))
        {
            context->clipPlanex(plane, equation);
        }
    }
}

void GL_APIENTRY Color4f(GLfloat red, GLfloat green, GLfloat blue, GLfloat alpha)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfloat red = %f, GLfloat green = %f, GLfloat blue = %f, GLfloat alpha = %f)", red,
          green, blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateColor4f(context, red, green, blue, alpha))
        {
            context->color4f(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY Color4ub(GLubyte red, GLubyte green, GLubyte blue, GLubyte alpha)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLubyte red = %d, GLubyte green = %d, GLubyte blue = %d, GLubyte alpha = %d)", red,
          green, blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateColor4ub(context, red, green, blue, alpha))
        {
            context->color4ub(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY Color4x(GLfixed red, GLfixed green, GLfixed blue, GLfixed alpha)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfixed red = 0x%X, GLfixed green = 0x%X, GLfixed blue = 0x%X, GLfixed alpha = 0x%X)",
          red, green, blue, alpha);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateColor4x(context, red, green, blue, alpha))
        {
            context->color4x(red, green, blue, alpha);
        }
    }
}

void GL_APIENTRY ColorPointer(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLint size = %d, GLenum type = 0x%X, GLsizei stride = %d, const void *pointer = "
        "0x%016" PRIxPTR ")",
        size, type, stride, (uintptr_t)pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        VertexAttribType typePacked = FromGLenum<VertexAttribType>(type);
        if (context->skipValidation() ||
            ValidateColorPointer(context, size, typePacked, stride, pointer))
        {
            context->colorPointer(size, typePacked, stride, pointer);
        }
    }
}

void GL_APIENTRY DepthRangex(GLfixed n, GLfixed f)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfixed n = 0x%X, GLfixed f = 0x%X)", n, f);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateDepthRangex(context, n, f))
        {
            context->depthRangex(n, f);
        }
    }
}

void GL_APIENTRY DisableClientState(GLenum array)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum array = 0x%X)", array);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ClientVertexArrayType arrayPacked = FromGLenum<ClientVertexArrayType>(array);
        if (context->skipValidation() || ValidateDisableClientState(context, arrayPacked))
        {
            context->disableClientState(arrayPacked);
        }
    }
}

void GL_APIENTRY EnableClientState(GLenum array)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum array = 0x%X)", array);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ClientVertexArrayType arrayPacked = FromGLenum<ClientVertexArrayType>(array);
        if (context->skipValidation() || ValidateEnableClientState(context, arrayPacked))
        {
            context->enableClientState(arrayPacked);
        }
    }
}

void GL_APIENTRY Fogf(GLenum pname, GLfloat param)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum pname = 0x%X, GLfloat param = %f)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateFogf(context, pname, param))
        {
            context->fogf(pname, param);
        }
    }
}

void GL_APIENTRY Fogfv(GLenum pname, const GLfloat *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")", pname,
          (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateFogfv(context, pname, params))
        {
            context->fogfv(pname, params);
        }
    }
}

void GL_APIENTRY Fogx(GLenum pname, GLfixed param)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum pname = 0x%X, GLfixed param = 0x%X)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateFogx(context, pname, param))
        {
            context->fogx(pname, param);
        }
    }
}

void GL_APIENTRY Fogxv(GLenum pname, const GLfixed *param)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum pname = 0x%X, const GLfixed *param = 0x%016" PRIxPTR ")", pname,
          (uintptr_t)param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateFogxv(context, pname, param))
        {
            context->fogxv(pname, param);
        }
    }
}

void GL_APIENTRY Frustumf(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLfloat l = %f, GLfloat r = %f, GLfloat b = %f, GLfloat t = %f, GLfloat n = %f, GLfloat "
        "f = %f)",
        l, r, b, t, n, f);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateFrustumf(context, l, r, b, t, n, f))
        {
            context->frustumf(l, r, b, t, n, f);
        }
    }
}

void GL_APIENTRY Frustumx(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLfixed l = 0x%X, GLfixed r = 0x%X, GLfixed b = 0x%X, GLfixed t = 0x%X, GLfixed n = "
        "0x%X, GLfixed f = 0x%X)",
        l, r, b, t, n, f);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateFrustumx(context, l, r, b, t, n, f))
        {
            context->frustumx(l, r, b, t, n, f);
        }
    }
}

void GL_APIENTRY GetClipPlanef(GLenum plane, GLfloat *equation)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum plane = 0x%X, GLfloat *equation = 0x%016" PRIxPTR ")", plane,
          (uintptr_t)equation);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateGetClipPlanef(context, plane, equation))
        {
            context->getClipPlanef(plane, equation);
        }
    }
}

void GL_APIENTRY GetClipPlanex(GLenum plane, GLfixed *equation)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum plane = 0x%X, GLfixed *equation = 0x%016" PRIxPTR ")", plane,
          (uintptr_t)equation);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateGetClipPlanex(context, plane, equation))
        {
            context->getClipPlanex(plane, equation);
        }
    }
}

void GL_APIENTRY GetFixedv(GLenum pname, GLfixed *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum pname = 0x%X, GLfixed *params = 0x%016" PRIxPTR ")", pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateGetFixedv(context, pname, params))
        {
            context->getFixedv(pname, params);
        }
    }
}

void GL_APIENTRY GetLightfv(GLenum light, GLenum pname, GLfloat *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, GLfloat *params = 0x%016" PRIxPTR ")", light,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        LightParameter pnamePacked = FromGLenum<LightParameter>(pname);
        if (context->skipValidation() || ValidateGetLightfv(context, light, pnamePacked, params))
        {
            context->getLightfv(light, pnamePacked, params);
        }
    }
}

void GL_APIENTRY GetLightxv(GLenum light, GLenum pname, GLfixed *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, GLfixed *params = 0x%016" PRIxPTR ")", light,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        LightParameter pnamePacked = FromGLenum<LightParameter>(pname);
        if (context->skipValidation() || ValidateGetLightxv(context, light, pnamePacked, params))
        {
            context->getLightxv(light, pnamePacked, params);
        }
    }
}

void GL_APIENTRY GetMaterialfv(GLenum face, GLenum pname, GLfloat *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, GLfloat *params = 0x%016" PRIxPTR ")", face,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        MaterialParameter pnamePacked = FromGLenum<MaterialParameter>(pname);
        if (context->skipValidation() || ValidateGetMaterialfv(context, face, pnamePacked, params))
        {
            context->getMaterialfv(face, pnamePacked, params);
        }
    }
}

void GL_APIENTRY GetMaterialxv(GLenum face, GLenum pname, GLfixed *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, GLfixed *params = 0x%016" PRIxPTR ")", face,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        MaterialParameter pnamePacked = FromGLenum<MaterialParameter>(pname);
        if (context->skipValidation() || ValidateGetMaterialxv(context, face, pnamePacked, params))
        {
            context->getMaterialxv(face, pnamePacked, params);
        }
    }
}

void GL_APIENTRY GetPointerv(GLenum pname, void **params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum pname = 0x%X, void **params = 0x%016" PRIxPTR ")", pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateGetPointerv(context, pname, params))
        {
            context->getPointerv(pname, params);
        }
    }
}

void GL_APIENTRY GetTexEnvfv(GLenum target, GLenum pname, GLfloat *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfloat *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        if (context->skipValidation() ||
            ValidateGetTexEnvfv(context, targetPacked, pnamePacked, params))
        {
            context->getTexEnvfv(targetPacked, pnamePacked, params);
        }
    }
}

void GL_APIENTRY GetTexEnviv(GLenum target, GLenum pname, GLint *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint *params = 0x%016" PRIxPTR ")", target,
          pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        if (context->skipValidation() ||
            ValidateGetTexEnviv(context, targetPacked, pnamePacked, params))
        {
            context->getTexEnviv(targetPacked, pnamePacked, params);
        }
    }
}

void GL_APIENTRY GetTexEnvxv(GLenum target, GLenum pname, GLfixed *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfixed *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        if (context->skipValidation() ||
            ValidateGetTexEnvxv(context, targetPacked, pnamePacked, params))
        {
            context->getTexEnvxv(targetPacked, pnamePacked, params);
        }
    }
}

void GL_APIENTRY GetTexParameterxv(GLenum target, GLenum pname, GLfixed *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfixed *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        if (context->skipValidation() ||
            ValidateGetTexParameterxv(context, targetPacked, pname, params))
        {
            context->getTexParameterxv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY LightModelf(GLenum pname, GLfloat param)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum pname = 0x%X, GLfloat param = %f)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateLightModelf(context, pname, param))
        {
            context->lightModelf(pname, param);
        }
    }
}

void GL_APIENTRY LightModelfv(GLenum pname, const GLfloat *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")", pname,
          (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateLightModelfv(context, pname, params))
        {
            context->lightModelfv(pname, params);
        }
    }
}

void GL_APIENTRY LightModelx(GLenum pname, GLfixed param)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum pname = 0x%X, GLfixed param = 0x%X)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateLightModelx(context, pname, param))
        {
            context->lightModelx(pname, param);
        }
    }
}

void GL_APIENTRY LightModelxv(GLenum pname, const GLfixed *param)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum pname = 0x%X, const GLfixed *param = 0x%016" PRIxPTR ")", pname,
          (uintptr_t)param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateLightModelxv(context, pname, param))
        {
            context->lightModelxv(pname, param);
        }
    }
}

void GL_APIENTRY Lightf(GLenum light, GLenum pname, GLfloat param)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, GLfloat param = %f)", light, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        LightParameter pnamePacked = FromGLenum<LightParameter>(pname);
        if (context->skipValidation() || ValidateLightf(context, light, pnamePacked, param))
        {
            context->lightf(light, pnamePacked, param);
        }
    }
}

void GL_APIENTRY Lightfv(GLenum light, GLenum pname, const GLfloat *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")",
          light, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        LightParameter pnamePacked = FromGLenum<LightParameter>(pname);
        if (context->skipValidation() || ValidateLightfv(context, light, pnamePacked, params))
        {
            context->lightfv(light, pnamePacked, params);
        }
    }
}

void GL_APIENTRY Lightx(GLenum light, GLenum pname, GLfixed param)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, GLfixed param = 0x%X)", light, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        LightParameter pnamePacked = FromGLenum<LightParameter>(pname);
        if (context->skipValidation() || ValidateLightx(context, light, pnamePacked, param))
        {
            context->lightx(light, pnamePacked, param);
        }
    }
}

void GL_APIENTRY Lightxv(GLenum light, GLenum pname, const GLfixed *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum light = 0x%X, GLenum pname = 0x%X, const GLfixed *params = 0x%016" PRIxPTR ")",
          light, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        LightParameter pnamePacked = FromGLenum<LightParameter>(pname);
        if (context->skipValidation() || ValidateLightxv(context, light, pnamePacked, params))
        {
            context->lightxv(light, pnamePacked, params);
        }
    }
}

void GL_APIENTRY LineWidthx(GLfixed width)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfixed width = 0x%X)", width);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateLineWidthx(context, width))
        {
            context->lineWidthx(width);
        }
    }
}

void GL_APIENTRY LoadIdentity()
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateLoadIdentity(context))
        {
            context->loadIdentity();
        }
    }
}

void GL_APIENTRY LoadMatrixf(const GLfloat *m)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(const GLfloat *m = 0x%016" PRIxPTR ")", (uintptr_t)m);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateLoadMatrixf(context, m))
        {
            context->loadMatrixf(m);
        }
    }
}

void GL_APIENTRY LoadMatrixx(const GLfixed *m)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(const GLfixed *m = 0x%016" PRIxPTR ")", (uintptr_t)m);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateLoadMatrixx(context, m))
        {
            context->loadMatrixx(m);
        }
    }
}

void GL_APIENTRY LogicOp(GLenum opcode)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum opcode = 0x%X)", opcode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        LogicalOperation opcodePacked = FromGLenum<LogicalOperation>(opcode);
        if (context->skipValidation() || ValidateLogicOp(context, opcodePacked))
        {
            context->logicOp(opcodePacked);
        }
    }
}

void GL_APIENTRY Materialf(GLenum face, GLenum pname, GLfloat param)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, GLfloat param = %f)", face, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        MaterialParameter pnamePacked = FromGLenum<MaterialParameter>(pname);
        if (context->skipValidation() || ValidateMaterialf(context, face, pnamePacked, param))
        {
            context->materialf(face, pnamePacked, param);
        }
    }
}

void GL_APIENTRY Materialfv(GLenum face, GLenum pname, const GLfloat *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")",
          face, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        MaterialParameter pnamePacked = FromGLenum<MaterialParameter>(pname);
        if (context->skipValidation() || ValidateMaterialfv(context, face, pnamePacked, params))
        {
            context->materialfv(face, pnamePacked, params);
        }
    }
}

void GL_APIENTRY Materialx(GLenum face, GLenum pname, GLfixed param)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, GLfixed param = 0x%X)", face, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        MaterialParameter pnamePacked = FromGLenum<MaterialParameter>(pname);
        if (context->skipValidation() || ValidateMaterialx(context, face, pnamePacked, param))
        {
            context->materialx(face, pnamePacked, param);
        }
    }
}

void GL_APIENTRY Materialxv(GLenum face, GLenum pname, const GLfixed *param)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum face = 0x%X, GLenum pname = 0x%X, const GLfixed *param = 0x%016" PRIxPTR ")",
          face, pname, (uintptr_t)param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        MaterialParameter pnamePacked = FromGLenum<MaterialParameter>(pname);
        if (context->skipValidation() || ValidateMaterialxv(context, face, pnamePacked, param))
        {
            context->materialxv(face, pnamePacked, param);
        }
    }
}

void GL_APIENTRY MatrixMode(GLenum mode)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        MatrixType modePacked = FromGLenum<MatrixType>(mode);
        if (context->skipValidation() || ValidateMatrixMode(context, modePacked))
        {
            context->matrixMode(modePacked);
        }
    }
}

void GL_APIENTRY MultMatrixf(const GLfloat *m)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(const GLfloat *m = 0x%016" PRIxPTR ")", (uintptr_t)m);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateMultMatrixf(context, m))
        {
            context->multMatrixf(m);
        }
    }
}

void GL_APIENTRY MultMatrixx(const GLfixed *m)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(const GLfixed *m = 0x%016" PRIxPTR ")", (uintptr_t)m);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateMultMatrixx(context, m))
        {
            context->multMatrixx(m);
        }
    }
}

void GL_APIENTRY MultiTexCoord4f(GLenum target, GLfloat s, GLfloat t, GLfloat r, GLfloat q)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLfloat s = %f, GLfloat t = %f, GLfloat r = %f, GLfloat q = %f)",
          target, s, t, r, q);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateMultiTexCoord4f(context, target, s, t, r, q))
        {
            context->multiTexCoord4f(target, s, t, r, q);
        }
    }
}

void GL_APIENTRY MultiTexCoord4x(GLenum texture, GLfixed s, GLfixed t, GLfixed r, GLfixed q)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLenum texture = 0x%X, GLfixed s = 0x%X, GLfixed t = 0x%X, GLfixed r = 0x%X, GLfixed q = "
        "0x%X)",
        texture, s, t, r, q);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateMultiTexCoord4x(context, texture, s, t, r, q))
        {
            context->multiTexCoord4x(texture, s, t, r, q);
        }
    }
}

void GL_APIENTRY Normal3f(GLfloat nx, GLfloat ny, GLfloat nz)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfloat nx = %f, GLfloat ny = %f, GLfloat nz = %f)", nx, ny, nz);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateNormal3f(context, nx, ny, nz))
        {
            context->normal3f(nx, ny, nz);
        }
    }
}

void GL_APIENTRY Normal3x(GLfixed nx, GLfixed ny, GLfixed nz)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfixed nx = 0x%X, GLfixed ny = 0x%X, GLfixed nz = 0x%X)", nx, ny, nz);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateNormal3x(context, nx, ny, nz))
        {
            context->normal3x(nx, ny, nz);
        }
    }
}

void GL_APIENTRY NormalPointer(GLenum type, GLsizei stride, const void *pointer)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum type = 0x%X, GLsizei stride = %d, const void *pointer = 0x%016" PRIxPTR ")",
          type, stride, (uintptr_t)pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        VertexAttribType typePacked = FromGLenum<VertexAttribType>(type);
        if (context->skipValidation() ||
            ValidateNormalPointer(context, typePacked, stride, pointer))
        {
            context->normalPointer(typePacked, stride, pointer);
        }
    }
}

void GL_APIENTRY Orthof(GLfloat l, GLfloat r, GLfloat b, GLfloat t, GLfloat n, GLfloat f)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLfloat l = %f, GLfloat r = %f, GLfloat b = %f, GLfloat t = %f, GLfloat n = %f, GLfloat "
        "f = %f)",
        l, r, b, t, n, f);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateOrthof(context, l, r, b, t, n, f))
        {
            context->orthof(l, r, b, t, n, f);
        }
    }
}

void GL_APIENTRY Orthox(GLfixed l, GLfixed r, GLfixed b, GLfixed t, GLfixed n, GLfixed f)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLfixed l = 0x%X, GLfixed r = 0x%X, GLfixed b = 0x%X, GLfixed t = 0x%X, GLfixed n = "
        "0x%X, GLfixed f = 0x%X)",
        l, r, b, t, n, f);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateOrthox(context, l, r, b, t, n, f))
        {
            context->orthox(l, r, b, t, n, f);
        }
    }
}

void GL_APIENTRY PointParameterf(GLenum pname, GLfloat param)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum pname = 0x%X, GLfloat param = %f)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        PointParameter pnamePacked = FromGLenum<PointParameter>(pname);
        if (context->skipValidation() || ValidatePointParameterf(context, pnamePacked, param))
        {
            context->pointParameterf(pnamePacked, param);
        }
    }
}

void GL_APIENTRY PointParameterfv(GLenum pname, const GLfloat *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")", pname,
          (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        PointParameter pnamePacked = FromGLenum<PointParameter>(pname);
        if (context->skipValidation() || ValidatePointParameterfv(context, pnamePacked, params))
        {
            context->pointParameterfv(pnamePacked, params);
        }
    }
}

void GL_APIENTRY PointParameterx(GLenum pname, GLfixed param)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum pname = 0x%X, GLfixed param = 0x%X)", pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        PointParameter pnamePacked = FromGLenum<PointParameter>(pname);
        if (context->skipValidation() || ValidatePointParameterx(context, pnamePacked, param))
        {
            context->pointParameterx(pnamePacked, param);
        }
    }
}

void GL_APIENTRY PointParameterxv(GLenum pname, const GLfixed *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum pname = 0x%X, const GLfixed *params = 0x%016" PRIxPTR ")", pname,
          (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        PointParameter pnamePacked = FromGLenum<PointParameter>(pname);
        if (context->skipValidation() || ValidatePointParameterxv(context, pnamePacked, params))
        {
            context->pointParameterxv(pnamePacked, params);
        }
    }
}

void GL_APIENTRY PointSize(GLfloat size)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfloat size = %f)", size);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidatePointSize(context, size))
        {
            context->pointSize(size);
        }
    }
}

void GL_APIENTRY PointSizex(GLfixed size)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfixed size = 0x%X)", size);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidatePointSizex(context, size))
        {
            context->pointSizex(size);
        }
    }
}

void GL_APIENTRY PolygonOffsetx(GLfixed factor, GLfixed units)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfixed factor = 0x%X, GLfixed units = 0x%X)", factor, units);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidatePolygonOffsetx(context, factor, units))
        {
            context->polygonOffsetx(factor, units);
        }
    }
}

void GL_APIENTRY PopMatrix()
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidatePopMatrix(context))
        {
            context->popMatrix();
        }
    }
}

void GL_APIENTRY PushMatrix()
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("()");

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidatePushMatrix(context))
        {
            context->pushMatrix();
        }
    }
}

void GL_APIENTRY Rotatef(GLfloat angle, GLfloat x, GLfloat y, GLfloat z)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfloat angle = %f, GLfloat x = %f, GLfloat y = %f, GLfloat z = %f)", angle, x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateRotatef(context, angle, x, y, z))
        {
            context->rotatef(angle, x, y, z);
        }
    }
}

void GL_APIENTRY Rotatex(GLfixed angle, GLfixed x, GLfixed y, GLfixed z)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfixed angle = 0x%X, GLfixed x = 0x%X, GLfixed y = 0x%X, GLfixed z = 0x%X)", angle, x,
          y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateRotatex(context, angle, x, y, z))
        {
            context->rotatex(angle, x, y, z);
        }
    }
}

void GL_APIENTRY SampleCoveragex(GLclampx value, GLboolean invert)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLclampx value = 0x%X, GLboolean invert = %u)", value, invert);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateSampleCoveragex(context, value, invert))
        {
            context->sampleCoveragex(value, invert);
        }
    }
}

void GL_APIENTRY Scalef(GLfloat x, GLfloat y, GLfloat z)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfloat x = %f, GLfloat y = %f, GLfloat z = %f)", x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateScalef(context, x, y, z))
        {
            context->scalef(x, y, z);
        }
    }
}

void GL_APIENTRY Scalex(GLfixed x, GLfixed y, GLfixed z)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfixed x = 0x%X, GLfixed y = 0x%X, GLfixed z = 0x%X)", x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateScalex(context, x, y, z))
        {
            context->scalex(x, y, z);
        }
    }
}

void GL_APIENTRY ShadeModel(GLenum mode)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum mode = 0x%X)", mode);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        ShadingModel modePacked = FromGLenum<ShadingModel>(mode);
        if (context->skipValidation() || ValidateShadeModel(context, modePacked))
        {
            context->shadeModel(modePacked);
        }
    }
}

void GL_APIENTRY TexCoordPointer(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLint size = %d, GLenum type = 0x%X, GLsizei stride = %d, const void *pointer = "
        "0x%016" PRIxPTR ")",
        size, type, stride, (uintptr_t)pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        VertexAttribType typePacked = FromGLenum<VertexAttribType>(type);
        if (context->skipValidation() ||
            ValidateTexCoordPointer(context, size, typePacked, stride, pointer))
        {
            context->texCoordPointer(size, typePacked, stride, pointer);
        }
    }
}

void GL_APIENTRY TexEnvf(GLenum target, GLenum pname, GLfloat param)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfloat param = %f)", target, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        if (context->skipValidation() || ValidateTexEnvf(context, targetPacked, pnamePacked, param))
        {
            context->texEnvf(targetPacked, pnamePacked, param);
        }
    }
}

void GL_APIENTRY TexEnvfv(GLenum target, GLenum pname, const GLfloat *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLfloat *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        if (context->skipValidation() ||
            ValidateTexEnvfv(context, targetPacked, pnamePacked, params))
        {
            context->texEnvfv(targetPacked, pnamePacked, params);
        }
    }
}

void GL_APIENTRY TexEnvi(GLenum target, GLenum pname, GLint param)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLint param = %d)", target, pname, param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        if (context->skipValidation() || ValidateTexEnvi(context, targetPacked, pnamePacked, param))
        {
            context->texEnvi(targetPacked, pnamePacked, param);
        }
    }
}

void GL_APIENTRY TexEnviv(GLenum target, GLenum pname, const GLint *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLint *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        if (context->skipValidation() ||
            ValidateTexEnviv(context, targetPacked, pnamePacked, params))
        {
            context->texEnviv(targetPacked, pnamePacked, params);
        }
    }
}

void GL_APIENTRY TexEnvx(GLenum target, GLenum pname, GLfixed param)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfixed param = 0x%X)", target, pname,
          param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        if (context->skipValidation() || ValidateTexEnvx(context, targetPacked, pnamePacked, param))
        {
            context->texEnvx(targetPacked, pnamePacked, param);
        }
    }
}

void GL_APIENTRY TexEnvxv(GLenum target, GLenum pname, const GLfixed *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLfixed *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureEnvTarget targetPacked   = FromGLenum<TextureEnvTarget>(target);
        TextureEnvParameter pnamePacked = FromGLenum<TextureEnvParameter>(pname);
        if (context->skipValidation() ||
            ValidateTexEnvxv(context, targetPacked, pnamePacked, params))
        {
            context->texEnvxv(targetPacked, pnamePacked, params);
        }
    }
}

void GL_APIENTRY TexParameterx(GLenum target, GLenum pname, GLfixed param)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, GLfixed param = 0x%X)", target, pname,
          param);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        if (context->skipValidation() || ValidateTexParameterx(context, targetPacked, pname, param))
        {
            context->texParameterx(targetPacked, pname, param);
        }
    }
}

void GL_APIENTRY TexParameterxv(GLenum target, GLenum pname, const GLfixed *params)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLenum target = 0x%X, GLenum pname = 0x%X, const GLfixed *params = 0x%016" PRIxPTR ")",
          target, pname, (uintptr_t)params);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        TextureType targetPacked = FromGLenum<TextureType>(target);
        if (context->skipValidation() ||
            ValidateTexParameterxv(context, targetPacked, pname, params))
        {
            context->texParameterxv(targetPacked, pname, params);
        }
    }
}

void GL_APIENTRY Translatef(GLfloat x, GLfloat y, GLfloat z)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfloat x = %f, GLfloat y = %f, GLfloat z = %f)", x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateTranslatef(context, x, y, z))
        {
            context->translatef(x, y, z);
        }
    }
}

void GL_APIENTRY Translatex(GLfixed x, GLfixed y, GLfixed z)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT("(GLfixed x = 0x%X, GLfixed y = 0x%X, GLfixed z = 0x%X)", x, y, z);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        if (context->skipValidation() || ValidateTranslatex(context, x, y, z))
        {
            context->translatex(x, y, z);
        }
    }
}

void GL_APIENTRY VertexPointer(GLint size, GLenum type, GLsizei stride, const void *pointer)
{
    ANGLE_SCOPED_GLOBAL_LOCK();
    EVENT(
        "(GLint size = %d, GLenum type = 0x%X, GLsizei stride = %d, const void *pointer = "
        "0x%016" PRIxPTR ")",
        size, type, stride, (uintptr_t)pointer);

    Context *context = GetValidGlobalContext();
    if (context)
    {
        VertexAttribType typePacked = FromGLenum<VertexAttribType>(type);
        if (context->skipValidation() ||
            ValidateVertexPointer(context, size, typePacked, stride, pointer))
        {
            context->vertexPointer(size, typePacked, stride, pointer);
        }
    }
}
}  // namespace gl
