/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.xml.css;

import java.util.ArrayList;
import java.util.List;
import net.n3.nanoxml.IXMLElement;
import org.jhotdraw.util.ReversedList;
import org.jhotdraw.xml.css.CSSRule;
import org.w3c.dom.Element;

public class StyleManager {
    private List<CSSRule> rules = new ArrayList<CSSRule>();

    public void add(CSSRule cSSRule) {
        this.rules.add(cSSRule);
    }

    public void applyStylesTo(Element element) {
        for (CSSRule cSSRule : this.rules) {
            if (!cSSRule.matches(element)) continue;
            cSSRule.apply(element);
        }
    }

    public void applyStylesTo(IXMLElement iXMLElement) {
        for (CSSRule cSSRule : new ReversedList<CSSRule>(this.rules)) {
            if (!cSSRule.matches(iXMLElement)) continue;
            cSSRule.apply(iXMLElement);
        }
    }

    public void clear() {
        this.rules.clear();
    }
}

