untrusted comment: signature from openbsd 6.3 base secret key
RWRxzbLwAd76ZQyTAjOBEVpirzss+i2A+zKgFKF3VLaLHcdYetymn4IzhHODWqBfOB7UyaEpKw/FbWWDNpJj4PQzauLbspBgpwU=

OpenBSD 6.3 errata 007, May 8, 2018:

Incorrect checks in libcrypto can prevent Diffie-Hellman Exchange operations
from working.

Apply by doing:
    signify -Vep /etc/signify/openbsd-63-base.pub -x 007_libcrypto.patch.sig \
	-m - | (cd /usr/src && patch -p0)

And then rebuild and install libcrypto:
    cd /usr/src/lib/libcrypto
    make obj
    make
    make install

Index: lib/libcrypto/dh/dh_lib.c
===================================================================
RCS file: /cvs/src/lib/libcrypto/dh/dh_lib.c,v
retrieving revision 1.30
retrieving revision 1.30.2.1
diff -u -p -r1.30 -r1.30.2.1
--- lib/libcrypto/dh/dh_lib.c	22 Feb 2018 16:41:04 -0000	1.30
+++ lib/libcrypto/dh/dh_lib.c	2 May 2018 16:57:35 -0000	1.30.2.1
@@ -298,10 +298,6 @@ DH_get0_key(const DH *dh, const BIGNUM *
 int
 DH_set0_key(DH *dh, BIGNUM *pub_key, BIGNUM *priv_key)
 {
-	if ((dh->pub_key == NULL && pub_key == NULL) ||
-	    (dh->priv_key == NULL && priv_key == NULL))
-		return 0;
-
 	if (pub_key != NULL) {
 		BN_free(dh->pub_key);
 		dh->pub_key = pub_key;
