/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openide.explorer;

import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import org.openide.util.Exceptions;

public final class UIException {
    private UIException() {
    }

    public static void annotateUser(Throwable throwable, String string, String string2, Throwable throwable2, Date date) {
        AnnException annException = AnnException.findOrCreate(throwable, true);
        LogRecord logRecord = new LogRecord(OwnLevel.USER, string);
        if (throwable2 != null) {
            logRecord.setThrown(throwable2);
        }
        annException.addRecord(logRecord);
        if (string2 != null) {
            Exceptions.attachLocalizedMessage((Throwable)throwable, (String)string2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AnnException
    extends Exception
    implements Callable<LogRecord[]> {
        private List<LogRecord> records;

        @Override
        public String getMessage() {
            StringBuilder stringBuilder = new StringBuilder();
            String string = "";
            for (LogRecord logRecord : this.records) {
                if (logRecord.getMessage() == null) continue;
                stringBuilder.append(string);
                stringBuilder.append(logRecord.getMessage());
                string = "\n";
            }
            return stringBuilder.toString();
        }

        static AnnException findOrCreate(Throwable throwable, boolean bl) {
            if (throwable instanceof AnnException) {
                return (AnnException)throwable;
            }
            if (throwable.getCause() == null) {
                if (bl) {
                    throwable.initCause(new AnnException());
                }
                return (AnnException)throwable.getCause();
            }
            return AnnException.findOrCreate(throwable.getCause(), bl);
        }

        private AnnException() {
        }

        public synchronized void addRecord(LogRecord logRecord) {
            if (this.records == null) {
                this.records = new ArrayList<LogRecord>();
            }
            this.records.add(logRecord);
        }

        @Override
        public LogRecord[] call() {
            List<LogRecord> list = this.records;
            LogRecord[] logRecordArray = new LogRecord[]{};
            return list == null ? logRecordArray : list.toArray(logRecordArray);
        }

        @Override
        public void printStackTrace(PrintStream printStream) {
            super.printStackTrace(printStream);
            this.logRecords(printStream);
        }

        @Override
        public void printStackTrace(PrintWriter printWriter) {
            super.printStackTrace(printWriter);
            this.logRecords(printWriter);
        }

        @Override
        public void printStackTrace() {
            this.printStackTrace(System.err);
        }

        private void logRecords(Appendable appendable) {
            List<LogRecord> list = this.records;
            if (list == null) {
                return;
            }
            try {
                for (LogRecord logRecord : list) {
                    if (logRecord.getMessage() != null) {
                        appendable.append(logRecord.getMessage()).append('\n');
                    }
                    if (logRecord.getThrown() == null) continue;
                    StringWriter stringWriter = new StringWriter();
                    logRecord.getThrown().printStackTrace(new PrintWriter(stringWriter));
                    appendable.append(stringWriter.toString()).append('\n');
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
    }

    private static final class OwnLevel
    extends Level {
        public static final Level USER = new OwnLevel("USER", 1973);

        private OwnLevel(String string, int n) {
            super(string, n);
        }
    }
}

