/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo;

import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.fo.CharIterator;
import org.apache.fop.fo.FOEventHandler;
import org.apache.fop.fo.OneCharIterator;
import org.apache.fop.fo.PropertyList;
import org.apache.fop.fo.ValidationException;
import org.apache.fop.fo.extensions.ExtensionAttachment;
import org.apache.fop.fo.pagination.Root;
import org.apache.fop.util.ContentHandlerFactory;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;

public abstract class FONode
implements Cloneable {
    protected static final String FO_URI = "http://www.w3.org/1999/XSL/Format";
    protected FONode parent;
    protected Locator locator;
    protected static Log log = LogFactory.getLog((Class)(class$org$apache$fop$fo$FONode == null ? (class$org$apache$fop$fo$FONode = FONode.class$("org.apache.fop.fo.FONode")) : class$org$apache$fop$fo$FONode));
    static /* synthetic */ Class class$org$apache$fop$fo$FONode;

    protected FONode(FONode parent) {
        this.parent = parent;
    }

    public FONode clone(FONode cloneparent, boolean removeChildren) throws FOPException {
        FONode foNode = (FONode)this.clone();
        foNode.parent = cloneparent;
        return foNode;
    }

    protected Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public void setLocator(Locator locator) {
        if (locator != null) {
            this.locator = new LocatorImpl(locator);
        }
    }

    public Locator getLocator() {
        return this.locator;
    }

    public FOEventHandler getFOEventHandler() {
        return this.parent.getFOEventHandler();
    }

    protected boolean inMarker() {
        return this.getFOEventHandler().inMarker();
    }

    public FOUserAgent getUserAgent() {
        return this.getFOEventHandler().getUserAgent();
    }

    public Log getLogger() {
        return log;
    }

    public void processNode(String elementName, Locator locator, Attributes attlist, PropertyList pList) throws FOPException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("Unhandled element: " + elementName + (locator != null ? " at " + FONode.getLocatorString(locator) : "")));
        }
    }

    protected PropertyList createPropertyList(PropertyList pList, FOEventHandler foEventHandler) throws FOPException {
        return null;
    }

    protected void validateChildNode(Locator loc, String namespaceURI, String localName) throws ValidationException {
    }

    protected void addCharacters(char[] data, int start, int end, PropertyList pList, Locator locator) throws FOPException {
    }

    protected void startOfNode() throws FOPException {
    }

    protected void endOfNode() throws FOPException {
    }

    protected void addChildNode(FONode child) throws FOPException {
    }

    public void removeChild(FONode child) {
    }

    public FONode getParent() {
        return this.parent;
    }

    public ListIterator getChildNodes() {
        return null;
    }

    public ListIterator getChildNodes(FONode childNode) {
        return null;
    }

    public CharIterator charIterator() {
        return new OneCharIterator('\u0000');
    }

    public static String getNodeString(String namespaceURI, String localName) {
        if (namespaceURI.equals(FO_URI)) {
            return "fo:" + localName;
        }
        if (namespaceURI.equals("http://xmlgraphics.apache.org/fop/extensions")) {
            return "fox:" + localName;
        }
        if (namespaceURI.equals("http://www.w3.org/2000/svg")) {
            return "svg:" + localName;
        }
        return "(Namespace URI: \"" + namespaceURI + "\", " + "Local Name: \"" + localName + "\")";
    }

    protected void attributeError(String problem) throws ValidationException {
        throw new ValidationException(FONode.errorText(this.locator) + this.getName() + ", " + problem, this.locator);
    }

    protected void attributeWarning(String problem) {
        log.warn((Object)(FONode.warningText(this.locator) + this.getName() + ", " + problem));
    }

    protected void tooManyNodesError(Locator loc, String nsURI, String lName) throws ValidationException {
        throw new ValidationException(FONode.errorText(loc) + "For " + this.getName() + ", only one " + FONode.getNodeString(nsURI, lName) + " may be declared.", loc);
    }

    protected void tooManyNodesError(Locator loc, String offendingNode) throws ValidationException {
        throw new ValidationException(FONode.errorText(loc) + "For " + this.getName() + ", only one " + offendingNode + " may be declared.", loc);
    }

    protected void nodesOutOfOrderError(Locator loc, String tooLateNode, String tooEarlyNode) throws ValidationException {
        throw new ValidationException(FONode.errorText(loc) + "For " + this.getName() + ", " + tooLateNode + " must be declared before " + tooEarlyNode + ".", loc);
    }

    protected void invalidChildError(Locator loc, String nsURI, String lName) throws ValidationException {
        this.invalidChildError(loc, nsURI, lName, null);
    }

    protected void invalidChildError(Locator loc, String nsURI, String lName, String ruleViolated) throws ValidationException {
        throw new ValidationException(FONode.errorText(loc) + FONode.getNodeString(nsURI, lName) + " is not a valid child element of " + this.getName() + (ruleViolated != null ? ": " + ruleViolated : "."), loc);
    }

    protected void missingChildElementError(String contentModel) throws ValidationException {
        throw new ValidationException(FONode.errorText(this.locator) + this.getName() + " is missing child elements. \nRequired Content Model: " + contentModel, this.locator);
    }

    protected void missingPropertyError(String propertyName) throws ValidationException {
        throw new ValidationException(FONode.errorText(this.locator) + this.getName() + " is missing required \"" + propertyName + "\" property.", this.locator);
    }

    protected static String errorText(Locator loc) {
        return "Error(" + FONode.getLocatorString(loc) + "): ";
    }

    protected static String warningText(Locator loc) {
        return "Warning(" + FONode.getLocatorString(loc) + "): ";
    }

    public static String getLocatorString(Locator loc) {
        if (loc == null) {
            return "Unknown location";
        }
        return loc.getLineNumber() + "/" + loc.getColumnNumber();
    }

    public static String decorateWithContextInfo(String text, FONode node) {
        if (node != null) {
            StringBuffer sb = new StringBuffer(text);
            sb.append(" (").append(node.getContextInfo()).append(")");
            return sb.toString();
        }
        return text;
    }

    public String getContextInfo() {
        StringBuffer sb = new StringBuffer();
        if (this.getLocalName() != null) {
            sb.append(this.getName());
            sb.append(", ");
        }
        if (this.locator != null) {
            sb.append("location: ");
            sb.append(FONode.getLocatorString(this.locator));
        } else {
            String s = this.gatherContextInfo();
            if (s != null) {
                sb.append("\"");
                sb.append(s);
                sb.append("\"");
            } else {
                sb.append("no context info available");
            }
        }
        if (sb.length() > 80) {
            sb.setLength(80);
        }
        return sb.toString();
    }

    protected String gatherContextInfo() {
        return null;
    }

    public Root getRoot() {
        return this.parent.getRoot();
    }

    public String getName() {
        return this.getName(this.getNormalNamespacePrefix());
    }

    public String getName(String prefix) {
        if (prefix != null) {
            StringBuffer sb = new StringBuffer();
            sb.append(prefix).append(':').append(this.getLocalName());
            return sb.toString();
        }
        return this.getLocalName();
    }

    public abstract String getLocalName();

    public abstract String getNormalNamespacePrefix();

    public String getNamespaceURI() {
        return null;
    }

    public int getNameId() {
        return 0;
    }

    public ExtensionAttachment getExtensionAttachment() {
        return null;
    }

    public ContentHandlerFactory getContentHandlerFactory() {
        return null;
    }

    protected boolean canHaveMarkers() {
        int foId = this.getNameId();
        switch (foId) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 11: 
            case 15: 
            case 16: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 52: 
            case 53: 
            case 56: {
                return true;
            }
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

