/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedSet;
import net.i2p.util.ArraySet;

public class UnmodifiableSortedSet<E>
extends ArraySet<E>
implements SortedSet<E> {
    private final Comparator<? super E> comp;
    private final boolean initialized;

    public UnmodifiableSortedSet(SortedSet<? extends E> c) {
        this(c, (Comparator<? extends E>)null);
    }

    public UnmodifiableSortedSet(SortedSet<? extends E> c, Comparator<? super E> comparator) {
        super(c, c.size());
        this.comp = comparator;
        this.initialized = true;
    }

    public UnmodifiableSortedSet(Set<? extends E> c) {
        this(c, (Comparator<? extends E>)null);
    }

    public UnmodifiableSortedSet(Set<? extends E> c, Comparator<? super E> comparator) {
        super(c, c.size());
        this.comp = comparator;
        int sz = this.size();
        if (sz > 1) {
            Arrays.sort(this._entries, 0, sz, this.comp);
        }
        this.initialized = true;
    }

    public UnmodifiableSortedSet(Collection<? extends E> c) {
        this(c, null);
    }

    public UnmodifiableSortedSet(Collection<? extends E> c, Comparator<? super E> comparator) {
        super(c, c.size());
        this.comp = comparator;
        int sz = this.size();
        if (sz > 1) {
            Arrays.sort(this._entries, 0, sz, this.comp);
        }
        this.initialized = true;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comp;
    }

    @Override
    public E first() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return (E)this._entries[0];
    }

    @Override
    public E last() {
        int sz = this.size();
        if (sz <= 0) {
            throw new NoSuchElementException();
        }
        return (E)this._entries[sz - 1];
    }

    @Override
    public SortedSet<E> headSet(E toElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<E> subSet(E fromElement, E toElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SortedSet<E> tailSet(E fromElement) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(E o) {
        if (this.initialized) {
            throw new UnsupportedOperationException();
        }
        return super.add(o);
    }

    @Override
    public void addUnique(E o) {
        if (this.initialized) {
            throw new UnsupportedOperationException();
        }
        super.addUnique(o);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected int indexOf(Object o) {
        int rv;
        if (!this.initialized) {
            return super.indexOf(o);
        }
        if (o != null && (rv = Arrays.binarySearch(this._entries, 0, this.size(), o, this.comp)) >= 0) {
            return rv;
        }
        return -1;
    }
}

