/* Generated by wayland-scanner 1.23.1 */

#ifndef XDG_SHELL_UNSTABLE_V5_ENUM_PROTOCOL_H
#define XDG_SHELL_UNSTABLE_V5_ENUM_PROTOCOL_H

#ifdef  __cplusplus
extern "C" {
#endif

#ifndef XDG_SHELL_VERSION_ENUM
#define XDG_SHELL_VERSION_ENUM
/**
 * @ingroup iface_xdg_shell
 * latest protocol version
 *
 * The 'current' member of this enum gives the version of the
 * protocol.  Implementations can compare this to the version
 * they implement using static_assert to ensure the protocol and
 * implementation versions match.
 */
enum xdg_shell_version {
	/**
	 * Always the latest version
	 */
	XDG_SHELL_VERSION_CURRENT = 5,
};
#endif /* XDG_SHELL_VERSION_ENUM */

#ifndef XDG_SHELL_ERROR_ENUM
#define XDG_SHELL_ERROR_ENUM
enum xdg_shell_error {
	/**
	 * given wl_surface has another role
	 */
	XDG_SHELL_ERROR_ROLE = 0,
	/**
	 * xdg_shell was destroyed before children
	 */
	XDG_SHELL_ERROR_DEFUNCT_SURFACES = 1,
	/**
	 * the client tried to map or destroy a non-topmost popup
	 */
	XDG_SHELL_ERROR_NOT_THE_TOPMOST_POPUP = 2,
	/**
	 * the client specified an invalid popup parent surface
	 */
	XDG_SHELL_ERROR_INVALID_POPUP_PARENT = 3,
};
#endif /* XDG_SHELL_ERROR_ENUM */

#ifndef XDG_SURFACE_RESIZE_EDGE_ENUM
#define XDG_SURFACE_RESIZE_EDGE_ENUM
/**
 * @ingroup iface_xdg_surface
 * edge values for resizing
 *
 * These values are used to indicate which edge of a surface
 * is being dragged in a resize operation.
 */
enum xdg_surface_resize_edge {
	XDG_SURFACE_RESIZE_EDGE_NONE = 0,
	XDG_SURFACE_RESIZE_EDGE_TOP = 1,
	XDG_SURFACE_RESIZE_EDGE_BOTTOM = 2,
	XDG_SURFACE_RESIZE_EDGE_LEFT = 4,
	XDG_SURFACE_RESIZE_EDGE_TOP_LEFT = 5,
	XDG_SURFACE_RESIZE_EDGE_BOTTOM_LEFT = 6,
	XDG_SURFACE_RESIZE_EDGE_RIGHT = 8,
	XDG_SURFACE_RESIZE_EDGE_TOP_RIGHT = 9,
	XDG_SURFACE_RESIZE_EDGE_BOTTOM_RIGHT = 10,
};
#endif /* XDG_SURFACE_RESIZE_EDGE_ENUM */

#ifndef XDG_SURFACE_STATE_ENUM
#define XDG_SURFACE_STATE_ENUM
/**
 * @ingroup iface_xdg_surface
 * types of state on the surface
 *
 * The different state values used on the surface. This is designed for
 * state values like maximized, fullscreen. It is paired with the
 * configure event to ensure that both the client and the compositor
 * setting the state can be synchronized.
 *
 * States set in this way are double-buffered, see wl_surface.commit.
 *
 * Desktop environments may extend this enum by taking up a range of
 * values and documenting the range they chose in this description.
 * They are not required to document the values for the range that they
 * chose. Ideally, any good extensions from a desktop environment should
 * make its way into standardization into this enum.
 *
 * The current reserved ranges are:
 *
 * 0x0000 - 0x0FFF: xdg-shell core values, documented below.
 * 0x1000 - 0x1FFF: GNOME
 * 0x2000 - 0x2FFF: EFL
 */
enum xdg_surface_state {
	/**
	 * the surface is maximized
	 * the surface is maximized
	 *
	 * The surface is maximized. The window geometry specified in the
	 * configure event must be obeyed by the client.
	 */
	XDG_SURFACE_STATE_MAXIMIZED = 1,
	/**
	 * the surface is fullscreen
	 * the surface is fullscreen
	 *
	 * The surface is fullscreen. The window geometry specified in
	 * the configure event must be obeyed by the client.
	 */
	XDG_SURFACE_STATE_FULLSCREEN = 2,
	/**
	 * the surface is being resized
	 * the surface is being resized
	 *
	 * The surface is being resized. The window geometry specified in
	 * the configure event is a maximum; the client cannot resize
	 * beyond it. Clients that have aspect ratio or cell sizing
	 * configuration can use a smaller size, however.
	 */
	XDG_SURFACE_STATE_RESIZING = 3,
	/**
	 * the surface is now activated
	 * the surface is now activated
	 *
	 * Client window decorations should be painted as if the window
	 * is active. Do not assume this means that the window actually has
	 * keyboard or pointer focus.
	 */
	XDG_SURFACE_STATE_ACTIVATED = 4,
};
#endif /* XDG_SURFACE_STATE_ENUM */

#ifdef  __cplusplus
}
#endif

#endif
