<TeXmacs|1.99.2>

<style|<tuple|tmdoc|maxima|scilab|english>>

<\body>
  <\tmdoc-title>
    Example <name|Scilab> session
  </tmdoc-title>

  <subsection|Mathematical presentation of <name|Scilab> data types>

  Here follow some sample sessions started using
  <menu|Insert|Session|Scilab>.

  <\session|scilab|default>
    <\output>
      \ \ \ \ \ \ \ \ ___________________________________________
      \ \ \ \ \ \ \ 

      \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ scilab-5.3.3

      \;

      \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ \ Consortium Scilab (DIGITEO)

      \ \ \ \ \ \ \ \ \ \ \ \ \ \ Copyright (c) 1989-2011 (INRIA)

      \ \ \ \ \ \ \ \ \ \ \ \ \ \ Copyright (c) 1989-2007 (ENPC)

      \ \ \ \ \ \ \ \ ___________________________________________
      \ \ \ \ \ \ \ 

      \;
    </output>

    <\unfolded-io>
      --\<gtr\>
    <|unfolded-io>
      <\code>
        A= [0,1;0,0], B= [1;1]; C= [1,1];
      </code>
    <|unfolded-io>
      \ A \ =

      \ 

      <with|mode|math|<matrix|<tformat|<table|<row|<cell|0>|<cell|1>>|<row|<cell|0>|<cell|0>>>>>>

      \ 
    </unfolded-io>

    <\unfolded-io>
      --\<gtr\>
    <|unfolded-io>
      <\code>
        S1= syslin('c',A,B,C)
      </code>
    <|unfolded-io>
      \ S1 \ =

      \ 

      <with|mode|math|<choice|<tformat|<cwith|1|-1|1|1|cell-halign|r>|<table|<row|<cell|<wide|X|\<dot\>>
      <around*|(|t|)>>|<cell|=>|<cell|<matrix|<tformat|<table|<row|<cell|0>|<cell|1>>|<row|<cell|0>|<cell|0>>>>>*X
      <around*|(|t|)>+<matrix|<tformat|<table|<row|<cell|1>>|<row|<cell|1>>>>>*U
      <around*|(|t|)>>>|<row|<cell|Y <around*|(|t|)>>|<cell|=>|<cell|<matrix|<tformat|<table|<row|<cell|1>|<cell|1>>>>>*X
      <around*|(|t|)>>>>>>>

      \ 
    </unfolded-io>

    <\unfolded-io>
      --\<gtr\>
    <|unfolded-io>
      demo_run (texmacs_path + '/plugins/scilab/bin/scilab-demo.sce')
    <|unfolded-io>
      \;
    </unfolded-io>
  </session>

  <strong|<with|color|red|Note.>> Most of the <name|Scilab> data types are
  handled. However, there are issues printing some of them because of the
  simplicity in the <name|Scilab> read-eval-print loop (see e.g. the case of
  <scilab|mlist>: it is currently impossible to know the name of the
  variable). Also, some types cannot be printed since the printing method
  cannot be overloaded in <name|Scilab> for this type (see e.g. the case of
  <scilab|sparse matrix>; Sparse matrices can nevertheless be printed, using
  <scilab|tmout>).

  <strong|<with|color|red|Note.>> Again due to the <name|Scilab>
  read-eval-print loop, multiline commands may fail (at least,
  <scilab|function> declarations and entries with comments or continuation
  marks (<scilab|..>)).

  <strong|<with|color|red|Note.>> There are some performance issues when
  working with large data sets. The <scilab|tmstree()> function could be
  improved i) by removing local function definitions; ii) by limiting
  repeated calls to small functions (avoiding code factorization); and iii)
  via a different handling of matrices.

  <subsection|Syntax highlighting>

  Here follows a sample block of code, which was started using
  <menu|Insert|Program|Block of code|Scilab>. Inserting <em|inline code> is
  also possible, e.g. to write ``<scilab|f(x,y+1)>''.

  <\scilab-code>
    g= 9.81 // the gravity

    \;

    function y= myfunction(x)

    \ \ // myfunction computes y= x^2+1

    \ \ // x should be a vector or matrix

    \ \ y= x^2+1

    endfunction
  </scilab-code>

  <subsection|Plot insertion>

  The function <scilab|plotout()> allows you to insert the current figure
  inside the <TeXmacs> session. It is inserted as an image whose size you can
  edit as any other image.

  <\session|scilab|default>
    <\unfolded-io>
      --\<gtr\>
    <|unfolded-io>
      x= -6.28:0.1:6.28; y= sin(x); plot (x, y);

      // Note: leave the plot window open
    <|unfolded-io>
      \ 
    </unfolded-io>

    <\unfolded-io>
      --\<gtr\>
    <|unfolded-io>
      plotout()
    <|unfolded-io>
      <image|<tuple|<#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>|ps>|0.7par|||>
    </unfolded-io>

    <\input>
      --\<gtr\>
    <|input>
      \;
    </input>
  </session>

  <subsection|Menu populating features>

  The <name|Scilab> menu has an entry <menu|Insert> which can be
  personalized. As an example, the session

  <\session|scilab|default>
    <\unfolded-io>
      --\<gtr\>
    <|unfolded-io>
      cf= ["abort", "break", "case", "continue", "do", "for", "if", "pause",
      "resume", "return", "select", "then", "while"];
    <|unfolded-io>
      \ 
    </unfolded-io>

    <\folded-io>
      --\<gtr\>
    <|folded-io>
      add_to_insert_menu ("Control flow", cf);
    <|folded-io>
      \ 
    </folded-io>
  </session>

  adds the entry <menu|Scilab|Insert|Control flow> to the <name|Scilab> menu.
  It can be removed using

  <\session|scilab|default>
    <\folded-io>
      --\<gtr\>
    <|folded-io>
      rm_from_insert_menu ("Control flow");
    <|folded-io>
      \ 
    </folded-io>
  </session>

  <subsection|Completion>

  <name|Scilab> object names can be completed by pressing the <key|tab> key.

  <subsection|Verbatim import>

  <TeXmacs> allows you to edit a <name|Scilab> source in verbatim mode. See
  e.g. <hlink|<verbatim|scilab-demo.sce>|../bin/scilab-demo.sce>.

  <subsection|Launching demos>

  The <name|Scilab> menu lists the available <name|Scilab> demos. They can be
  launched, via <menu|Scilab|Launch demo>.

  <subsection|Help browsing>

  To be done.

  <tmdoc-copyright|2013|Franois Poulain, Joris van der Hoeven. Examples
  inspired from Scilab documentation.>

  <tmdoc-license|Permission is granted to copy, distribute and/or modify this
  document under the terms of the GNU Free Documentation License, Version 1.1
  or any later version published by the Free Software Foundation; with no
  Invariant Sections, with no Front-Cover Texts, and with no Back-Cover
  Texts. A copy of the license is included in the section entitled "GNU Free
  Documentation License".>
</body>

<initial|<\collection>
</collection>>