use strict;
package Mozilla::CA;

our $VERSION = "20140328";

sub SSL_ca_file {
    return "/etc/ssl/cert.pem";
}

1;

__END__

=head1 NAME

Mozilla::CA - fake version

=head1 SYNOPSIS

    use Mozilla::CA;
    printf "%s\n", Mozilla::CA::SSL_ca_file();

=head1 DESCRIPTION

CPAN's Mozilla::CA module provides a PEM conversion of Mozilla's certificate
bundle, and a library function which simply returns the path to that file.

This fake Mozilla::CA module is written for OpenBSD packages and follows the
same API, however it simply points to the OS's primary certificate bundle
in /etc/ssl/cert.pem.

=over

=item SSL_ca_file()

Returns "/etc/ssl/cert.pem".

=back

=head1 SEE ALSO

cpan Mozilla::CA

=head1 LICENSE

Public domain
