/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.event;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventListenerMap {
    private final Map<Class<? extends EventListener>, List<? extends EventListener>> listenerList = new HashMap<Class<? extends EventListener>, List<? extends EventListener>>();

    public List<EventListener> getListeners() {
        ArrayList<EventListener> listeners = new ArrayList<EventListener>();
        Set<Class<? extends EventListener>> keys = this.listenerList.keySet();
        for (Class<? extends EventListener> key : keys) {
            listeners.addAll((Collection<EventListener>)this.listenerList.get(key));
        }
        return listeners;
    }

    public <T extends EventListener> List<T> getListeners(Class<T> clazz) {
        List<? extends EventListener> list = this.listenerList.get(clazz);
        if (list == null) {
            list = new ArrayList<EventListener>();
        }
        return list;
    }

    public int getListenerCount() {
        int count = 0;
        Set<Class<? extends EventListener>> keys = this.listenerList.keySet();
        for (Class<? extends EventListener> key : keys) {
            count += this.listenerList.get(key).size();
        }
        return count;
    }

    public <T extends EventListener> int getListenerCount(Class<T> clazz) {
        List<? extends EventListener> list = this.listenerList.get(clazz);
        if (list != null) {
            return list.size();
        }
        return 0;
    }

    public <T extends EventListener> void add(Class<T> clazz, T listener) {
        if (listener == null) {
            return;
        }
        List<? extends EventListener> list = this.listenerList.get(clazz);
        if (list == null) {
            list = new ArrayList<EventListener>();
            this.listenerList.put(clazz, list);
        }
        list.add(listener);
    }

    public <T extends EventListener> void remove(Class<T> clazz, T listener) {
        if (listener == null) {
            return;
        }
        List<? extends EventListener> list = this.listenerList.get(clazz);
        if (list != null) {
            list.remove(listener);
        }
    }
}

