/*
 * Decompiled with CFR 0.152.
 */
package net.fortuna.ical4j.model.component;

import java.io.IOException;
import java.net.URISyntaxException;
import java.text.ParseException;
import java.util.Iterator;
import net.fortuna.ical4j.model.Component;
import net.fortuna.ical4j.model.ComponentList;
import net.fortuna.ical4j.model.Date;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Dur;
import net.fortuna.ical4j.model.Parameter;
import net.fortuna.ical4j.model.Period;
import net.fortuna.ical4j.model.PeriodList;
import net.fortuna.ical4j.model.PropertyList;
import net.fortuna.ical4j.model.ValidationException;
import net.fortuna.ical4j.model.component.CalendarComponent;
import net.fortuna.ical4j.model.component.VAlarm;
import net.fortuna.ical4j.model.parameter.Value;
import net.fortuna.ical4j.model.property.Clazz;
import net.fortuna.ical4j.model.property.Created;
import net.fortuna.ical4j.model.property.Description;
import net.fortuna.ical4j.model.property.DtEnd;
import net.fortuna.ical4j.model.property.DtStamp;
import net.fortuna.ical4j.model.property.DtStart;
import net.fortuna.ical4j.model.property.Duration;
import net.fortuna.ical4j.model.property.Geo;
import net.fortuna.ical4j.model.property.LastModified;
import net.fortuna.ical4j.model.property.Location;
import net.fortuna.ical4j.model.property.Organizer;
import net.fortuna.ical4j.model.property.Priority;
import net.fortuna.ical4j.model.property.RecurrenceId;
import net.fortuna.ical4j.model.property.Sequence;
import net.fortuna.ical4j.model.property.Status;
import net.fortuna.ical4j.model.property.Summary;
import net.fortuna.ical4j.model.property.Transp;
import net.fortuna.ical4j.model.property.Uid;
import net.fortuna.ical4j.model.property.Url;
import net.fortuna.ical4j.util.CompatibilityHints;
import net.fortuna.ical4j.util.ComponentValidator;
import net.fortuna.ical4j.util.Dates;
import net.fortuna.ical4j.util.PropertyValidator;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.HashCodeBuilder;

public class VEvent
extends CalendarComponent {
    private static final long serialVersionUID = 2547948989200697335L;
    private ComponentList alarms;

    public VEvent() {
        super("VEVENT");
        this.alarms = new ComponentList();
        this.getProperties().add(new DtStamp());
    }

    public VEvent(PropertyList properties) {
        super("VEVENT", properties);
        this.alarms = new ComponentList();
    }

    public VEvent(PropertyList properties, ComponentList alarms) {
        super("VEVENT", properties);
        this.alarms = alarms;
    }

    public VEvent(Date start, String summary) {
        this();
        this.getProperties().add(new DtStart(start));
        this.getProperties().add(new Summary(summary));
    }

    public VEvent(Date start, Date end, String summary) {
        this();
        this.getProperties().add(new DtStart(start));
        this.getProperties().add(new DtEnd(end));
        this.getProperties().add(new Summary(summary));
    }

    public VEvent(Date start, Dur duration, String summary) {
        this();
        this.getProperties().add(new DtStart(start));
        this.getProperties().add(new Duration(duration));
        this.getProperties().add(new Summary(summary));
    }

    public final ComponentList getAlarms() {
        return this.alarms;
    }

    public final String toString() {
        StringBuffer b = new StringBuffer();
        b.append("BEGIN");
        b.append(':');
        b.append(this.getName());
        b.append("\r\n");
        b.append(this.getProperties());
        b.append(this.getAlarms());
        b.append("END");
        b.append(':');
        b.append(this.getName());
        b.append("\r\n");
        return b.toString();
    }

    public final void validate(boolean recurse) throws ValidationException {
        Iterator iterator = this.getAlarms().iterator();
        while (iterator.hasNext()) {
            Component component = (Component)iterator.next();
            if (!(component instanceof VAlarm)) {
                throw new ValidationException("Component [" + component.getName() + "] may not occur in VEVENT");
            }
            ((VAlarm)component).validate(recurse);
        }
        if (!CompatibilityHints.isHintEnabled("ical4j.validation.relaxed")) {
            PropertyValidator.getInstance().assertOne("UID", this.getProperties());
            PropertyValidator.getInstance().assertOne("DTSTAMP", this.getProperties());
        }
        PropertyValidator.getInstance().assertOneOrLess("CLASS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CREATED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("GEO", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LOCATION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("ORGANIZER", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("PRIORITY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTSTAMP", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SEQUENCE", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("STATUS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SUMMARY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("TRANSP", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("UID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("URL", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", this.getProperties());
        Status status = (Status)this.getProperty("STATUS");
        if (!(status == null || Status.VEVENT_TENTATIVE.equals(status) || Status.VEVENT_CONFIRMED.equals(status) || Status.VEVENT_CANCELLED.equals(status))) {
            throw new ValidationException("Status property [" + status.toString() + "] is not applicable for VEVENT");
        }
        try {
            PropertyValidator.getInstance().assertNone("DTEND", this.getProperties());
        }
        catch (ValidationException ve) {
            PropertyValidator.getInstance().assertNone("DURATION", this.getProperties());
        }
        if (this.getProperty("DTEND") != null) {
            DtStart start = (DtStart)this.getProperty("DTSTART");
            DtEnd end = (DtEnd)this.getProperty("DTEND");
            if (start != null) {
                Parameter startValue = start.getParameter("VALUE");
                Parameter endValue = end.getParameter("VALUE");
                boolean startEndValueMismatch = false;
                if (endValue != null) {
                    if (startValue != null && !endValue.equals(startValue)) {
                        startEndValueMismatch = true;
                    } else if (startValue == null && !Value.DATE_TIME.equals(endValue)) {
                        startEndValueMismatch = true;
                    }
                } else if (startValue != null && !Value.DATE_TIME.equals(startValue)) {
                    startEndValueMismatch = true;
                }
                if (startEndValueMismatch) {
                    throw new ValidationException("Property [DTEND] must have the same [VALUE] as [DTSTART]");
                }
            }
        }
        if (recurse) {
            this.validateProperties();
        }
    }

    public void validatePublish() throws ValidationException {
        PropertyValidator.getInstance().assertOne("DTSTAMP", this.getProperties());
        PropertyValidator.getInstance().assertOne("DTSTART", this.getProperties());
        if (!CompatibilityHints.isHintEnabled("ical4j.validation.relaxed")) {
            PropertyValidator.getInstance().assertOne("ORGANIZER", this.getProperties());
            PropertyValidator.getInstance().assertOne("SUMMARY", this.getProperties());
        }
        PropertyValidator.getInstance().assertOne("UID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SEQUENCE", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CATEGORIES", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CLASS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("COMMENT", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CREATED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTEND", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DURATION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("GEO", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LOCATION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("PRIORITY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RESOURCES", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("STATUS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("TRANSP", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("URL", this.getProperties());
        if (!CompatibilityHints.isHintEnabled("ical4j.validation.relaxed")) {
            PropertyValidator.getInstance().assertNone("ATTENDEE", this.getProperties());
        }
        PropertyValidator.getInstance().assertNone("REQUEST-STATUS", this.getProperties());
        Iterator i = this.getAlarms().iterator();
        while (i.hasNext()) {
            VAlarm alarm = (VAlarm)i.next();
            alarm.validatePublish();
        }
    }

    public void validateRequest() throws ValidationException {
        if (!CompatibilityHints.isHintEnabled("ical4j.validation.relaxed")) {
            PropertyValidator.getInstance().assertOneOrMore("ATTENDEE", this.getProperties());
        }
        PropertyValidator.getInstance().assertOne("DTSTAMP", this.getProperties());
        PropertyValidator.getInstance().assertOne("DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertOne("ORGANIZER", this.getProperties());
        PropertyValidator.getInstance().assertOne("SUMMARY", this.getProperties());
        PropertyValidator.getInstance().assertOne("UID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SEQUENCE", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CATEGORIES", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CLASS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("COMMENT", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CREATED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTEND", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DURATION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("GEO", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LOCATION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("PRIORITY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RESOURCES", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("STATUS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("TRANSP", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("URL", this.getProperties());
        Iterator i = this.getAlarms().iterator();
        while (i.hasNext()) {
            VAlarm alarm = (VAlarm)i.next();
            alarm.validateRequest();
        }
    }

    public void validateReply() throws ValidationException {
        PropertyValidator.getInstance().assertOne("ATTENDEE", this.getProperties());
        PropertyValidator.getInstance().assertOne("DTSTAMP", this.getProperties());
        PropertyValidator.getInstance().assertOne("ORGANIZER", this.getProperties());
        PropertyValidator.getInstance().assertOne("UID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SEQUENCE", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CATEGORIES", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CLASS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("COMMENT", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CREATED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTEND", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DURATION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("GEO", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LOCATION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("PRIORITY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RESOURCES", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("STATUS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SUMMARY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("TRANSP", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("URL", this.getProperties());
        ComponentValidator.assertNone("VALARM", this.getAlarms());
    }

    public void validateAdd() throws ValidationException {
        PropertyValidator.getInstance().assertOne("DTSTAMP", this.getProperties());
        PropertyValidator.getInstance().assertOne("DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertOne("ORGANIZER", this.getProperties());
        PropertyValidator.getInstance().assertOne("SEQUENCE", this.getProperties());
        PropertyValidator.getInstance().assertOne("SUMMARY", this.getProperties());
        PropertyValidator.getInstance().assertOne("UID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CATEGORIES", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CLASS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("COMMENT", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CREATED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTEND", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DURATION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("GEO", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LOCATION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("PRIORITY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RESOURCES", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("STATUS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("TRANSP", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("URL", this.getProperties());
        PropertyValidator.getInstance().assertNone("RECURRENCE-ID", this.getProperties());
        PropertyValidator.getInstance().assertNone("REQUEST-STATUS", this.getProperties());
        Iterator i = this.getAlarms().iterator();
        while (i.hasNext()) {
            VAlarm alarm = (VAlarm)i.next();
            alarm.validateAdd();
        }
    }

    public void validateCancel() throws ValidationException {
        PropertyValidator.getInstance().assertOne("DTSTAMP", this.getProperties());
        PropertyValidator.getInstance().assertOne("DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertOne("ORGANIZER", this.getProperties());
        PropertyValidator.getInstance().assertOne("SEQUENCE", this.getProperties());
        PropertyValidator.getInstance().assertOne("UID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("COMMENT", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CATEGORIES", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CLASS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CREATED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTEND", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DURATION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("GEO", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LOCATION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("PRIORITY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RESOURCES", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("STATUS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SUMMARY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("TRANSP", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("URL", this.getProperties());
        PropertyValidator.getInstance().assertNone("REQUEST-STATUS", this.getProperties());
        ComponentValidator.assertNone("VALARM", this.getAlarms());
    }

    public void validateRefresh() throws ValidationException {
        PropertyValidator.getInstance().assertOne("ATTENDEE", this.getProperties());
        PropertyValidator.getInstance().assertOne("DTSTAMP", this.getProperties());
        PropertyValidator.getInstance().assertOne("ORGANIZER", this.getProperties());
        PropertyValidator.getInstance().assertOne("UID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("COMMENT", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", this.getProperties());
        PropertyValidator.getInstance().assertNone("ATTACH", this.getProperties());
        PropertyValidator.getInstance().assertNone("CATEGORIES", this.getProperties());
        PropertyValidator.getInstance().assertNone("CLASS", this.getProperties());
        PropertyValidator.getInstance().assertNone("CONTACT", this.getProperties());
        PropertyValidator.getInstance().assertNone("CREATED", this.getProperties());
        PropertyValidator.getInstance().assertNone("DESCRIPTION", this.getProperties());
        PropertyValidator.getInstance().assertNone("DTEND", this.getProperties());
        PropertyValidator.getInstance().assertNone("DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertNone("DURATION", this.getProperties());
        PropertyValidator.getInstance().assertNone("EXDATE", this.getProperties());
        PropertyValidator.getInstance().assertNone("EXRULE", this.getProperties());
        PropertyValidator.getInstance().assertNone("GEO", this.getProperties());
        PropertyValidator.getInstance().assertNone("LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertNone("LOCATION", this.getProperties());
        PropertyValidator.getInstance().assertNone("PRIORITY", this.getProperties());
        PropertyValidator.getInstance().assertNone("RDATE", this.getProperties());
        PropertyValidator.getInstance().assertNone("RELATED-TO", this.getProperties());
        PropertyValidator.getInstance().assertNone("REQUEST-STATUS", this.getProperties());
        PropertyValidator.getInstance().assertNone("RESOURCES", this.getProperties());
        PropertyValidator.getInstance().assertNone("RRULE", this.getProperties());
        PropertyValidator.getInstance().assertNone("SEQUENCE", this.getProperties());
        PropertyValidator.getInstance().assertNone("STATUS", this.getProperties());
        PropertyValidator.getInstance().assertNone("SUMMARY", this.getProperties());
        PropertyValidator.getInstance().assertNone("TRANSP", this.getProperties());
        PropertyValidator.getInstance().assertNone("URL", this.getProperties());
        ComponentValidator.assertNone("VALARM", this.getAlarms());
    }

    public void validateCounter() throws ValidationException {
        PropertyValidator.getInstance().assertOne("DTSTAMP", this.getProperties());
        PropertyValidator.getInstance().assertOne("DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertOne("ORGANIZER", this.getProperties());
        PropertyValidator.getInstance().assertOne("SEQUENCE", this.getProperties());
        PropertyValidator.getInstance().assertOne("SUMMARY", this.getProperties());
        PropertyValidator.getInstance().assertOne("UID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CATEGORIES", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CLASS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("COMMENT", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("CREATED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DESCRIPTION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DTEND", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("DURATION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("GEO", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("LOCATION", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("PRIORITY", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RESOURCES", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("STATUS", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("TRANSP", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("URL", this.getProperties());
        Iterator i = this.getAlarms().iterator();
        while (i.hasNext()) {
            VAlarm alarm = (VAlarm)i.next();
            alarm.validateCounter();
        }
    }

    public void validateDeclineCounter() throws ValidationException {
        PropertyValidator.getInstance().assertOne("DTSTAMP", this.getProperties());
        PropertyValidator.getInstance().assertOne("ORGANIZER", this.getProperties());
        PropertyValidator.getInstance().assertOne("UID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("COMMENT", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("RECURRENCE-ID", this.getProperties());
        PropertyValidator.getInstance().assertOneOrLess("SEQUENCE", this.getProperties());
        PropertyValidator.getInstance().assertNone("ATTACH", this.getProperties());
        PropertyValidator.getInstance().assertNone("ATTENDEE", this.getProperties());
        PropertyValidator.getInstance().assertNone("CATEGORIES", this.getProperties());
        PropertyValidator.getInstance().assertNone("CLASS", this.getProperties());
        PropertyValidator.getInstance().assertNone("CONTACT", this.getProperties());
        PropertyValidator.getInstance().assertNone("CREATED", this.getProperties());
        PropertyValidator.getInstance().assertNone("DESCRIPTION", this.getProperties());
        PropertyValidator.getInstance().assertNone("DTEND", this.getProperties());
        PropertyValidator.getInstance().assertNone("DTSTART", this.getProperties());
        PropertyValidator.getInstance().assertNone("DURATION", this.getProperties());
        PropertyValidator.getInstance().assertNone("EXDATE", this.getProperties());
        PropertyValidator.getInstance().assertNone("EXRULE", this.getProperties());
        PropertyValidator.getInstance().assertNone("GEO", this.getProperties());
        PropertyValidator.getInstance().assertNone("LAST-MODIFIED", this.getProperties());
        PropertyValidator.getInstance().assertNone("LOCATION", this.getProperties());
        PropertyValidator.getInstance().assertNone("PRIORITY", this.getProperties());
        PropertyValidator.getInstance().assertNone("RDATE", this.getProperties());
        PropertyValidator.getInstance().assertNone("RELATED-TO", this.getProperties());
        PropertyValidator.getInstance().assertNone("RESOURCES", this.getProperties());
        PropertyValidator.getInstance().assertNone("RRULE", this.getProperties());
        PropertyValidator.getInstance().assertNone("STATUS", this.getProperties());
        PropertyValidator.getInstance().assertNone("SUMMARY", this.getProperties());
        PropertyValidator.getInstance().assertNone("TRANSP", this.getProperties());
        PropertyValidator.getInstance().assertNone("URL", this.getProperties());
        ComponentValidator.assertNone("VALARM", this.getAlarms());
    }

    public final PeriodList getConsumedTime(Date rangeStart, Date rangeEnd) {
        return this.getConsumedTime(rangeStart, rangeEnd, true);
    }

    public final PeriodList getConsumedTime(Date rangeStart, Date rangeEnd, boolean normalise) {
        PeriodList periods = new PeriodList();
        if (Transp.TRANSPARENT.equals(this.getProperty("TRANSP"))) {
            return periods;
        }
        periods = this.calculateRecurrenceSet(new Period(new DateTime(rangeStart), new DateTime(rangeEnd)));
        if (!periods.isEmpty() && normalise) {
            return periods.normalise();
        }
        return periods;
    }

    public final VEvent getOccurrence(Date date) throws IOException, URISyntaxException, ParseException {
        PeriodList consumedTime = this.getConsumedTime(date, date);
        Iterator i = consumedTime.iterator();
        while (i.hasNext()) {
            Period p = (Period)i.next();
            if (!p.getStart().equals(date)) continue;
            VEvent occurrence = (VEvent)this.copy();
            occurrence.getProperties().add(new RecurrenceId(date));
            return occurrence;
        }
        return null;
    }

    public final Clazz getClassification() {
        return (Clazz)this.getProperty("CLASS");
    }

    public final Created getCreated() {
        return (Created)this.getProperty("CREATED");
    }

    public final Description getDescription() {
        return (Description)this.getProperty("DESCRIPTION");
    }

    public final DtStart getStartDate() {
        return (DtStart)this.getProperty("DTSTART");
    }

    public final Geo getGeographicPos() {
        return (Geo)this.getProperty("GEO");
    }

    public final LastModified getLastModified() {
        return (LastModified)this.getProperty("LAST-MODIFIED");
    }

    public final Location getLocation() {
        return (Location)this.getProperty("LOCATION");
    }

    public final Organizer getOrganizer() {
        return (Organizer)this.getProperty("ORGANIZER");
    }

    public final Priority getPriority() {
        return (Priority)this.getProperty("PRIORITY");
    }

    public final DtStamp getDateStamp() {
        return (DtStamp)this.getProperty("DTSTAMP");
    }

    public final Sequence getSequence() {
        return (Sequence)this.getProperty("SEQUENCE");
    }

    public final Status getStatus() {
        return (Status)this.getProperty("STATUS");
    }

    public final Summary getSummary() {
        return (Summary)this.getProperty("SUMMARY");
    }

    public final Transp getTransparency() {
        return (Transp)this.getProperty("TRANSP");
    }

    public final Url getUrl() {
        return (Url)this.getProperty("URL");
    }

    public final RecurrenceId getRecurrenceId() {
        return (RecurrenceId)this.getProperty("RECURRENCE-ID");
    }

    public final DtEnd getEndDate() {
        return this.getEndDate(true);
    }

    public final DtEnd getEndDate(boolean deriveFromDuration) {
        DtEnd dtEnd = (DtEnd)this.getProperty("DTEND");
        if (dtEnd == null && deriveFromDuration && this.getDuration() != null) {
            DtStart dtStart = this.getStartDate();
            Duration vEventDuration = this.getDuration();
            dtEnd = new DtEnd(Dates.getInstance(vEventDuration.getDuration().getTime(dtStart.getDate()), (Value)dtStart.getParameter("VALUE")));
            if (dtStart.isUtc()) {
                dtEnd.setUtc(true);
            }
        }
        return dtEnd;
    }

    public final Duration getDuration() {
        return (Duration)this.getProperty("DURATION");
    }

    public final Uid getUid() {
        return (Uid)this.getProperty("UID");
    }

    public boolean equals(Object arg0) {
        if (arg0 instanceof VEvent) {
            return super.equals(arg0) && ObjectUtils.equals((Object)this.alarms, (Object)((VEvent)arg0).getAlarms());
        }
        return super.equals(arg0);
    }

    public int hashCode() {
        return new HashCodeBuilder().append((Object)this.getName()).append((Object)this.getProperties()).append((Object)this.getAlarms()).toHashCode();
    }

    public Component copy() throws ParseException, IOException, URISyntaxException {
        VEvent copy = (VEvent)super.copy();
        copy.alarms = new ComponentList(this.alarms);
        return copy;
    }
}

