/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.help;

import java.io.BufferedReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.openstreetmap.josm.gui.help.HelpContentReaderException;
import org.openstreetmap.josm.gui.help.MissingHelpContentException;
import org.openstreetmap.josm.tools.HttpClient;
import org.openstreetmap.josm.tools.WikiReader;

public class HelpContentReader
extends WikiReader {
    public HelpContentReader(String baseUrl) {
        super(baseUrl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String fetchHelpTopicContent(String helpTopicUrl, boolean dotest) throws HelpContentReaderException {
        if (helpTopicUrl == null) {
            throw new MissingHelpContentException("helpTopicUrl is null");
        }
        HttpClient.Response con = null;
        try {
            URL u = new URL(helpTopicUrl);
            con = HttpClient.create(u).connect();
            try (BufferedReader in = con.getContentReader();){
                String string = this.prepareHelpContent(in, dotest, u);
                return string;
            }
        }
        catch (MalformedURLException e) {
            throw new HelpContentReaderException(e, 0);
        }
        catch (IOException e) {
            int n;
            if (con != null) {
                n = con.getResponseCode();
                throw new HelpContentReaderException(e, n);
            }
            n = 0;
            throw new HelpContentReaderException(e, n);
        }
    }

    protected String prepareHelpContent(BufferedReader in, boolean dotest, URL url) throws HelpContentReaderException {
        String s = "";
        try {
            s = this.readFromTrac(in, url);
        }
        catch (IOException e) {
            throw new HelpContentReaderException(e, 0);
        }
        if (dotest && s.isEmpty()) {
            throw new MissingHelpContentException(s);
        }
        return s;
    }
}

