/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.datatransfer.importers;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.TransferHandler;
import org.openstreetmap.josm.actions.OpenLocationAction;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.gui.MapView;
import org.openstreetmap.josm.gui.datatransfer.importers.AbstractOsmDataPaster;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;

public class OsmLinkPaster
extends AbstractOsmDataPaster {
    private static final String OSM_SERVER = "^https?\\://(\\w+\\.)?(osm|openstreetmap)\\.org/";

    public OsmLinkPaster() {
        super(DataFlavor.stringFlavor);
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support, OsmDataLayer layer, EastNorth pasteAt) throws UnsupportedFlavorException, IOException {
        Component comp;
        if (!this.supports(support)) {
            throw new UnsupportedFlavorException(this.df);
        }
        String transferData = (String)support.getTransferable().getTransferData(this.df);
        if (!new NoWarnOpenLocationAction().openUrl(transferData).isEmpty()) {
            return true;
        }
        LatLon ll = OsmLinkPaster.parseLatLon(transferData);
        if (ll != null && (comp = support.getComponent()) instanceof MapView) {
            ((MapView)comp).zoomTo(ll);
        }
        return false;
    }

    static LatLon parseLatLon(String transferData) {
        Matcher matcher = Pattern.compile("^https?\\://(\\w+\\.)?(osm|openstreetmap)\\.org/#map=(?<zoom>\\d+)/(?<lat>-?\\d+\\.\\d+)/(?<lon>-?\\d+\\.\\d+)$").matcher(transferData);
        if (!matcher.matches()) {
            return null;
        }
        return new LatLon(Double.parseDouble(matcher.group("lat")), Double.parseDouble(matcher.group("lon")));
    }

    static final class NoWarnOpenLocationAction
    extends OpenLocationAction {
        NoWarnOpenLocationAction() {
        }

        @Override
        protected void warnNoSuitableTasks(String url) {
        }
    }
}

