/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.heapviewer.truffle.lang.ruby;

import java.util.Collection;
import org.graalvm.visualvm.heapviewer.HeapContext;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.Bundle;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyHeapFragment;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyLanguage;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyNodes;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyObject;
import org.graalvm.visualvm.heapviewer.truffle.lang.ruby.RubyType;
import org.graalvm.visualvm.heapviewer.truffle.ui.TruffleObjectsView;
import org.graalvm.visualvm.heapviewer.truffle.ui.TruffleSummaryView;
import org.graalvm.visualvm.heapviewer.truffle.ui.TruffleThreadsView;
import org.graalvm.visualvm.heapviewer.ui.HeapView;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerActions;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerFeature;
import org.graalvm.visualvm.heapviewer.ui.HeapViewerNodeAction;
import org.graalvm.visualvm.heapviewer.ui.SummaryView;
import org.graalvm.visualvm.lib.jfluid.heap.FieldValue;
import org.graalvm.visualvm.lib.jfluid.heap.Heap;
import org.graalvm.visualvm.lib.jfluid.heap.Instance;
import org.graalvm.visualvm.lib.jfluid.heap.ObjectFieldValue;

final class RubyViews {
    RubyViews() {
    }

    public static class ThreadsViewProvider
    extends HeapViewerFeature.Provider {
        public HeapViewerFeature getFeature(HeapContext context, HeapViewerActions actions) {
            if (RubyHeapFragment.isRubyHeap(context)) {
                return new TruffleThreadsView(RubyLanguage.instance(), context, actions);
            }
            return null;
        }
    }

    public static class ObjectsViewProvider
    extends HeapViewerFeature.Provider {
        public HeapViewerFeature getFeature(HeapContext context, HeapViewerActions actions) {
            if (RubyHeapFragment.isRubyHeap(context)) {
                return new TruffleObjectsView(RubyLanguage.instance(), context, actions);
            }
            return null;
        }
    }

    public static class SummaryObjectsProvider
    extends SummaryView.ContentProvider {
        public HeapView createSummary(String viewID, HeapContext context, HeapViewerActions actions, Collection<HeapViewerNodeAction.Provider> actionProviders) {
            if (RubyHeapFragment.isRubyHeap(context)) {
                return new TruffleSummaryView.ObjectsSection(RubyLanguage.instance(), context, actions, actionProviders);
            }
            return null;
        }
    }

    private static class SummaryOverview
    extends TruffleSummaryView.OverviewSection {
        SummaryOverview(HeapContext context) {
            super(context, 3, 2);
        }

        @Override
        protected void computeEnvironmentData(Object[][] environmentData) {
            RubyObject platformO;
            super.computeEnvironmentData(environmentData);
            environmentData[1][0] = Bundle.RubyViews_Platform();
            RubyHeapFragment fragment = (RubyHeapFragment)this.getContext().getFragment();
            RubyType gemPlatform = (RubyType)fragment.getType("Gem::Platform", null);
            RubyObject rubyObject = platformO = gemPlatform == null || gemPlatform.getObjectsCount() == 0 ? null : (RubyObject)gemPlatform.getObjectsIterator().next();
            if (platformO != null) {
                Heap heap = fragment.getHeap();
                String osFV = SummaryOverview.variableValue(platformO, "@os", heap);
                String cpuFV = SummaryOverview.variableValue(platformO, "@cpu", heap);
                if (osFV != null || cpuFV != null) {
                    String platform = osFV;
                    if (cpuFV != null) {
                        platform = platform != null ? platform + " " : "";
                        platform = platform + cpuFV;
                    }
                    environmentData[1][1] = platform;
                }
            }
            if (environmentData[1][1] == null) {
                environmentData[1][1] = Bundle.RubyViews_Unknown();
            }
        }

        private static String variableValue(RubyObject object, String field, Heap heap) {
            Instance instance;
            FieldValue value = object == null ? null : object.getFieldValue(field);
            Instance instance2 = instance = value instanceof ObjectFieldValue ? ((ObjectFieldValue)value).getInstance() : null;
            if (instance == null || !RubyObject.isRubyObject(instance)) {
                return null;
            }
            RubyObject variableO = new RubyObject(instance);
            return RubyNodes.getLogicalValue(variableO, variableO.getType());
        }
    }

    public static class SummaryOverviewProvider
    extends SummaryView.ContentProvider {
        public HeapView createSummary(String viewID, HeapContext context, HeapViewerActions actions, Collection<HeapViewerNodeAction.Provider> actionProviders) {
            if (RubyHeapFragment.isRubyHeap(context)) {
                return new SummaryOverview(context);
            }
            return null;
        }
    }

    public static class SummaryViewProvider
    extends HeapViewerFeature.Provider {
        public HeapViewerFeature getFeature(HeapContext context, HeapViewerActions actions) {
            if (RubyHeapFragment.isRubyHeap(context)) {
                return new TruffleSummaryView(RubyLanguage.instance(), context, actions);
            }
            return null;
        }
    }
}

