# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("mswsock.dll")
prototypes = \
    {
        #
        'WSARecvEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["s", "buf", "len", "flags"]),
        #
        'TransmitFile': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"Head": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "HeadLength": SimTypeInt(signed=False, label="UInt32"), "Tail": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "TailLength": SimTypeInt(signed=False, label="UInt32")}, name="TRANSMIT_FILE_BUFFERS", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["hSocket", "hFile", "nNumberOfBytesToWrite", "nNumberOfBytesPerSend", "lpOverlapped", "lpTransmitBuffers", "dwReserved"]),
        #
        'AcceptEx': SimTypeFunction([SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"Internal": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "InternalHigh": SimTypePointer(SimTypeInt(signed=False, label="UInt"), label="UIntPtr", offset=0), "Anonymous": SimUnion({"Anonymous": SimStruct({"Offset": SimTypeInt(signed=False, label="UInt32"), "OffsetHigh": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "Pointer": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="<anon>", label="None"), "hEvent": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="OVERLAPPED", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["sListenSocket", "sAcceptSocket", "lpOutputBuffer", "dwReceiveDataLength", "dwLocalAddressLength", "dwRemoteAddressLength", "lpdwBytesReceived", "lpOverlapped"]),
        #
        'GetAcceptExSockaddrs': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"sa_family": SimTypeShort(signed=False, label="UInt16"), "sa_data": SimTypeFixedSizeArray(SimTypeBottom(label="CHAR"), 14)}, name="SOCKADDR", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0)], SimTypeBottom(label="Void"), arg_names=["lpOutputBuffer", "dwReceiveDataLength", "dwLocalAddressLength", "dwRemoteAddressLength", "LocalSockaddr", "LocalSockaddrLength", "RemoteSockaddr", "RemoteSockaddrLength"]),
        #
        'EnumProtocolsA': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpiProtocols", "lpProtocolBuffer", "lpdwBufferLength"]),
        #
        'EnumProtocolsW': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpiProtocols", "lpProtocolBuffer", "lpdwBufferLength"]),
        #
        'GetAddressByNameA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"lpServiceCallbackProc": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["lParam", "hAsyncTaskHandle"]), offset=0), "lParam": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hAsyncTaskHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="SERVICE_ASYNC_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwNameSpace", "lpServiceType", "lpServiceName", "lpiProtocols", "dwResolution", "lpServiceAsyncInfo", "lpCsaddrBuffer", "lpdwBufferLength", "lpAliasBuffer", "lpdwAliasBufferLength"]),
        #
        'GetAddressByNameW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"lpServiceCallbackProc": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["lParam", "hAsyncTaskHandle"]), offset=0), "lParam": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hAsyncTaskHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="SERVICE_ASYNC_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwNameSpace", "lpServiceType", "lpServiceName", "lpiProtocols", "dwResolution", "lpServiceAsyncInfo", "lpCsaddrBuffer", "lpdwBufferLength", "lpAliasBuffer", "lpdwAliasBufferLength"]),
        #
        'GetTypeByNameA': SimTypeFunction([SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpServiceName", "lpServiceType"]),
        #
        'GetTypeByNameW': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["lpServiceName", "lpServiceType"]),
        #
        'GetNameByTypeA': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpServiceType", "lpServiceName", "dwNameLength"]),
        #
        'GetNameByTypeW': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["lpServiceType", "lpServiceName", "dwNameLength"]),
        #
        'SetServiceA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="SET_SERVICE_OPERATION"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"lpServiceType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "lpServiceName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpComment": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpLocale": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "dwDisplayHint": SimTypeInt(signed=False, label="RESOURCE_DISPLAY_TYPE"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwTime": SimTypeInt(signed=False, label="UInt32"), "lpMachineName": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpServiceAddress": SimTypePointer(SimStruct({"dwAddressCount": SimTypeInt(signed=False, label="UInt32"), "Addresses": SimTypePointer(SimStruct({"dwAddressType": SimTypeInt(signed=False, label="UInt32"), "dwAddressFlags": SimTypeInt(signed=False, label="UInt32"), "dwAddressLength": SimTypeInt(signed=False, label="UInt32"), "dwPrincipalLength": SimTypeInt(signed=False, label="UInt32"), "lpAddress": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpPrincipal": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SERVICE_ADDRESS", pack=False, align=None), offset=0)}, name="SERVICE_ADDRESSES", pack=False, align=None), offset=0), "ServiceSpecificInfo": SimTypeBottom(label="BLOB")}, name="SERVICE_INFOA", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"lpServiceCallbackProc": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["lParam", "hAsyncTaskHandle"]), offset=0), "lParam": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hAsyncTaskHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="SERVICE_ASYNC_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwNameSpace", "dwOperation", "dwFlags", "lpServiceInfo", "lpServiceAsyncInfo", "lpdwStatusFlags"]),
        #
        'SetServiceW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="SET_SERVICE_OPERATION"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"lpServiceType": SimTypePointer(SimTypeBottom(label="Guid"), offset=0), "lpServiceName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpComment": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpLocale": SimTypePointer(SimTypeChar(label="Char"), offset=0), "dwDisplayHint": SimTypeInt(signed=False, label="RESOURCE_DISPLAY_TYPE"), "dwVersion": SimTypeInt(signed=False, label="UInt32"), "dwTime": SimTypeInt(signed=False, label="UInt32"), "lpMachineName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "lpServiceAddress": SimTypePointer(SimStruct({"dwAddressCount": SimTypeInt(signed=False, label="UInt32"), "Addresses": SimTypePointer(SimStruct({"dwAddressType": SimTypeInt(signed=False, label="UInt32"), "dwAddressFlags": SimTypeInt(signed=False, label="UInt32"), "dwAddressLength": SimTypeInt(signed=False, label="UInt32"), "dwPrincipalLength": SimTypeInt(signed=False, label="UInt32"), "lpAddress": SimTypePointer(SimTypeChar(label="Byte"), offset=0), "lpPrincipal": SimTypePointer(SimTypeChar(label="Byte"), offset=0)}, name="SERVICE_ADDRESS", pack=False, align=None), offset=0)}, name="SERVICE_ADDRESSES", pack=False, align=None), offset=0), "ServiceSpecificInfo": SimTypeBottom(label="BLOB")}, name="SERVICE_INFOW", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"lpServiceCallbackProc": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["lParam", "hAsyncTaskHandle"]), offset=0), "lParam": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hAsyncTaskHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="SERVICE_ASYNC_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwNameSpace", "dwOperation", "dwFlags", "lpServiceInfo", "lpServiceAsyncInfo", "lpdwStatusFlags"]),
        #
        'GetServiceA': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"lpServiceCallbackProc": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["lParam", "hAsyncTaskHandle"]), offset=0), "lParam": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hAsyncTaskHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="SERVICE_ASYNC_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwNameSpace", "lpGuid", "lpServiceName", "dwProperties", "lpBuffer", "lpdwBufferSize", "lpServiceAsyncInfo"]),
        #
        'GetServiceW': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimStruct({"lpServiceCallbackProc": SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeBottom(label="Void"), arg_names=["lParam", "hAsyncTaskHandle"]), offset=0), "lParam": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), "hAsyncTaskHandle": SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)}, name="SERVICE_ASYNC_INFO", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["dwNameSpace", "lpGuid", "lpServiceName", "dwProperties", "lpBuffer", "lpdwBufferSize", "lpServiceAsyncInfo"]),
    }

lib.set_prototypes(prototypes)
