# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("hid.dll")
prototypes = \
    {
        #
        'HidP_GetCaps': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Usage": SimTypeShort(signed=False, label="UInt16"), "UsagePage": SimTypeShort(signed=False, label="UInt16"), "InputReportByteLength": SimTypeShort(signed=False, label="UInt16"), "OutputReportByteLength": SimTypeShort(signed=False, label="UInt16"), "FeatureReportByteLength": SimTypeShort(signed=False, label="UInt16"), "Reserved": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 17), "NumberLinkCollectionNodes": SimTypeShort(signed=False, label="UInt16"), "NumberInputButtonCaps": SimTypeShort(signed=False, label="UInt16"), "NumberInputValueCaps": SimTypeShort(signed=False, label="UInt16"), "NumberInputDataIndices": SimTypeShort(signed=False, label="UInt16"), "NumberOutputButtonCaps": SimTypeShort(signed=False, label="UInt16"), "NumberOutputValueCaps": SimTypeShort(signed=False, label="UInt16"), "NumberOutputDataIndices": SimTypeShort(signed=False, label="UInt16"), "NumberFeatureButtonCaps": SimTypeShort(signed=False, label="UInt16"), "NumberFeatureValueCaps": SimTypeShort(signed=False, label="UInt16"), "NumberFeatureDataIndices": SimTypeShort(signed=False, label="UInt16")}, name="HIDP_CAPS", pack=False, align=None), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["PreparsedData", "Capabilities"]),
        #
        'HidP_GetLinkCollectionNodes': SimTypeFunction([SimTypePointer(SimStruct({"LinkUsage": SimTypeShort(signed=False, label="UInt16"), "LinkUsagePage": SimTypeShort(signed=False, label="UInt16"), "Parent": SimTypeShort(signed=False, label="UInt16"), "NumberOfChildren": SimTypeShort(signed=False, label="UInt16"), "NextSibling": SimTypeShort(signed=False, label="UInt16"), "FirstChild": SimTypeShort(signed=False, label="UInt16"), "_bitfield": SimTypeInt(signed=False, label="UInt32"), "UserContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="HIDP_LINK_COLLECTION_NODE", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["LinkCollectionNodes", "LinkCollectionNodesLength", "PreparsedData"]),
        #
        'HidP_GetSpecificButtonCaps': SimTypeFunction([SimTypeInt(signed=False, label="HIDP_REPORT_TYPE"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimStruct({"UsagePage": SimTypeShort(signed=False, label="UInt16"), "ReportID": SimTypeChar(label="Byte"), "IsAlias": SimTypeBottom(label="BOOLEAN"), "BitField": SimTypeShort(signed=False, label="UInt16"), "LinkCollection": SimTypeShort(signed=False, label="UInt16"), "LinkUsage": SimTypeShort(signed=False, label="UInt16"), "LinkUsagePage": SimTypeShort(signed=False, label="UInt16"), "IsRange": SimTypeBottom(label="BOOLEAN"), "IsStringRange": SimTypeBottom(label="BOOLEAN"), "IsDesignatorRange": SimTypeBottom(label="BOOLEAN"), "IsAbsolute": SimTypeBottom(label="BOOLEAN"), "Reserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 10), "Anonymous": SimUnion({"Range": SimStruct({"UsageMin": SimTypeShort(signed=False, label="UInt16"), "UsageMax": SimTypeShort(signed=False, label="UInt16"), "StringMin": SimTypeShort(signed=False, label="UInt16"), "StringMax": SimTypeShort(signed=False, label="UInt16"), "DesignatorMin": SimTypeShort(signed=False, label="UInt16"), "DesignatorMax": SimTypeShort(signed=False, label="UInt16"), "DataIndexMin": SimTypeShort(signed=False, label="UInt16"), "DataIndexMax": SimTypeShort(signed=False, label="UInt16")}, name="_Range_e__Struct", pack=False, align=None), "NotRange": SimStruct({"Usage": SimTypeShort(signed=False, label="UInt16"), "Reserved1": SimTypeShort(signed=False, label="UInt16"), "StringIndex": SimTypeShort(signed=False, label="UInt16"), "Reserved2": SimTypeShort(signed=False, label="UInt16"), "DesignatorIndex": SimTypeShort(signed=False, label="UInt16"), "Reserved3": SimTypeShort(signed=False, label="UInt16"), "DataIndex": SimTypeShort(signed=False, label="UInt16"), "Reserved4": SimTypeShort(signed=False, label="UInt16")}, name="_NotRange_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="HIDP_BUTTON_CAPS", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ReportType", "UsagePage", "LinkCollection", "Usage", "ButtonCaps", "ButtonCapsLength", "PreparsedData"]),
        #
        'HidP_GetButtonCaps': SimTypeFunction([SimTypeInt(signed=False, label="HIDP_REPORT_TYPE"), SimTypePointer(SimStruct({"UsagePage": SimTypeShort(signed=False, label="UInt16"), "ReportID": SimTypeChar(label="Byte"), "IsAlias": SimTypeBottom(label="BOOLEAN"), "BitField": SimTypeShort(signed=False, label="UInt16"), "LinkCollection": SimTypeShort(signed=False, label="UInt16"), "LinkUsage": SimTypeShort(signed=False, label="UInt16"), "LinkUsagePage": SimTypeShort(signed=False, label="UInt16"), "IsRange": SimTypeBottom(label="BOOLEAN"), "IsStringRange": SimTypeBottom(label="BOOLEAN"), "IsDesignatorRange": SimTypeBottom(label="BOOLEAN"), "IsAbsolute": SimTypeBottom(label="BOOLEAN"), "Reserved": SimTypeFixedSizeArray(SimTypeInt(signed=False, label="UInt32"), 10), "Anonymous": SimUnion({"Range": SimStruct({"UsageMin": SimTypeShort(signed=False, label="UInt16"), "UsageMax": SimTypeShort(signed=False, label="UInt16"), "StringMin": SimTypeShort(signed=False, label="UInt16"), "StringMax": SimTypeShort(signed=False, label="UInt16"), "DesignatorMin": SimTypeShort(signed=False, label="UInt16"), "DesignatorMax": SimTypeShort(signed=False, label="UInt16"), "DataIndexMin": SimTypeShort(signed=False, label="UInt16"), "DataIndexMax": SimTypeShort(signed=False, label="UInt16")}, name="_Range_e__Struct", pack=False, align=None), "NotRange": SimStruct({"Usage": SimTypeShort(signed=False, label="UInt16"), "Reserved1": SimTypeShort(signed=False, label="UInt16"), "StringIndex": SimTypeShort(signed=False, label="UInt16"), "Reserved2": SimTypeShort(signed=False, label="UInt16"), "DesignatorIndex": SimTypeShort(signed=False, label="UInt16"), "Reserved3": SimTypeShort(signed=False, label="UInt16"), "DataIndex": SimTypeShort(signed=False, label="UInt16"), "Reserved4": SimTypeShort(signed=False, label="UInt16")}, name="_NotRange_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="HIDP_BUTTON_CAPS", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ReportType", "ButtonCaps", "ButtonCapsLength", "PreparsedData"]),
        #
        'HidP_GetSpecificValueCaps': SimTypeFunction([SimTypeInt(signed=False, label="HIDP_REPORT_TYPE"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimStruct({"UsagePage": SimTypeShort(signed=False, label="UInt16"), "ReportID": SimTypeChar(label="Byte"), "IsAlias": SimTypeBottom(label="BOOLEAN"), "BitField": SimTypeShort(signed=False, label="UInt16"), "LinkCollection": SimTypeShort(signed=False, label="UInt16"), "LinkUsage": SimTypeShort(signed=False, label="UInt16"), "LinkUsagePage": SimTypeShort(signed=False, label="UInt16"), "IsRange": SimTypeBottom(label="BOOLEAN"), "IsStringRange": SimTypeBottom(label="BOOLEAN"), "IsDesignatorRange": SimTypeBottom(label="BOOLEAN"), "IsAbsolute": SimTypeBottom(label="BOOLEAN"), "HasNull": SimTypeBottom(label="BOOLEAN"), "Reserved": SimTypeChar(label="Byte"), "BitSize": SimTypeShort(signed=False, label="UInt16"), "ReportCount": SimTypeShort(signed=False, label="UInt16"), "Reserved2": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 5), "UnitsExp": SimTypeInt(signed=False, label="UInt32"), "Units": SimTypeInt(signed=False, label="UInt32"), "LogicalMin": SimTypeInt(signed=True, label="Int32"), "LogicalMax": SimTypeInt(signed=True, label="Int32"), "PhysicalMin": SimTypeInt(signed=True, label="Int32"), "PhysicalMax": SimTypeInt(signed=True, label="Int32"), "Anonymous": SimUnion({"Range": SimStruct({"UsageMin": SimTypeShort(signed=False, label="UInt16"), "UsageMax": SimTypeShort(signed=False, label="UInt16"), "StringMin": SimTypeShort(signed=False, label="UInt16"), "StringMax": SimTypeShort(signed=False, label="UInt16"), "DesignatorMin": SimTypeShort(signed=False, label="UInt16"), "DesignatorMax": SimTypeShort(signed=False, label="UInt16"), "DataIndexMin": SimTypeShort(signed=False, label="UInt16"), "DataIndexMax": SimTypeShort(signed=False, label="UInt16")}, name="_Range_e__Struct", pack=False, align=None), "NotRange": SimStruct({"Usage": SimTypeShort(signed=False, label="UInt16"), "Reserved1": SimTypeShort(signed=False, label="UInt16"), "StringIndex": SimTypeShort(signed=False, label="UInt16"), "Reserved2": SimTypeShort(signed=False, label="UInt16"), "DesignatorIndex": SimTypeShort(signed=False, label="UInt16"), "Reserved3": SimTypeShort(signed=False, label="UInt16"), "DataIndex": SimTypeShort(signed=False, label="UInt16"), "Reserved4": SimTypeShort(signed=False, label="UInt16")}, name="_NotRange_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="HIDP_VALUE_CAPS", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ReportType", "UsagePage", "LinkCollection", "Usage", "ValueCaps", "ValueCapsLength", "PreparsedData"]),
        #
        'HidP_GetValueCaps': SimTypeFunction([SimTypeInt(signed=False, label="HIDP_REPORT_TYPE"), SimTypePointer(SimStruct({"UsagePage": SimTypeShort(signed=False, label="UInt16"), "ReportID": SimTypeChar(label="Byte"), "IsAlias": SimTypeBottom(label="BOOLEAN"), "BitField": SimTypeShort(signed=False, label="UInt16"), "LinkCollection": SimTypeShort(signed=False, label="UInt16"), "LinkUsage": SimTypeShort(signed=False, label="UInt16"), "LinkUsagePage": SimTypeShort(signed=False, label="UInt16"), "IsRange": SimTypeBottom(label="BOOLEAN"), "IsStringRange": SimTypeBottom(label="BOOLEAN"), "IsDesignatorRange": SimTypeBottom(label="BOOLEAN"), "IsAbsolute": SimTypeBottom(label="BOOLEAN"), "HasNull": SimTypeBottom(label="BOOLEAN"), "Reserved": SimTypeChar(label="Byte"), "BitSize": SimTypeShort(signed=False, label="UInt16"), "ReportCount": SimTypeShort(signed=False, label="UInt16"), "Reserved2": SimTypeFixedSizeArray(SimTypeShort(signed=False, label="UInt16"), 5), "UnitsExp": SimTypeInt(signed=False, label="UInt32"), "Units": SimTypeInt(signed=False, label="UInt32"), "LogicalMin": SimTypeInt(signed=True, label="Int32"), "LogicalMax": SimTypeInt(signed=True, label="Int32"), "PhysicalMin": SimTypeInt(signed=True, label="Int32"), "PhysicalMax": SimTypeInt(signed=True, label="Int32"), "Anonymous": SimUnion({"Range": SimStruct({"UsageMin": SimTypeShort(signed=False, label="UInt16"), "UsageMax": SimTypeShort(signed=False, label="UInt16"), "StringMin": SimTypeShort(signed=False, label="UInt16"), "StringMax": SimTypeShort(signed=False, label="UInt16"), "DesignatorMin": SimTypeShort(signed=False, label="UInt16"), "DesignatorMax": SimTypeShort(signed=False, label="UInt16"), "DataIndexMin": SimTypeShort(signed=False, label="UInt16"), "DataIndexMax": SimTypeShort(signed=False, label="UInt16")}, name="_Range_e__Struct", pack=False, align=None), "NotRange": SimStruct({"Usage": SimTypeShort(signed=False, label="UInt16"), "Reserved1": SimTypeShort(signed=False, label="UInt16"), "StringIndex": SimTypeShort(signed=False, label="UInt16"), "Reserved2": SimTypeShort(signed=False, label="UInt16"), "DesignatorIndex": SimTypeShort(signed=False, label="UInt16"), "Reserved3": SimTypeShort(signed=False, label="UInt16"), "DataIndex": SimTypeShort(signed=False, label="UInt16"), "Reserved4": SimTypeShort(signed=False, label="UInt16")}, name="_NotRange_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="HIDP_VALUE_CAPS", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ReportType", "ValueCaps", "ValueCapsLength", "PreparsedData"]),
        #
        'HidP_GetExtendedAttributes': SimTypeFunction([SimTypeInt(signed=False, label="HIDP_REPORT_TYPE"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"NumGlobalUnknowns": SimTypeChar(label="Byte"), "Reserved": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "GlobalUnknowns": SimTypePointer(SimStruct({"Token": SimTypeChar(label="Byte"), "Reserved": SimTypeFixedSizeArray(SimTypeChar(label="Byte"), 3), "BitField": SimTypeInt(signed=False, label="UInt32")}, name="HIDP_UNKNOWN_TOKEN", pack=False, align=None), offset=0), "Data": SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)}, name="HIDP_EXTENDED_ATTRIBUTES", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ReportType", "DataIndex", "PreparsedData", "Attributes", "LengthAttributes"]),
        #
        'HidP_InitializeReportForID': SimTypeFunction([SimTypeInt(signed=False, label="HIDP_REPORT_TYPE"), SimTypeChar(label="Byte"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["ReportType", "ReportID", "PreparsedData", "Report", "ReportLength"]),
        #
        'HidP_SetData': SimTypeFunction([SimTypeInt(signed=False, label="HIDP_REPORT_TYPE"), SimTypePointer(SimStruct({"DataIndex": SimTypeShort(signed=False, label="UInt16"), "Reserved": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"RawValue": SimTypeInt(signed=False, label="UInt32"), "On": SimTypeBottom(label="BOOLEAN")}, name="<anon>", label="None")}, name="HIDP_DATA", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["ReportType", "DataList", "DataLength", "PreparsedData", "Report", "ReportLength"]),
        #
        'HidP_GetData': SimTypeFunction([SimTypeInt(signed=False, label="HIDP_REPORT_TYPE"), SimTypePointer(SimStruct({"DataIndex": SimTypeShort(signed=False, label="UInt16"), "Reserved": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimUnion({"RawValue": SimTypeInt(signed=False, label="UInt32"), "On": SimTypeBottom(label="BOOLEAN")}, name="<anon>", label="None")}, name="HIDP_DATA", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["ReportType", "DataList", "DataLength", "PreparsedData", "Report", "ReportLength"]),
        #
        'HidP_MaxDataListLength': SimTypeFunction([SimTypeInt(signed=False, label="HIDP_REPORT_TYPE"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ReportType", "PreparsedData"]),
        #
        'HidP_SetUsages': SimTypeFunction([SimTypeInt(signed=False, label="HIDP_REPORT_TYPE"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["ReportType", "UsagePage", "LinkCollection", "UsageList", "UsageLength", "PreparsedData", "Report", "ReportLength"]),
        #
        'HidP_UnsetUsages': SimTypeFunction([SimTypeInt(signed=False, label="HIDP_REPORT_TYPE"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["ReportType", "UsagePage", "LinkCollection", "UsageList", "UsageLength", "PreparsedData", "Report", "ReportLength"]),
        #
        'HidP_GetUsages': SimTypeFunction([SimTypeInt(signed=False, label="HIDP_REPORT_TYPE"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["ReportType", "UsagePage", "LinkCollection", "UsageList", "UsageLength", "PreparsedData", "Report", "ReportLength"]),
        #
        'HidP_GetUsagesEx': SimTypeFunction([SimTypeInt(signed=False, label="HIDP_REPORT_TYPE"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimStruct({"Usage": SimTypeShort(signed=False, label="UInt16"), "UsagePage": SimTypeShort(signed=False, label="UInt16")}, name="USAGE_AND_PAGE", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["ReportType", "LinkCollection", "ButtonList", "UsageLength", "PreparsedData", "Report", "ReportLength"]),
        #
        'HidP_MaxUsageListLength': SimTypeFunction([SimTypeInt(signed=False, label="HIDP_REPORT_TYPE"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ReportType", "UsagePage", "PreparsedData"]),
        #
        'HidP_SetUsageValue': SimTypeFunction([SimTypeInt(signed=False, label="HIDP_REPORT_TYPE"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["ReportType", "UsagePage", "LinkCollection", "Usage", "UsageValue", "PreparsedData", "Report", "ReportLength"]),
        #
        'HidP_SetScaledUsageValue': SimTypeFunction([SimTypeInt(signed=False, label="HIDP_REPORT_TYPE"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypeInt(signed=True, label="Int32"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["ReportType", "UsagePage", "LinkCollection", "Usage", "UsageValue", "PreparsedData", "Report", "ReportLength"]),
        #
        'HidP_SetUsageValueArray': SimTypeFunction([SimTypeInt(signed=False, label="HIDP_REPORT_TYPE"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["ReportType", "UsagePage", "LinkCollection", "Usage", "UsageValue", "UsageValueByteLength", "PreparsedData", "Report", "ReportLength"]),
        #
        'HidP_GetUsageValue': SimTypeFunction([SimTypeInt(signed=False, label="HIDP_REPORT_TYPE"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["ReportType", "UsagePage", "LinkCollection", "Usage", "UsageValue", "PreparsedData", "Report", "ReportLength"]),
        #
        'HidP_GetScaledUsageValue': SimTypeFunction([SimTypeInt(signed=False, label="HIDP_REPORT_TYPE"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeInt(signed=True, label="Int32"), offset=0), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["ReportType", "UsagePage", "LinkCollection", "Usage", "UsageValue", "PreparsedData", "Report", "ReportLength"]),
        #
        'HidP_GetUsageValueArray': SimTypeFunction([SimTypeInt(signed=False, label="HIDP_REPORT_TYPE"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["ReportType", "UsagePage", "LinkCollection", "Usage", "UsageValue", "UsageValueByteLength", "PreparsedData", "Report", "ReportLength"]),
        #
        'HidP_UsageListDifference': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=True, label="Int32"), arg_names=["PreviousUsageList", "CurrentUsageList", "BreakUsageList", "MakeUsageList", "UsageListLength"]),
        #
        'HidP_TranslateUsagesToI8042ScanCodes': SimTypeFunction([SimTypePointer(SimTypeShort(signed=False, label="UInt16"), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeInt(signed=False, label="HIDP_KEYBOARD_DIRECTION"), SimTypePointer(SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "ul": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="HIDP_KEYBOARD_MODIFIER_STATE", pack=False, align=None), offset=0), SimTypePointer(SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeBottom(label="PSTR"), SimTypeInt(signed=False, label="UInt32")], SimTypeBottom(label="BOOLEAN"), arg_names=["Context", "NewScanCodes", "Length"]), offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0)], SimTypeInt(signed=True, label="Int32"), arg_names=["ChangedUsageList", "UsageListLength", "KeyAction", "ModifierState", "InsertCodesProcedure", "InsertCodesContext"]),
        #
        'HidD_GetAttributes': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"Size": SimTypeInt(signed=False, label="UInt32"), "VendorID": SimTypeShort(signed=False, label="UInt16"), "ProductID": SimTypeShort(signed=False, label="UInt16"), "VersionNumber": SimTypeShort(signed=False, label="UInt16")}, name="HIDD_ATTRIBUTES", pack=False, align=None), offset=0)], SimTypeChar(label="Byte"), arg_names=["HidDeviceObject", "Attributes"]),
        #
        'HidD_GetHidGuid': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0)], SimTypeBottom(label="Void"), arg_names=["HidGuid"]),
        #
        'HidD_GetPreparsedData': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeChar(label="Byte"), arg_names=["HidDeviceObject", "PreparsedData"]),
        #
        'HidD_FreePreparsedData': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeChar(label="Byte"), arg_names=["PreparsedData"]),
        #
        'HidD_FlushQueue': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeChar(label="Byte"), arg_names=["HidDeviceObject"]),
        #
        'HidD_GetConfiguration': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cookie": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "size": SimTypeInt(signed=False, label="UInt32"), "RingBufferSize": SimTypeInt(signed=False, label="UInt32")}, name="HIDD_CONFIGURATION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeChar(label="Byte"), arg_names=["HidDeviceObject", "Configuration", "ConfigurationLength"]),
        #
        'HidD_SetConfiguration': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"cookie": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "size": SimTypeInt(signed=False, label="UInt32"), "RingBufferSize": SimTypeInt(signed=False, label="UInt32")}, name="HIDD_CONFIGURATION", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeChar(label="Byte"), arg_names=["HidDeviceObject", "Configuration", "ConfigurationLength"]),
        #
        'HidD_GetFeature': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeChar(label="Byte"), arg_names=["HidDeviceObject", "ReportBuffer", "ReportBufferLength"]),
        #
        'HidD_SetFeature': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeChar(label="Byte"), arg_names=["HidDeviceObject", "ReportBuffer", "ReportBufferLength"]),
        #
        'HidD_GetInputReport': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeChar(label="Byte"), arg_names=["HidDeviceObject", "ReportBuffer", "ReportBufferLength"]),
        #
        'HidD_SetOutputReport': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeChar(label="Byte"), arg_names=["HidDeviceObject", "ReportBuffer", "ReportBufferLength"]),
        #
        'HidD_GetNumInputBuffers': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeChar(label="Byte"), arg_names=["HidDeviceObject", "NumberBuffers"]),
        #
        'HidD_SetNumInputBuffers': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeChar(label="Byte"), arg_names=["HidDeviceObject", "NumberBuffers"]),
        #
        'HidD_GetPhysicalDescriptor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeChar(label="Byte"), arg_names=["HidDeviceObject", "Buffer", "BufferLength"]),
        #
        'HidD_GetManufacturerString': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeChar(label="Byte"), arg_names=["HidDeviceObject", "Buffer", "BufferLength"]),
        #
        'HidD_GetProductString': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeChar(label="Byte"), arg_names=["HidDeviceObject", "Buffer", "BufferLength"]),
        #
        'HidD_GetIndexedString': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeChar(label="Byte"), arg_names=["HidDeviceObject", "StringIndex", "Buffer", "BufferLength"]),
        #
        'HidD_GetSerialNumberString': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeChar(label="Byte"), arg_names=["HidDeviceObject", "Buffer", "BufferLength"]),
        #
        'HidD_GetMsGenreDescriptor': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeChar(label="Byte"), arg_names=["HidDeviceObject", "Buffer", "BufferLength"]),
    }

lib.set_prototypes(prototypes)
