/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.integration.beans;

import java.beans.PropertyEditor;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.mina.integration.beans.ArrayEditor;
import org.apache.mina.integration.beans.CollectionEditor;
import org.apache.mina.integration.beans.EnumEditor;
import org.apache.mina.integration.beans.ListEditor;
import org.apache.mina.integration.beans.MapEditor;
import org.apache.mina.integration.beans.NullEditor;
import org.apache.mina.integration.beans.PropertiesEditor;
import org.apache.mina.integration.beans.SetEditor;

public final class PropertyEditorFactory {
    private PropertyEditorFactory() {
    }

    public static PropertyEditor getInstance(Object object) {
        if (object == null) {
            return new NullEditor();
        }
        if (object instanceof Collection) {
            Class<?> elementType = null;
            for (Object e : (Collection)object) {
                if (e == null) continue;
                elementType = e.getClass();
                break;
            }
            if (elementType != null) {
                if (object instanceof Set) {
                    return new SetEditor(elementType);
                }
                if (object instanceof List) {
                    return new ListEditor(elementType);
                }
                return new CollectionEditor(elementType);
            }
        }
        if (object instanceof Map) {
            Class<?> keyType = null;
            Class<?> valueType = null;
            for (Map.Entry entry : ((Map)object).entrySet()) {
                Map.Entry e = entry;
                if (e.getKey() == null || e.getValue() == null) continue;
                keyType = e.getKey().getClass();
                valueType = e.getValue().getClass();
                break;
            }
            if (keyType != null && valueType != null) {
                return new MapEditor(keyType, valueType);
            }
        }
        return PropertyEditorFactory.getInstance(object.getClass());
    }

    public static PropertyEditor getInstance(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("type");
        }
        if (type.isEnum()) {
            return new EnumEditor(type);
        }
        if (type.isArray()) {
            return new ArrayEditor(type.getComponentType());
        }
        if (Collection.class.isAssignableFrom(type)) {
            if (Set.class.isAssignableFrom(type)) {
                return new SetEditor(String.class);
            }
            if (List.class.isAssignableFrom(type)) {
                return new ListEditor(String.class);
            }
            return new CollectionEditor(String.class);
        }
        if (Map.class.isAssignableFrom(type)) {
            return new MapEditor(String.class, String.class);
        }
        if (Properties.class.isAssignableFrom(type)) {
            return new PropertiesEditor();
        }
        try {
            return (PropertyEditor)PropertyEditorFactory.class.getClassLoader().loadClass(PropertyEditorFactory.class.getPackage().getName() + '.' + PropertyEditorFactory.filterPrimitiveType(type).getSimpleName() + "Editor").newInstance();
        }
        catch (Exception e) {
            return null;
        }
    }

    private static Class<?> filterPrimitiveType(Class<?> type) {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return Boolean.class;
            }
            if (type == Byte.TYPE) {
                return Byte.class;
            }
            if (type == Character.TYPE) {
                return Character.class;
            }
            if (type == Double.TYPE) {
                return Double.class;
            }
            if (type == Float.TYPE) {
                return Float.class;
            }
            if (type == Integer.TYPE) {
                return Integer.class;
            }
            if (type == Long.TYPE) {
                return Long.class;
            }
            if (type == Short.TYPE) {
                return Short.class;
            }
        }
        return type;
    }
}

