/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.layouting.renderer.process;

import java.util.ArrayList;
import org.jfree.layouting.renderer.model.ParagraphRenderBox;
import org.jfree.layouting.renderer.process.layoutrules.InlineNodeSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.InlineSequenceElement;
import org.jfree.layouting.renderer.process.layoutrules.TextSequenceElement;

public class ParagraphBreakState {
    private Object suspendItem;
    private ArrayList primarySequence;
    private ParagraphRenderBox paragraph;
    private boolean containsContent;

    public ParagraphBreakState(ParagraphRenderBox paragraphRenderBox) {
        if (paragraphRenderBox == null) {
            throw new NullPointerException();
        }
        this.paragraph = paragraphRenderBox;
        this.primarySequence = new ArrayList();
    }

    public ParagraphRenderBox getParagraph() {
        return this.paragraph;
    }

    public Object getSuspendItem() {
        return this.suspendItem;
    }

    public void setSuspendItem(Object object) {
        this.suspendItem = object;
    }

    public void add(InlineSequenceElement inlineSequenceElement) {
        this.primarySequence.add(inlineSequenceElement);
        if (inlineSequenceElement instanceof TextSequenceElement || inlineSequenceElement instanceof InlineNodeSequenceElement) {
            this.containsContent = true;
        }
    }

    public boolean isContainsContent() {
        return this.containsContent;
    }

    public boolean isSuspended() {
        return this.suspendItem != null;
    }

    public InlineSequenceElement[] getSequence() {
        return this.primarySequence.toArray(new InlineSequenceElement[this.primarySequence.size()]);
    }

    public void clear() {
        this.primarySequence.clear();
        this.containsContent = false;
    }
}

