/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan;

import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiFunction;
import org.infinispan.Cache;
import org.jboss.logging.Logger;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.cache.infinispan.CacheManager;
import org.keycloak.models.cache.infinispan.RealmCacheSession;
import org.keycloak.models.cache.infinispan.entities.Revisioned;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;
import org.keycloak.models.cache.infinispan.events.RealmCacheInvalidationEvent;
import org.keycloak.models.cache.infinispan.stream.GroupListPredicate;
import org.keycloak.models.cache.infinispan.stream.HasRolePredicate;
import org.keycloak.models.cache.infinispan.stream.InClientPredicate;
import org.keycloak.models.cache.infinispan.stream.InGroupPredicate;
import org.keycloak.models.cache.infinispan.stream.InRealmPredicate;

public class RealmCacheManager
extends CacheManager {
    private static final Logger logger = Logger.getLogger(RealmCacheManager.class);
    private final ConcurrentHashMap<String, ReentrantLock> cacheInteractions = new ConcurrentHashMap();

    @Override
    protected Logger getLogger() {
        return logger;
    }

    public RealmCacheManager(Cache<String, Revisioned> cache, Cache<String, Long> revisions) {
        super(cache, revisions);
    }

    public void realmUpdated(String id, String name, Set<String> invalidations) {
        invalidations.add(id);
        invalidations.add(RealmCacheSession.getRealmByNameCacheKey(name));
    }

    public void realmRemoval(String id, String name, Set<String> invalidations) {
        this.realmUpdated(id, name, invalidations);
        this.addInvalidations(InRealmPredicate.create().realm(id), invalidations);
    }

    public void roleAdded(String roleContainerId, String roleName, Set<String> invalidations) {
        invalidations.add(RealmCacheSession.getRolesCacheKey(roleContainerId));
        invalidations.add(RealmCacheSession.getRoleByNameCacheKey(roleContainerId, roleName));
    }

    public void roleUpdated(String roleContainerId, String roleName, Set<String> invalidations) {
        invalidations.add(RealmCacheSession.getRoleByNameCacheKey(roleContainerId, roleName));
    }

    public void roleRemoval(String id, String roleName, String roleContainerId, Set<String> invalidations) {
        invalidations.add(RealmCacheSession.getRolesCacheKey(roleContainerId));
        invalidations.add(RealmCacheSession.getRoleByNameCacheKey(roleContainerId, roleName));
        this.addInvalidations(HasRolePredicate.create().role(id), invalidations);
    }

    public void clientScopeAdded(String realmId, Set<String> invalidations) {
        invalidations.add(RealmCacheSession.getClientScopesCacheKey(realmId));
    }

    public void clientScopeUpdated(String realmId, Set<String> invalidations) {
        invalidations.add(RealmCacheSession.getClientScopesCacheKey(realmId));
    }

    public void clientScopeRemoval(String realmId, Set<String> invalidations) {
        invalidations.add(RealmCacheSession.getClientScopesCacheKey(realmId));
        this.addInvalidations(InRealmPredicate.create().realm(realmId), invalidations);
    }

    public void groupQueriesInvalidations(String realmId, Set<String> invalidations) {
        invalidations.add(RealmCacheSession.getGroupsQueryCacheKey(realmId));
        invalidations.add(RealmCacheSession.getTopGroupsQueryCacheKey(realmId));
        this.addInvalidations(GroupListPredicate.create().realm(realmId), invalidations);
    }

    public void groupNameInvalidations(String groupId, Set<String> invalidations) {
        this.addInvalidations(InGroupPredicate.create().group(groupId), invalidations);
    }

    public void clientAdded(String realmId, Set<String> invalidations) {
        invalidations.add(RealmCacheSession.getRealmClientsQueryCacheKey(realmId));
    }

    public void clientUpdated(String realmId, String clientUuid, String clientId, Set<String> invalidations) {
        invalidations.add(RealmCacheSession.getClientByClientIdCacheKey(clientId, realmId));
        invalidations.add(RealmCacheSession.getClientScopesCacheKey(clientUuid, true));
        invalidations.add(RealmCacheSession.getClientScopesCacheKey(clientUuid, false));
    }

    public void clientRemoval(String realmId, String clientUUID, String clientId, Set<String> invalidations) {
        invalidations.add(RealmCacheSession.getRealmClientsQueryCacheKey(realmId));
        invalidations.add(RealmCacheSession.getClientByClientIdCacheKey(clientId, realmId));
        this.addInvalidations(InClientPredicate.create().client(clientUUID), invalidations);
    }

    @Override
    protected void addInvalidationsFromEvent(InvalidationEvent event, Set<String> invalidations) {
        invalidations.add(event.getId());
        ((RealmCacheInvalidationEvent)((Object)event)).addInvalidations(this, invalidations);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T computeSerialized(KeycloakSession session, String id, BiFunction<String, KeycloakSession, T> compute) {
        ReentrantLock lock = this.cacheInteractions.computeIfAbsent(id, s -> new ReentrantLock());
        try {
            lock.lock();
            ReentrantLock existingLock = this.cacheInteractions.putIfAbsent(id, lock);
            if (existingLock != lock) {
                logger.debugf("Concurrent execution detected for realm '%s'.", (Object)id);
            }
            T t = compute.apply(id, session);
            return t;
        }
        finally {
            lock.unlock();
            this.cacheInteractions.remove(id, lock);
        }
    }
}

