/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.validator;

import com.webauthn4j.server.CoreServerProperty;
import com.webauthn4j.util.AssertUtil;
import com.webauthn4j.util.MessageDigestUtil;
import com.webauthn4j.validator.exception.BadRpIdException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.Arrays;
import org.checkerframework.checker.nullness.qual.NonNull;

class RpIdHashValidator {
    RpIdHashValidator() {
    }

    public void validate(@NonNull byte[] rpIdHash, @NonNull CoreServerProperty serverProperty) {
        AssertUtil.notNull((Object)rpIdHash, (String)"rpIdHash must not be null");
        AssertUtil.notNull((Object)serverProperty, (String)"serverProperty must not be null");
        String rpId = serverProperty.getRpId();
        AssertUtil.notNull((Object)rpId, (String)"rpId must not be null");
        MessageDigest messageDigest = MessageDigestUtil.createSHA256();
        byte[] relyingPartyRpIdBytes = rpId.getBytes(StandardCharsets.UTF_8);
        byte[] relyingPartyRpIdHash = messageDigest.digest(relyingPartyRpIdBytes);
        if (!Arrays.equals(rpIdHash, relyingPartyRpIdHash)) {
            throw new BadRpIdException("rpIdHash doesn't match the hash of preconfigured rpId.");
        }
    }
}

