/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.graph;

import org.rrd4j.graph.FindUnit;

class ValueScaler {
    private final double base;
    private double magfact = -1.0;
    private String unit;

    ValueScaler(double base) {
        this.base = base;
    }

    Scaled scale(double value, boolean mustRescale) {
        Scaled scaled;
        if (Double.isNaN(value)) {
            value = 0.0;
        }
        if (mustRescale) {
            scaled = this.rescale(value);
        } else if (this.magfact >= 0.0) {
            scaled = new Scaled(value / this.magfact, this.unit);
        } else {
            scaled = this.rescale(value);
            if (scaled.value == 0.0 || Double.isNaN(scaled.value)) {
                this.magfact = -1.0;
            }
        }
        return scaled;
    }

    private Scaled rescale(double value) {
        int sindex;
        if (value == 0.0 || Double.isNaN(value)) {
            sindex = 0;
            this.magfact = 1.0;
        } else {
            sindex = (int)Math.floor(Math.log(Math.abs(value)) / Math.log(this.base));
            this.magfact = Math.pow(this.base, sindex);
        }
        this.unit = String.valueOf(FindUnit.resolveSymbol(sindex));
        if (this.unit.equals("m")) {
            this.unit = "";
            this.magfact *= 1000.0;
        }
        return new Scaled(value / this.magfact, this.unit);
    }

    static class Scaled {
        final double value;
        final String unit;

        public Scaled(double value, String unit) {
            this.value = value;
            this.unit = unit;
        }

        void dump() {
            System.out.println("[" + this.value + this.unit + "]");
        }
    }
}

