/*
 * Decompiled with CFR 0.152.
 */
package org.rrd4j.core.jrrd;

import java.io.PrintStream;
import java.text.NumberFormat;
import org.rrd4j.core.jrrd.DataSourceType;
import org.rrd4j.core.jrrd.PDPStatusBlock;
import org.rrd4j.core.jrrd.RRDFile;
import org.rrd4j.core.jrrd.UnivalArray;

public class DataSource {
    private final long offset;
    private final long size;
    private final String name;
    private final DataSourceType type;
    private final int minimumHeartbeat;
    private final double minimum;
    private final double maximum;
    private PDPStatusBlock pdpStatusBlock;

    DataSource(RRDFile file) {
        this.offset = file.getFilePointer();
        this.name = file.readString(20);
        this.type = DataSourceType.valueOf(file.readString(20).toUpperCase());
        UnivalArray par = file.getUnivalArray(10);
        this.minimumHeartbeat = (int)par.getLong(ds_param_en.DS_mrhb_cnt);
        this.minimum = par.getDouble(ds_param_en.DS_min_val);
        this.maximum = par.getDouble(ds_param_en.DS_max_val);
        this.size = file.getFilePointer() - this.offset;
    }

    void loadPDPStatusBlock(RRDFile file) {
        this.pdpStatusBlock = new PDPStatusBlock(file);
    }

    public PDPStatusBlock getPDPStatusBlock() {
        return this.pdpStatusBlock;
    }

    public int getMinimumHeartbeat() {
        return this.minimumHeartbeat;
    }

    public double getMinimum() {
        return this.minimum;
    }

    public DataSourceType getType() {
        return this.type;
    }

    public double getMaximum() {
        return this.maximum;
    }

    public String getName() {
        return this.name;
    }

    void printInfo(PrintStream s, NumberFormat numberFormat) {
        StringBuilder sb = new StringBuilder("ds[");
        sb.append(this.name);
        s.print(sb);
        s.print("].type = \"");
        s.print((Object)this.type);
        s.println("\"");
        s.print(sb);
        s.print("].minimal_heartbeat = ");
        s.println(this.minimumHeartbeat);
        s.print(sb);
        s.print("].min = ");
        s.println(Double.isNaN(this.minimum) ? "NaN" : numberFormat.format(this.minimum));
        s.print(sb);
        s.print("].max = ");
        s.println(Double.isNaN(this.maximum) ? "NaN" : numberFormat.format(this.maximum));
        s.print(sb);
        s.print("].last_ds = ");
        s.println(this.pdpStatusBlock.lastReading);
        s.print(sb);
        s.print("].value = ");
        double value = this.pdpStatusBlock.value;
        s.println(Double.isNaN(value) ? "NaN" : numberFormat.format(value));
        s.print(sb);
        s.print("].unknown_sec = ");
        s.println(this.pdpStatusBlock.unknownSeconds);
    }

    void toXml(PrintStream s) {
        s.println("\t<ds>");
        s.print("\t\t<name> ");
        s.print(this.name);
        s.println(" </name>");
        s.print("\t\t<type> ");
        s.print((Object)this.type);
        s.println(" </type>");
        s.print("\t\t<minimal_heartbeat> ");
        s.print(this.minimumHeartbeat);
        s.println(" </minimal_heartbeat>");
        s.print("\t\t<min> ");
        s.print(this.minimum);
        s.println(" </min>");
        s.print("\t\t<max> ");
        s.print(this.maximum);
        s.println(" </max>");
        s.println();
        s.println("\t\t<!-- PDP Status -->");
        s.print("\t\t<last_ds> ");
        s.print(this.pdpStatusBlock.lastReading);
        s.println(" </last_ds>");
        s.print("\t\t<value> ");
        s.print(this.pdpStatusBlock.value);
        s.println(" </value>");
        s.print("\t\t<unknown_sec> ");
        s.print(this.pdpStatusBlock.unknownSeconds);
        s.println(" </unknown_sec>");
        s.println("\t</ds>");
        s.println();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("[DataSource: OFFSET=0x");
        sb.append(Long.toHexString(this.offset));
        sb.append(", SIZE=0x");
        sb.append(Long.toHexString(this.size));
        sb.append(", name=");
        sb.append(this.name);
        sb.append(", type=");
        sb.append(this.type.toString());
        sb.append(", minHeartbeat=");
        sb.append(this.minimumHeartbeat);
        sb.append(", min=");
        sb.append(this.minimum);
        sb.append(", max=");
        sb.append(this.maximum);
        sb.append("]");
        sb.append("\n\t\t");
        sb.append(this.pdpStatusBlock.toString());
        return sb.toString();
    }

    private static enum ds_param_en {
        DS_mrhb_cnt,
        DS_min_val,
        DS_max_val,
        DS_cde;

    }
}

