/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.util.concurrent.atomic.AtomicLong;

public class JobStats {
    private final String _job;
    private final AtomicLong _numRuns = new AtomicLong();
    private final AtomicLong _numDropped = new AtomicLong();
    private final AtomicLong _totalTime = new AtomicLong();
    private volatile long _maxTime;
    private volatile long _minTime;
    private final AtomicLong _totalPendingTime = new AtomicLong();
    private volatile long _maxPendingTime;
    private volatile long _minPendingTime;

    public JobStats(String name) {
        this._job = name;
        this._maxTime = -1L;
        this._minTime = -1L;
        this._maxPendingTime = -1L;
        this._minPendingTime = -1L;
    }

    public void jobRan(long runTime, long lag) {
        this._numRuns.incrementAndGet();
        this._totalTime.addAndGet(runTime);
        if (this._maxTime < 0L || runTime > this._maxTime) {
            this._maxTime = runTime;
        }
        if (this._minTime < 0L || runTime < this._minTime) {
            this._minTime = runTime;
        }
        this._totalPendingTime.addAndGet(lag);
        if (this._maxPendingTime < 0L || lag > this._maxPendingTime) {
            this._maxPendingTime = lag;
        }
        if (this._minPendingTime < 0L || lag < this._minPendingTime) {
            this._minPendingTime = lag;
        }
    }

    public void jobDropped() {
        this._numDropped.incrementAndGet();
    }

    public long getDropped() {
        return this._numDropped.get();
    }

    public String getName() {
        return this._job;
    }

    public long getRuns() {
        return this._numRuns.get();
    }

    public long getTotalTime() {
        return this._totalTime.get();
    }

    public long getMaxTime() {
        return this._maxTime;
    }

    public long getMinTime() {
        return this._minTime;
    }

    public double getAvgTime() {
        long numRuns = this._numRuns.get();
        if (numRuns > 0L) {
            return (double)this._totalTime.get() / (double)numRuns;
        }
        return 0.0;
    }

    public long getTotalPendingTime() {
        return this._totalPendingTime.get();
    }

    public long getMaxPendingTime() {
        return this._maxPendingTime;
    }

    public long getMinPendingTime() {
        return this._minPendingTime;
    }

    public double getAvgPendingTime() {
        long numRuns = this._numRuns.get();
        if (numRuns > 0L) {
            return (double)this._totalPendingTime.get() / (double)numRuns;
        }
        return 0.0;
    }
}

