/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.sam;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import net.i2p.client.I2PSession;
import net.i2p.client.I2PSessionException;
import net.i2p.data.DataFormatException;
import net.i2p.sam.SAMMessageSession;
import net.i2p.sam.SAMRawReceiver;

class SAMRawSession
extends SAMMessageSession {
    public static final int RAW_SIZE_MAX = 32768;
    protected SAMRawReceiver recv;

    protected SAMRawSession(String dest, Properties props, SAMRawReceiver recv) throws IOException, DataFormatException, I2PSessionException {
        super(dest, props);
        this.recv = recv;
    }

    public SAMRawSession(InputStream destStream, Properties props, SAMRawReceiver recv) throws IOException, DataFormatException, I2PSessionException {
        super(destStream, props);
        this.recv = recv;
    }

    protected SAMRawSession(I2PSession sess, Properties props, int listenProtocol, int listenPort, SAMRawReceiver recv) throws IOException, DataFormatException, I2PSessionException {
        super(sess, listenProtocol, listenPort);
        this.recv = recv;
    }

    @Override
    public boolean sendBytes(String dest, byte[] data, int proto, int fromPort, int toPort) throws DataFormatException, I2PSessionException {
        if (data.length > 32768) {
            throw new DataFormatException("Data size limit exceeded (" + data.length + ")");
        }
        if (proto == 0) {
            proto = 18;
        }
        return this.sendBytesThroughMessageSession(dest, data, proto, fromPort, toPort);
    }

    @Override
    public boolean sendBytes(String dest, byte[] data, int proto, int fromPort, int toPort, boolean sendLeaseSet, int sendTags, int tagThreshold, int expiration) throws DataFormatException, I2PSessionException {
        if (data.length > 32768) {
            throw new DataFormatException("Data size limit exceeded (" + data.length + ")");
        }
        if (proto == 0) {
            proto = 18;
        }
        return this.sendBytesThroughMessageSession(dest, data, proto, fromPort, toPort, sendLeaseSet, sendTags, tagThreshold, expiration);
    }

    @Override
    protected void messageReceived(byte[] msg, int proto, int fromPort, int toPort) {
        try {
            this.recv.receiveRawBytes(msg, proto, fromPort, toPort);
        }
        catch (IOException e) {
            this._log.error("Error forwarding message to receiver", e);
            this.close();
        }
    }

    @Override
    protected void shutDown() {
        this.recv.stopRawReceiving();
    }
}

