/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.i2p.data.DataHelper;

public class LookaheadInputStream
extends FilterInputStream {
    private boolean _eofReached;
    private final byte[] _footerLookahead;
    private final int size;
    private int index;
    private static final InputStream _fakeInputStream = new ByteArrayInputStream(new byte[0]);

    public LookaheadInputStream(int lookaheadSize) {
        super(_fakeInputStream);
        this._footerLookahead = new byte[lookaheadSize];
        this.size = lookaheadSize;
    }

    public boolean getEOFReached() {
        return this._eofReached;
    }

    public void initialize(InputStream src) throws IOException {
        this.in = src;
        this._eofReached = false;
        this.index = 0;
        DataHelper.read(this.in, this._footerLookahead);
    }

    @Override
    public int read() throws IOException {
        if (this._eofReached) {
            return -1;
        }
        int c = this.in.read();
        if (c == -1) {
            this._eofReached = true;
            return -1;
        }
        int rv = this._footerLookahead[this.index] & 0xFF;
        this._footerLookahead[this.index] = (byte)c;
        ++this.index;
        if (this.index >= this.size) {
            this.index = 0;
        }
        return rv;
    }

    @Override
    public int read(byte[] buf, int off, int len) throws IOException {
        if (this._eofReached) {
            return -1;
        }
        for (int i = 0; i < len; ++i) {
            int c = this.read();
            if (c == -1) {
                if (i == 0) {
                    return -1;
                }
                return i;
            }
            buf[off + i] = (byte)c;
        }
        return len;
    }

    public byte[] getFooter() {
        if (this.index == 0) {
            return this._footerLookahead;
        }
        byte[] rv = new byte[this.size];
        System.arraycopy(this._footerLookahead, this.index, rv, 0, this.size - this.index);
        System.arraycopy(this._footerLookahead, 0, rv, this.size - this.index, this.index);
        return rv;
    }

    @Override
    public long skip(long n) throws IOException {
        int c;
        long rv;
        for (rv = 0L; rv < n && (c = this.read()) >= 0; ++rv) {
        }
        return rv;
    }
}

