/*
 * Decompiled with CFR 0.152.
 */
package org.klomp.snark;

import net.i2p.I2PAppContext;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;
import net.i2p.util.SyntheticREDQueue;
import org.klomp.snark.BandwidthListener;
import org.klomp.snark.Peer;

public class BandwidthManager
implements BandwidthListener {
    private final I2PAppContext _context;
    private final Log _log;
    private SyntheticREDQueue _up;
    private SyntheticREDQueue _down;
    private SyntheticREDQueue _req;

    BandwidthManager(I2PAppContext ctx, int upLimit, int downLimit) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(BandwidthManager.class);
        this._up = new SyntheticREDQueue(ctx, upLimit);
        this._down = new SyntheticREDQueue(ctx, downLimit);
        this._req = new SyntheticREDQueue(ctx, downLimit * 110 / 100);
    }

    void setUpBWLimit(long upLimit) {
        int limit = (int)Math.min(upLimit, Integer.MAX_VALUE);
        if ((long)limit != this.getUpBWLimit()) {
            this._up = new SyntheticREDQueue(this._context, limit);
        }
    }

    void setDownBWLimit(long downLimit) {
        int limit = (int)Math.min(downLimit, Integer.MAX_VALUE);
        if ((long)limit != this.getDownBWLimit()) {
            this._down = new SyntheticREDQueue(this._context, limit);
            this._req = new SyntheticREDQueue(this._context, limit * 110 / 100);
        }
    }

    long getRequestRate() {
        return (long)(1000.0f * this._req.getBandwidthEstimate());
    }

    @Override
    public long getUploadRate() {
        return (long)(1000.0f * this._up.getBandwidthEstimate());
    }

    @Override
    public long getDownloadRate() {
        return (long)(1000.0f * this._down.getBandwidthEstimate());
    }

    @Override
    public void uploaded(int size) {
        this._up.addSample(size);
    }

    @Override
    public void downloaded(int size) {
        this._down.addSample(size);
    }

    @Override
    public boolean shouldSend(int size) {
        boolean rv = this._up.offer(size, 1.0f);
        if (!rv && this._log.shouldWarn()) {
            this._log.warn("Deny sending " + size + " bytes, upload rate " + DataHelper.formatSize(this.getUploadRate()) + "Bps");
        }
        return rv;
    }

    @Override
    public boolean shouldRequest(Peer peer, int size) {
        boolean rv;
        boolean bl = rv = !this.overDownBWLimit() && this._req.offer(size, 1.0f);
        if (!rv && this._log.shouldWarn()) {
            this._log.warn("Deny requesting " + size + " bytes, download rate " + DataHelper.formatSize(this.getDownloadRate()) + "Bps, request rate " + DataHelper.formatSize(this.getRequestRate()) + "Bps");
        }
        return rv;
    }

    @Override
    public long getUpBWLimit() {
        return this._up.getMaxBandwidth();
    }

    @Override
    public long getDownBWLimit() {
        return this._down.getMaxBandwidth();
    }

    @Override
    public boolean overUpBWLimit() {
        return this.getUploadRate() > this.getUpBWLimit();
    }

    @Override
    public boolean overDownBWLimit() {
        return this.getDownloadRate() > this.getDownBWLimit();
    }

    public String toString() {
        return "<br><b>Bandwidth Limiters</b><br><b>Up:</b> " + this._up + "<br><b>Down:</b> " + this._down + "<br><b>Req:</b> " + this._req + "<br>";
    }
}

