/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.transform;

import java.util.ArrayList;
import java.util.List;
import org.olap4j.Axis;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.Position;
import org.olap4j.metadata.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransformUtil {
    TransformUtil() {
    }

    public static CellSetAxis getCellSetAxisFromCellSet(Axis axis, CellSet cellSet) {
        for (CellSetAxis a : cellSet.getAxes()) {
            if (a.getAxisOrdinal() != axis) continue;
            return a;
        }
        throw new IndexOutOfBoundsException();
    }

    public static Position getPositionFromCellSet(Axis axis, int positionOrdinalInAxis, CellSet cellSet) {
        CellSetAxis a = TransformUtil.getCellSetAxisFromCellSet(axis, cellSet);
        return a.getPositions().get(positionOrdinalInAxis);
    }

    public static Member getMemberFromCellSet(Axis axis, int positionOrdinalInAxis, int memberOrdinalInPosition, CellSet cellSet) {
        Position p = TransformUtil.getPositionFromCellSet(axis, positionOrdinalInAxis, cellSet);
        return p.getMembers().get(memberOrdinalInPosition);
    }

    public static List<Member> getPathToMember(Position p, int memberOrdinalInPosition) {
        ArrayList<Member> pathToMember = new ArrayList<Member>();
        for (int i = 0; i < memberOrdinalInPosition; ++i) {
            pathToMember.add(p.getMembers().get(i));
        }
        return pathToMember;
    }
}

