/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.update;

import java.sql.SQLException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStep;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.update.Messages;
import org.pentaho.di.trans.steps.update.UpdateData;
import org.pentaho.di.trans.steps.update.UpdateMeta;

public class Update
extends BaseStep
implements StepInterface {
    private UpdateMeta meta;
    private UpdateData data;

    public Update(StepMeta stepMeta, StepDataInterface stepDataInterface, int copyNr, TransMeta transMeta, Trans trans) {
        super(stepMeta, stepDataInterface, copyNr, transMeta, trans);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private synchronized Object[] lookupValues(RowMetaInterface rowMeta, Object[] row) throws KettleException {
        Object[] add;
        Object[] outputRow = row;
        if (!Const.isEmpty((String)this.meta.getIgnoreFlagField())) {
            outputRow = new Object[this.data.outputRowMeta.size()];
            for (int i = 0; i < rowMeta.size(); ++i) {
                outputRow[i] = row[i];
            }
        }
        Object[] lookupRow = new Object[this.data.lookupParameterRowMeta.size()];
        int lookupIndex = 0;
        for (int i = 0; i < this.meta.getKeyStream().length; ++i) {
            if (this.data.keynrs[i] >= 0) {
                lookupRow[lookupIndex] = row[this.data.keynrs[i]];
                ++lookupIndex;
            }
            if (this.data.keynrs2[i] < 0) continue;
            lookupRow[lookupIndex] = row[this.data.keynrs2[i]];
            ++lookupIndex;
        }
        RowMetaInterface returnRowMeta = null;
        if (!this.meta.isSkipLookup()) {
            this.data.db.setValues(this.data.lookupParameterRowMeta, lookupRow, this.data.prepStatementLookup);
            if (this.log.isDebug()) {
                this.logDebug(Messages.getString("Update.Log.ValuesSetForLookup", this.data.lookupParameterRowMeta.getString(lookupRow), rowMeta.getString(row)));
            }
            add = this.data.db.getLookup(this.data.prepStatementLookup);
            returnRowMeta = this.data.db.getReturnRowMeta();
        } else {
            add = null;
        }
        this.incrementLinesInput();
        if (add == null && !this.meta.isSkipLookup()) {
            if (!this.meta.isErrorIgnored()) {
                if (!this.getStepMeta().isDoingErrorHandling()) throw new KettleDatabaseException(Messages.getString("Update.Exception.KeyCouldNotFound") + this.data.lookupParameterRowMeta.getString(lookupRow));
                outputRow = null;
                if (this.data.stringErrorKeyNotFound == null) {
                    this.data.stringErrorKeyNotFound = Messages.getString("Update.Exception.KeyCouldNotFound") + this.data.lookupParameterRowMeta.getString(lookupRow);
                    this.data.stringFieldnames = "";
                    for (int i = 0; i < this.data.lookupParameterRowMeta.size(); ++i) {
                        if (i > 0) {
                            this.data.stringFieldnames = this.data.stringFieldnames + ", ";
                        }
                        this.data.stringFieldnames = this.data.stringFieldnames + this.data.lookupParameterRowMeta.getValueMeta(i).getName();
                    }
                }
                this.putError(rowMeta, row, 1L, this.data.stringErrorKeyNotFound, this.data.stringFieldnames, "UPD001");
                return outputRow;
            } else {
                if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), Messages.getString("Update.Log.KeyCouldNotFound") + this.data.lookupParameterRowMeta.getString(lookupRow), new Object[0]);
                }
                if (Const.isEmpty((String)this.meta.getIgnoreFlagField())) return outputRow;
                outputRow[rowMeta.size()] = Boolean.FALSE;
            }
            return outputRow;
        } else {
            if (!this.meta.isSkipLookup() && this.log.isRowLevel()) {
                this.logRowlevel(Messages.getString("Update.Log.FoundRow") + this.data.lookupReturnRowMeta.getString(add));
            }
            boolean update = false;
            if (this.meta.isSkipLookup()) {
                update = true;
            } else {
                for (int i = 0; i < this.data.valuenrs.length; ++i) {
                    Object retvalue;
                    ValueMetaInterface returnValueMeta;
                    Object rowvalue;
                    ValueMetaInterface valueMeta = rowMeta.getValueMeta(this.data.valuenrs[i]);
                    if (valueMeta.compare(rowvalue = row[this.data.valuenrs[i]], returnValueMeta = returnRowMeta.getValueMeta(i), retvalue = add[i]) == 0) continue;
                    update = true;
                }
            }
            if (update) {
                int i;
                Object[] updateRow = new Object[this.data.updateParameterRowMeta.size()];
                for (i = 0; i < this.data.valuenrs.length; ++i) {
                    updateRow[i] = row[this.data.valuenrs[i]];
                }
                for (i = 0; i < lookupRow.length; ++i) {
                    updateRow[this.data.valuenrs.length + i] = lookupRow[i];
                }
                if (this.log.isRowLevel()) {
                    this.logRowlevel(Messages.getString("Update.Log.UpdateRow") + this.data.lookupParameterRowMeta.getString(lookupRow));
                }
                this.data.db.setValues(this.data.updateParameterRowMeta, updateRow, this.data.prepStatementUpdate);
                this.data.db.insertRow(this.data.prepStatementUpdate);
                this.incrementLinesUpdated();
            } else {
                this.incrementLinesSkipped();
            }
            if (Const.isEmpty((String)this.meta.getIgnoreFlagField())) return outputRow;
            outputRow[rowMeta.size()] = Boolean.TRUE;
        }
        return outputRow;
    }

    public boolean processRow(StepMetaInterface smi, StepDataInterface sdi) throws KettleException {
        block17: {
            this.meta = (UpdateMeta)smi;
            this.data = (UpdateData)sdi;
            boolean sendToErrorRow = false;
            String errorMessage = null;
            Object[] r = this.getRow();
            if (r == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                int i;
                this.first = false;
                this.data.outputRowMeta = this.getInputRowMeta().clone();
                this.meta.getFields(this.data.outputRowMeta, this.getStepname(), null, null, this);
                this.data.schemaTable = this.meta.getDatabaseMeta().getQuotedSchemaTableCombination(this.environmentSubstitute(this.meta.getSchemaName()), this.environmentSubstitute(this.meta.getTableName()));
                if (this.log.isDetailed()) {
                    this.logDetailed(Messages.getString("Update.Log.CheckingRow") + this.getInputRowMeta().getString(r));
                }
                this.data.keynrs = new int[this.meta.getKeyStream().length];
                this.data.keynrs2 = new int[this.meta.getKeyStream().length];
                for (i = 0; i < this.meta.getKeyStream().length; ++i) {
                    this.data.keynrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getKeyStream()[i]);
                    if (this.data.keynrs[i] < 0 && !"IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) && !"IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                        throw new KettleStepException(Messages.getString("Update.Exception.FieldRequired", this.meta.getKeyStream()[i]));
                    }
                    this.data.keynrs2[i] = this.getInputRowMeta().indexOfValue(this.meta.getKeyStream2()[i]);
                    if (this.data.keynrs2[i] < 0 && "BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                        throw new KettleStepException(Messages.getString("Update.Exception.FieldRequired", this.meta.getKeyStream2()[i]));
                    }
                    if (!this.log.isDebug()) continue;
                    this.logDebug(Messages.getString("Update.Log.FieldHasDataNumbers", this.meta.getKeyStream()[i]) + "" + this.data.keynrs[i]);
                }
                this.data.valuenrs = new int[this.meta.getUpdateLookup().length];
                for (i = 0; i < this.meta.getUpdateLookup().length; ++i) {
                    this.data.valuenrs[i] = this.getInputRowMeta().indexOfValue(this.meta.getUpdateStream()[i]);
                    if (this.data.valuenrs[i] < 0) {
                        throw new KettleStepException(Messages.getString("Update.Exception.FieldRequired", this.meta.getUpdateStream()[i]));
                    }
                    if (!this.log.isDebug()) continue;
                    this.logDebug(Messages.getString("Update.Log.FieldHasDataNumbers", this.meta.getUpdateStream()[i]) + "" + this.data.valuenrs[i]);
                }
                if (this.meta.isSkipLookup()) {
                    this.data.lookupParameterRowMeta = new RowMeta();
                    for (i = 0; i < this.meta.getKeyLookup().length; ++i) {
                        if ("BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                            this.data.lookupParameterRowMeta.addValueMeta(this.getInputRowMeta().searchValueMeta(this.meta.getKeyStream()[i]));
                            this.data.lookupParameterRowMeta.addValueMeta(this.getInputRowMeta().searchValueMeta(this.meta.getKeyStream2()[i]));
                            continue;
                        }
                        if ("IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) || "IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) continue;
                        this.data.lookupParameterRowMeta.addValueMeta(this.getInputRowMeta().searchValueMeta(this.meta.getKeyStream()[i]));
                    }
                } else {
                    this.setLookup(this.getInputRowMeta());
                }
                this.prepareUpdate(this.getInputRowMeta());
            }
            try {
                Object[] outputRow = this.lookupValues(this.getInputRowMeta(), r);
                if (outputRow != null) {
                    this.putRow(this.data.outputRowMeta, outputRow);
                }
                if (this.checkFeedback(this.getLinesRead()) && this.log.isBasic()) {
                    this.logBasic(Messages.getString("Update.Log.LineNumber") + this.getLinesRead());
                }
            }
            catch (KettleException e) {
                if (!this.getStepMeta().isDoingErrorHandling()) {
                    this.logError(Messages.getString("Update.Log.ErrorInStep"), e);
                    this.setErrors(1L);
                    this.stopAll();
                    this.setOutputDone();
                    return false;
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block17;
                this.putError(this.getInputRowMeta(), r, 1L, errorMessage, null, "UPD001");
            }
        }
        return true;
    }

    public void setLookup(RowMetaInterface rowMeta) throws KettleDatabaseException {
        int i;
        this.data.lookupParameterRowMeta = new RowMeta();
        this.data.lookupReturnRowMeta = new RowMeta();
        DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
        String sql = "SELECT ";
        for (i = 0; i < this.meta.getUpdateLookup().length; ++i) {
            if (i != 0) {
                sql = sql + ", ";
            }
            sql = sql + databaseMeta.quoteField(this.meta.getUpdateLookup()[i]);
            this.data.lookupReturnRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getUpdateStream()[i]));
        }
        sql = sql + " FROM " + this.data.schemaTable + " WHERE ";
        for (i = 0; i < this.meta.getKeyLookup().length; ++i) {
            if (i != 0) {
                sql = sql + " AND ";
            }
            sql = sql + databaseMeta.quoteField(this.meta.getKeyLookup()[i]);
            if ("BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " BETWEEN ? AND ? ";
                this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
                this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream2()[i]));
                continue;
            }
            if ("IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) || "IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " " + this.meta.getKeyCondition()[i] + " ";
                continue;
            }
            sql = sql + " " + this.meta.getKeyCondition()[i] + " ? ";
            this.data.lookupParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
        }
        try {
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "Setting preparedStatement to [" + sql + "]", new Object[0]);
            }
            this.data.prepStatementLookup = this.data.db.getConnection().prepareStatement(databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to prepare statement for SQL statement [" + sql + "]", (Throwable)ex);
        }
    }

    public void prepareUpdate(RowMetaInterface rowMeta) throws KettleDatabaseException {
        int i;
        DatabaseMeta databaseMeta = this.meta.getDatabaseMeta();
        this.data.updateParameterRowMeta = new RowMeta();
        String sql = "UPDATE " + this.data.schemaTable + Const.CR;
        sql = sql + "SET ";
        for (i = 0; i < this.meta.getUpdateLookup().length; ++i) {
            if (i != 0) {
                sql = sql + ",   ";
            }
            sql = sql + databaseMeta.quoteField(this.meta.getUpdateLookup()[i]);
            sql = sql + " = ?" + Const.CR;
            this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getUpdateStream()[i]));
        }
        sql = sql + "WHERE ";
        for (i = 0; i < this.meta.getKeyLookup().length; ++i) {
            if (i != 0) {
                sql = sql + "AND   ";
            }
            sql = sql + databaseMeta.quoteField(this.meta.getKeyLookup()[i]);
            if ("BETWEEN".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " BETWEEN ? AND ? ";
                this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
                this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream2()[i]));
                continue;
            }
            if ("IS NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i]) || "IS NOT NULL".equalsIgnoreCase(this.meta.getKeyCondition()[i])) {
                sql = sql + " " + this.meta.getKeyCondition()[i] + " ";
                continue;
            }
            sql = sql + " " + this.meta.getKeyCondition()[i] + " ? ";
            this.data.updateParameterRowMeta.addValueMeta(rowMeta.searchValueMeta(this.meta.getKeyStream()[i]));
        }
        try {
            if (this.log.isDetailed()) {
                this.log.logDetailed(this.toString(), "Setting update preparedStatement to [" + sql + "]", new Object[0]);
            }
            this.data.prepStatementUpdate = this.data.db.getConnection().prepareStatement(databaseMeta.stripCR(sql));
        }
        catch (SQLException ex) {
            throw new KettleDatabaseException("Unable to prepare statement for SQL statement [" + sql + "]", (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean init(StepMetaInterface smi, StepDataInterface sdi) {
        this.meta = (UpdateMeta)smi;
        this.data = (UpdateData)sdi;
        if (super.init(smi, sdi)) {
            this.data.db = new Database(this.meta.getDatabaseMeta());
            this.data.db.shareVariablesWith((VariableSpace)this);
            try {
                if (this.getTransMeta().isUsingUniqueConnections()) {
                    Trans trans = this.getTrans();
                    synchronized (trans) {
                        this.data.db.connect(this.getTrans().getThreadName(), this.getPartitionID());
                    }
                } else {
                    this.data.db.connect(this.getPartitionID());
                }
                if (this.log.isDetailed()) {
                    this.logDetailed(Messages.getString("Update.Log.ConnectedToDB"));
                }
                this.data.db.setCommit(this.meta.getCommitSize());
                return true;
            }
            catch (KettleException ke) {
                this.logError(Messages.getString("Update.Log.ErrorOccurred") + ke.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dispose(StepMetaInterface smi, StepDataInterface sdi) {
        block9: {
            this.meta = (UpdateMeta)smi;
            this.data = (UpdateData)sdi;
            try {
                try {
                    if (!this.data.db.isAutoCommit()) {
                        if (this.getErrors() == 0L) {
                            this.data.db.commit();
                        } else {
                            this.data.db.rollback();
                        }
                    }
                    this.data.db.closePreparedStatement(this.data.prepStatementUpdate);
                    this.data.db.closePreparedStatement(this.data.prepStatementLookup);
                }
                catch (KettleDatabaseException e) {
                    this.log.logError(this.toString(), Messages.getString("Update.Log.UnableToCommitUpdateConnection") + this.data.db + "] :" + e.toString(), new Object[0]);
                    this.setErrors(1L);
                    Object var5_4 = null;
                    if (this.data.db != null) {
                        this.data.db.disconnect();
                    }
                    break block9;
                }
                Object var5_3 = null;
                if (this.data.db == null) break block9;
            }
            catch (Throwable throwable) {
                Object var5_5 = null;
                if (this.data.db != null) {
                    this.data.db.disconnect();
                }
                throw throwable;
            }
            this.data.db.disconnect();
        }
        super.dispose(smi, sdi);
    }

    public String toString() {
        return this.getClass().getName();
    }

    public void run() {
        BaseStep.runStepThread(this, this.meta, this.data);
    }
}

